/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.service;

import com.iplanet.dpro.session.service.SessionService;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Map;
import java.util.Set;

public class SessionConfigListener
implements ServiceListener {
    private static String SESSION_SERVICE_NAME = "iPlanetAMSessionService";
    private static final String SESSION_RETRIEVAL_TIMEOUT = "iplanet-am-session-session-list-retrieval-timeout";
    private static final String MAX_SESSION_LIST_SIZE = "iplanet-am-session-max-session-list-size";
    private static final String SESSION_CONSTRAINT = "iplanet-am-session-enable-session-constraint";
    private static final String DENY_LOGIN_IF_DB_IS_DOWN = "iplanet-am-session-deny-login-if-db-is-down";
    private static final String BYPASS_CONSTRAINT_ON_TOPLEVEL_ADMINS = "iplanet-am-session-enable-session-constraint-bypass-topleveladmin";
    private static final String CONSTARINT_RESULTING_BEHAVIOR = "iplanet-am-session-constraint-resulting-behavior";
    private static final String DESTROY_OLD_SESSION = "DESTROY_OLD_SESSION";
    private static final String DENY_ACCESS = "DENY_ACCESS";
    private static final String MAX_WAIT_TIME_FOR_CONSTRAINT = "iplanet-am-session-constraint-max-wait-time";
    private static long defSessionRetrievalTimeout;
    private static int defMaxSessionListSize;
    private static Debug debug;
    private static ServiceSchemaManager sSchemaMgr;
    public static long defSessionRetrievalTimeoutLong;
    public static int defMaxSessionListSizeInt;
    public static String defSessionRetrievalTimeoutStr;
    public static String defMaxSessionListSizeStr;
    private static String enablePropertyNotificationStr;
    public static String defmaxWaitTimeForConstraintStr;

    public SessionConfigListener(ServiceSchemaManager ssm) {
        sSchemaMgr = ssm;
    }

    public void schemaChanged(String serviceName, String version) {
        if (serviceName != null && !serviceName.equalsIgnoreCase(SESSION_SERVICE_NAME)) {
            return;
        }
        try {
            ServiceSchema schema = sSchemaMgr.getGlobalSchema();
            Map attrs = schema.getAttributeDefaults();
            defSessionRetrievalTimeoutStr = CollectionHelper.getMapAttr((Map)attrs, (String)SESSION_RETRIEVAL_TIMEOUT, (String)defSessionRetrievalTimeoutStr);
            defMaxSessionListSizeStr = CollectionHelper.getMapAttr((Map)attrs, (String)MAX_SESSION_LIST_SIZE, (String)defMaxSessionListSizeStr);
            enablePropertyNotificationStr = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-session-property-change-notification", (String)"OFF");
            if (enablePropertyNotificationStr.equalsIgnoreCase("ON")) {
                SessionService.setPropertyNotificationEnabled(true);
                Set notProp = (Set)attrs.get("iplanet-am-session-notification-property-list");
                SessionService.setNotificationProperties(notProp);
            } else {
                SessionService.setPropertyNotificationEnabled(false);
            }
            String enableSessionTrimmingStr = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-session-enable-session-trimming", (String)"NO");
            if (enableSessionTrimmingStr.equalsIgnoreCase("YES")) {
                SessionService.setSessionTrimmingEnabled(true);
            } else {
                SessionService.setSessionTrimmingEnabled(false);
            }
            String enableQuotaconstraintsStr = CollectionHelper.getMapAttr((Map)attrs, (String)SESSION_CONSTRAINT, (String)"OFF");
            if (enableQuotaconstraintsStr.equalsIgnoreCase("ON")) {
                SessionService.setSessionConstraintEnabled(true);
            } else {
                SessionService.setSessionConstraintEnabled(false);
            }
            String denyLoginStr = CollectionHelper.getMapAttr((Map)attrs, (String)DENY_LOGIN_IF_DB_IS_DOWN, (String)"NO");
            if (denyLoginStr.equalsIgnoreCase("YES")) {
                SessionService.setDenyLoginIfDBIsDown(true);
            } else {
                SessionService.setDenyLoginIfDBIsDown(false);
            }
            String bypassConstratintStr = CollectionHelper.getMapAttr((Map)attrs, (String)BYPASS_CONSTRAINT_ON_TOPLEVEL_ADMINS, (String)"NO");
            if (bypassConstratintStr.equalsIgnoreCase("YES")) {
                SessionService.setBypassConstraintForToplevelAdmin(true);
            } else {
                SessionService.setBypassConstraintForToplevelAdmin(false);
            }
            String resultingBehaviorStr = CollectionHelper.getMapAttr((Map)attrs, (String)CONSTARINT_RESULTING_BEHAVIOR, (String)DESTROY_OLD_SESSION);
            if (resultingBehaviorStr.equalsIgnoreCase(DESTROY_OLD_SESSION)) {
                SessionService.setConstraintResultingBehavior(1);
            } else if (resultingBehaviorStr.equalsIgnoreCase(DENY_ACCESS)) {
                SessionService.setConstraintResultingBehavior(2);
            }
            defmaxWaitTimeForConstraintStr = CollectionHelper.getMapAttr((Map)attrs, (String)MAX_WAIT_TIME_FOR_CONSTRAINT, (String)defmaxWaitTimeForConstraintStr);
        }
        catch (Exception e) {
            debug.error("SessionConfigListener : Unable to get Session Service attributes", (Throwable)e);
        }
        try {
            defSessionRetrievalTimeout = Long.parseLong(defSessionRetrievalTimeoutStr) * 1000L;
        }
        catch (Exception e) {
            defSessionRetrievalTimeout = defSessionRetrievalTimeoutLong * 1000L;
            debug.error("SessionConfigListener : Unable to parse Timeout values", (Throwable)e);
        }
        try {
            defMaxSessionListSize = Integer.parseInt(defMaxSessionListSizeStr);
        }
        catch (Exception e) {
            defMaxSessionListSize = defMaxSessionListSizeInt;
            debug.error("SessionConfigListener : Unable to parse ListSize values", (Throwable)e);
        }
        int maxWaitTimeForConstraint = 6000;
        try {
            maxWaitTimeForConstraint = Integer.parseInt(defmaxWaitTimeForConstraintStr);
            SessionService.setMaxWaitTimeForConstraint(maxWaitTimeForConstraint);
        }
        catch (Exception e) {
            SessionService.setMaxWaitTimeForConstraint(maxWaitTimeForConstraint);
            debug.message("SessionConfigListener : Unable to parse Wait Time values. Defaulting to 6000 milli seconds", (Throwable)e);
        }
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
    }

    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
    }

    public static long getTimeout() {
        return defSessionRetrievalTimeout;
    }

    public static int getMaxsize() {
        return defMaxSessionListSize;
    }

    static {
        debug = Debug.getInstance((String)"amSession");
        sSchemaMgr = null;
        defSessionRetrievalTimeoutLong = 5L;
        defMaxSessionListSizeInt = 200;
        defSessionRetrievalTimeoutStr = Long.toString(defSessionRetrievalTimeoutLong);
        defMaxSessionListSizeStr = Integer.toString(defMaxSessionListSizeInt);
        enablePropertyNotificationStr = "OFF";
        defmaxWaitTimeForConstraintStr = "6000";
    }
}

