/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.config;

import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.shared.debug.Debug;
import java.io.Serializable;
import org.w3c.dom.Node;

public class AuthConfigurationEntry
implements Serializable {
    private static Debug debug = Debug.getInstance((String)"amAuthConfig");
    private String module = null;
    private String flag = null;
    private String options = null;

    public AuthConfigurationEntry(String module, String flag, String options) throws AMConfigurationException {
        this.checkModule(module);
        this.checkFlag(flag);
        this.module = module;
        this.flag = flag;
        this.options = options;
    }

    protected AuthConfigurationEntry(Node node) throws AMConfigurationException {
        String value;
        if (debug.messageEnabled()) {
            debug.message("AuthConfigEntry, value=" + node.toString());
        }
        if ((value = node.getFirstChild().getNodeValue()) == null || value.length() == 0) {
            debug.error("AuthConfigEntry, invalid value=" + value);
            throw new AMConfigurationException(AMAuthConfigUtils.bundleName, "invalidConfig");
        }
        int pos = (value = value.trim()).indexOf(" ");
        if (pos == -1) {
            debug.error("AuthConfigEntry, invalid value=" + value);
            throw new AMConfigurationException(AMAuthConfigUtils.bundleName, "invalidConfig");
        }
        this.module = value.substring(0, pos);
        if ((pos = (value = value.substring(pos + 1).trim()).indexOf(" ")) == -1) {
            this.flag = value;
        } else {
            this.flag = value.substring(0, pos);
            this.options = value.substring(pos + 1).trim();
        }
        this.checkFlag(this.flag);
    }

    public String toString() {
        if (this.options == null) {
            return this.module + " " + this.flag;
        }
        return this.module + " " + this.flag + " " + this.options;
    }

    public String getLoginModuleName() {
        return this.module;
    }

    public void setLoginModuleName(String moduleName) throws AMConfigurationException {
        this.checkModule(moduleName);
        this.module = moduleName;
    }

    public String getControlFlag() {
        return this.flag;
    }

    public void setControlFlag(String flag) throws AMConfigurationException {
        this.checkFlag(flag);
        this.flag = flag;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    private void checkModule(String module) throws AMConfigurationException {
        if (module == null || module.length() == 0) {
            throw new AMConfigurationException(AMAuthConfigUtils.bundleName, "invalidConfig");
        }
    }

    private void checkFlag(String flag) throws AMConfigurationException {
        if (flag == null || flag.length() == 0) {
            throw new AMConfigurationException(AMAuthConfigUtils.bundleName, "invalidConfig");
        }
        if (!(flag.equalsIgnoreCase("REQUIRED") || flag.equalsIgnoreCase("OPTIONAL") || flag.equalsIgnoreCase("REQUISITE") || flag.equalsIgnoreCase("SUFFICIENT"))) {
            debug.warning("AuthConfigEntry, invalid flag : " + flag);
            throw new AMConfigurationException(AMAuthConfigUtils.bundleName, "invalidConfig");
        }
    }
}

