/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.base.model;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.ISResourceBundle;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.shared.debug.Debug;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class AMResourceBundleCache {
    private static AMResourceBundleCache instance = new AMResourceBundleCache();
    private Map mapBundles = new HashMap(30);
    private Debug debug = Debug.getInstance((String)"amSDK");

    private AMResourceBundleCache() {
    }

    public static AMResourceBundleCache getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundle getResBundle(String name, Locale locale) {
        ResourceBundle resBundle = null;
        HashMap<Locale, ResourceBundle> map = (HashMap<Locale, ResourceBundle>)this.mapBundles.get(name);
        if (map != null) {
            resBundle = (ResourceBundle)map.get(locale);
        }
        if (resBundle == null) {
            try {
                resBundle = ResourceBundle.getBundle(name, locale);
            }
            catch (MissingResourceException mre) {
                resBundle = this.getResourceFromDS(name, locale);
            }
            Map map2 = this.mapBundles;
            synchronized (map2) {
                if (map == null) {
                    map = new HashMap<Locale, ResourceBundle>(5);
                    this.mapBundles.put(name, map);
                }
                map.put(locale, resBundle);
            }
        }
        return resBundle;
    }

    private ResourceBundle getResourceFromDS(String name, Locale locale) {
        ResourceBundle resBundle = null;
        try {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return AMAdminUtils.getSuperAdminSSOToken();
                    }
                    catch (SecurityException e) {
                        AMResourceBundleCache.this.debug.error("AMResourceBundleCache.getResBundle", (Throwable)e);
                        return null;
                    }
                }
            });
            if (adminToken != null) {
                resBundle = ISResourceBundle.getResourceBundle(adminToken, name, locale);
            }
        }
        catch (SSOException ssoe) {
            this.debug.error("AMResourceBundleCache.getResourceFromDS", (Throwable)((Object)ssoe));
        }
        catch (MissingResourceException mre) {
            this.debug.error("AMResourceBundleCache.getResourceFromDS", (Throwable)mre);
        }
        return resBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map map = this.mapBundles;
        synchronized (map) {
            this.mapBundles.clear();
        }
    }
}

