/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.client;

import com.iplanet.services.comm.client.NotificationHandler;
import com.iplanet.services.comm.share.Notification;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.client.PolicyEvaluator;
import com.sun.identity.policy.client.ResourceResultCache;
import com.sun.identity.policy.remote.PolicyNotification;
import com.sun.identity.policy.remote.PolicyService;
import com.sun.identity.shared.debug.Debug;
import java.util.Vector;

public class PolicyNotificationHandler
implements NotificationHandler {
    static Debug debug = PolicyEvaluator.debug;
    private ResourceResultCache resourceResultCache;

    public PolicyNotificationHandler(ResourceResultCache resourceResultCache) {
        this.resourceResultCache = resourceResultCache;
    }

    public void process(Vector notifications) {
        this.processPLLNotifications(notifications);
    }

    void processPLLNotifications(Vector notifications) {
        for (int i = 0; i < notifications.size(); ++i) {
            Notification notification = (Notification)notifications.elementAt(i);
            if (debug.messageEnabled()) {
                debug.message("PolicyNotificationHandler.processPLLNotifications():got notification: " + notification.getContent());
            }
            try {
                PolicyService ps = PolicyService.parseXML(notification.getContent());
                PolicyNotification pn = ps.getPolicyNotification();
                if (pn == null) continue;
                this.processPolicyNotification(pn);
                continue;
            }
            catch (PolicyException pe) {
                debug.error("PolicyNotificationHandler.processPLLNotifications():invalid notifcation format", (Throwable)pe);
            }
        }
    }

    void processPolicyNotification(PolicyNotification pn) {
        try {
            ResourceResultCache.processPolicyNotification(pn);
        }
        catch (Exception e) {
            debug.error("PolicyNotificationHandler.processPolicyNotification():Error while handling policy notification", (Throwable)e);
        }
    }
}

