/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;

public final class Resource {
    public static String read(String fileName, Class cl) {
        String data = "";
        try {
            InputStream in = cl.getResourceAsStream(fileName);
            if (in == null) {
                try {
                    in = new FileInputStream(fileName);
                }
                catch (FileNotFoundException e) {
                    String directoryURL = cl.getProtectionDomain().getCodeSource().getLocation().toString();
                    String fileURL = directoryURL + fileName;
                    URL url = new URL(fileURL);
                    in = url.openStream();
                }
            }
            data = Resource.read(new InputStreamReader(in));
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    public static String read(Reader aReader) {
        StringBuffer sb = new StringBuffer();
        try {
            BufferedReader bReader = new BufferedReader(aReader);
            char[] data = new char[2048];
            int count = 0;
            while ((count = bReader.read(data)) != -1) {
                sb.append(data, 0, count);
            }
            bReader.close();
            aReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static String read(String fileName) {
        return Resource.read(fileName, Resource.class);
    }

    public static boolean save(String aFileName, String aContent) {
        try {
            FileWriter fOut = new FileWriter(aFileName);
            fOut.write(aContent);
            fOut.flush();
            fOut.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void main(String[] args) {
        System.out.println(Resource.read(args[0]));
    }
}

