/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.servicetag.registration;

import com.sun.identity.servicetag.registration.RegistrationAccount;
import com.sun.identity.servicetag.registration.RegistrationException;
import com.sun.identity.servicetag.registration.RegistrationService;
import com.sun.identity.servicetag.registration.RegistrationServiceConfig;
import com.sun.identity.servicetag.registration.RepositoryManager;
import com.sun.identity.servicetag.registration.SOAccount;
import com.sun.identity.servicetag.registration.ServiceTag;
import com.sun.identity.servicetag.registration.StringManager;
import com.sun.identity.servicetag.registration.SysnetTransferManager;
import com.sun.scn.client.comm.RegistrationWrapper;
import com.sun.scn.client.comm.SvcTagException;
import com.sun.scn.dao.Domain;
import com.sun.scn.servicetags.AuthenticationCredential;
import com.sun.scn.servicetags.EnvironmentInformation;
import com.sun.scn.servicetags.SunOnlineAccount;
import com.sun.scn.servicetags.SvcTag;
import java.io.File;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysnetRegistrationService
implements RegistrationService {
    private final RegistrationWrapper regWrapper;
    private final File localRepositoryFile;
    private static final String REGISTRATOR_ID = "FederatedAccessManager";
    private static final String AIX = "AIX";

    public SysnetRegistrationService(File localRepositoryFile) {
        this.localRepositoryFile = localRepositoryFile;
        this.regWrapper = new RegistrationWrapper(SysnetRegistrationService.getRegistratorID());
    }

    public SysnetRegistrationService(File localRepositoryFile, String proxyHost, int proxyPort) {
        this.localRepositoryFile = localRepositoryFile;
        this.regWrapper = new RegistrationWrapper(SysnetRegistrationService.getRegistratorID(), proxyHost, proxyPort);
    }

    public SysnetRegistrationService(Object[] params) {
        this.localRepositoryFile = (File)params[0];
        this.regWrapper = new RegistrationWrapper(SysnetRegistrationService.getRegistratorID(), (String)params[1], ((Integer)params[2]).intValue());
    }

    public SysnetRegistrationService(RegistrationServiceConfig rc) {
        Object[] params = rc.getParams();
        this.localRepositoryFile = (File)params[0];
        this.regWrapper = params.length == 1 ? new RegistrationWrapper(SysnetRegistrationService.getRegistratorID()) : new RegistrationWrapper(SysnetRegistrationService.getRegistratorID(), (String)rc.getParams()[1], ((Integer)rc.getParams()[2]).intValue());
    }

    public static String getRegistratorID() {
        return REGISTRATOR_ID;
    }

    @Override
    public boolean isRegistrationEnabled() {
        if (AIX.equalsIgnoreCase(System.getProperty("os.name"))) {
            return false;
        }
        return this.localRepositoryFile.canWrite();
    }

    @Override
    public void register(RegistrationAccount account) throws RegistrationException, ConnectException, UnknownHostException {
        try {
            String hostName = "";
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception ex) {
                // empty catch block
            }
            String osName = System.getProperty("os.name");
            String osVersion = System.getProperty("os.version");
            String osArchitecture = System.getProperty("os.arch");
            String systemModel = "";
            String systemManufacturer = "";
            String cpuManufacturer = "";
            EnvironmentInformation env = new EnvironmentInformation(hostName, hostName, osName, osVersion, osArchitecture, systemModel, systemManufacturer, cpuManufacturer, "");
            RepositoryManager rm = new RepositoryManager(this.localRepositoryFile);
            rm.updateRuntimeValues();
            List<ServiceTag> serviceTags = rm.getServiceTags();
            List<SvcTag> svcTags = ServiceTag.getSvcTags(serviceTags);
            String registryURN = "urn:st:" + UUID.randomUUID().toString();
            SOAccount soAccount = (SOAccount)account;
            this.regWrapper.registerServiceTags(env, svcTags, registryURN, soAccount.getUserID(), soAccount.getPassword());
            this.setRegistrationStatus(RegistrationService.RegistrationStatus.REGISTERED);
        }
        catch (SvcTagException ex) {
            throw new RegistrationException(ex);
        }
    }

    @Override
    public void register(RegistrationAccount account, Domain domain) throws RegistrationException, ConnectException, UnknownHostException {
        try {
            String hostName = "";
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception ex) {
                // empty catch block
            }
            String osName = System.getProperty("os.name");
            String osVersion = System.getProperty("os.version");
            String osArchitecture = System.getProperty("os.arch");
            String systemModel = "";
            String systemManufacturer = "";
            String cpuManufacturer = "";
            EnvironmentInformation env = new EnvironmentInformation(hostName, hostName, osName, osVersion, osArchitecture, systemModel, systemManufacturer, cpuManufacturer, "");
            RepositoryManager rm = new RepositoryManager(this.localRepositoryFile);
            rm.updateRuntimeValues();
            List<ServiceTag> serviceTags = rm.getServiceTags();
            List<SvcTag> svcTags = ServiceTag.getSvcTags(serviceTags);
            String registryURN = "urn:st:" + UUID.randomUUID().toString();
            SOAccount soAccount = (SOAccount)account;
            AuthenticationCredential authcred = this.getAuthCredential(account);
            this.regWrapper.registerServiceTags(env, svcTags, registryURN, authcred, domain);
            this.setRegistrationStatus(RegistrationService.RegistrationStatus.REGISTERED);
        }
        catch (SvcTagException ex) {
            throw new RegistrationException(ex);
        }
    }

    @Override
    public void createRegistrationAccount(RegistrationAccount soa) throws RegistrationException {
        try {
            SunOnlineAccount account = ((SOAccount)soa).getSunOnlineAccount();
            this.regWrapper.createSunOnlineAccount(account);
        }
        catch (SvcTagException ex) {
            throw new RegistrationException(ex);
        }
    }

    @Override
    public List<String> getAvailableCountries() {
        return this.regWrapper.getAvailableCountries();
    }

    @Override
    public List getAvailableCountries(Locale locale) {
        String cts = StringManager.getString("COUNTRY_LIST_TOTAL_COUNT", new Object[0]);
        int count = Integer.parseInt(cts);
        ArrayList<String> displayList = new ArrayList<String>();
        ArrayList<String> actualList = new ArrayList<String>();
        for (int i = 1; i < count + 1; ++i) {
            displayList.add(StringManager.getString("COUNTRY-" + i, new Object[0]));
            actualList.add(StringManager.getString("en_COUNTRY-" + i, new Object[0]));
        }
        ArrayList<ArrayList<String>> ret = new ArrayList<ArrayList<String>>(2);
        ret.add(0, displayList);
        ret.add(1, actualList);
        return ret;
    }

    public List<String> getAvailableSecurityQuestions() {
        return this.regWrapper.getAvailableSecurityQuestions();
    }

    @Override
    public RegistrationService.RegistrationReminder getRegistrationReminder() throws RegistrationException {
        RepositoryManager repository = new RepositoryManager(this.localRepositoryFile);
        return repository.getRegistrationReminder();
    }

    @Override
    public void setRegistrationReminder(RegistrationService.RegistrationReminder reminder) throws RegistrationException {
        RepositoryManager repository = new RepositoryManager(this.localRepositoryFile);
        repository.setRegistrationReminder(reminder);
    }

    @Override
    public RegistrationService.RegistrationStatus getRegistrationStatus() throws RegistrationException {
        RepositoryManager repository = new RepositoryManager(this.localRepositoryFile);
        return repository.getRegistrationStatus();
    }

    public void setRegistrationStatus(RegistrationService.RegistrationStatus status) throws RegistrationException {
        RepositoryManager repository = new RepositoryManager(this.localRepositoryFile);
        repository.setRegistrationStatus(status);
    }

    @Override
    public String getPasswordHelpURL() {
        return "https://reg.sun.com/accounthelp";
    }

    @Override
    public boolean isRegistrationAccountValid(RegistrationAccount account) throws RegistrationException, UnknownHostException, ConnectException {
        SOAccount soAccount = (SOAccount)account;
        try {
            this.regWrapper.authenticate(soAccount.getUserID(), soAccount.getPassword());
        }
        catch (SvcTagException sve) {
            throw new RegistrationException(sve);
        }
        return true;
    }

    public void transferEligibleServiceTagsToSysNet() throws RegistrationException {
        SysnetTransferManager transferManager = new SysnetTransferManager(this.localRepositoryFile);
        transferManager.transferServiceTags();
    }

    @Override
    public AuthenticationCredential getAuthCredential(RegistrationAccount account) throws RegistrationException, ConnectException, UnknownHostException {
        try {
            SOAccount soAccount = (SOAccount)account;
            AuthenticationCredential auth = this.regWrapper.authenticate(soAccount.getUserID(), soAccount.getPassword());
            return auth;
        }
        catch (SvcTagException ex) {
            throw new RegistrationException(ex);
        }
    }
}

