/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.util.Crypt;
import com.sun.identity.common.DNUtils;
import com.sun.identity.setup.AMSetupDSConfig;
import com.sun.identity.setup.AMSetupServlet;
import com.sun.identity.setup.ConfiguratorException;
import com.sun.identity.setup.EmbeddedOpenDS;
import com.sun.identity.setup.IHttpServletRequest;
import com.sun.identity.setup.UserIdRepo;
import com.sun.identity.shared.encode.Hash;
import com.sun.identity.shared.ldap.LDAPDN;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.SMSSchema;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;

public class ServicesDefaultValues {
    private static ServicesDefaultValues instance = new ServicesDefaultValues();
    private static Set preappendSlash = new HashSet();
    private static Set trimSlash = new HashSet();
    private Map defValues = new HashMap();

    private ServicesDefaultValues() {
        ResourceBundle bundle = ResourceBundle.getBundle("serviceDefaultValues");
        Enumeration<String> e = bundle.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            this.defValues.put(key, bundle.getString(key));
        }
    }

    public static void setServiceConfigValues(IHttpServletRequest request) {
        boolean bUseExtUMDS;
        Locale locale = request.getLocale();
        Map map = ServicesDefaultValues.instance.defValues;
        map.putAll(request.getParameterMap());
        String base = (String)map.get("BASE_DIR");
        base = base.replace('\\', '/');
        map.put("BASE_DIR", base);
        if (!ServicesDefaultValues.isEncryptionKeyValid()) {
            throw new ConfiguratorException("configurator.encryptkey", null, locale);
        }
        String ekey = (String)map.get("AM_ENC_KEY");
        SystemProperties.initializeProperties("am.encryption.pwd", ekey);
        ServicesDefaultValues.validatePassword(locale);
        if (!ServicesDefaultValues.isServiceURLValid()) {
            throw new ConfiguratorException("configurator.invalidhostname", null, locale);
        }
        String cookieDomain = (String)map.get("COOKIE_DOMAIN");
        if (!ServicesDefaultValues.isCookieDomainValid(cookieDomain)) {
            throw new ConfiguratorException("configurator.invalidcookiedomain", null, locale);
        }
        ServicesDefaultValues.setDeployURI(request.getContextPath(), map);
        String hostname = (String)map.get("SERVER_HOST");
        map.put("COOKIE_DOMAIN", ServicesDefaultValues.getCookieDomain(cookieDomain, hostname));
        ServicesDefaultValues.setPlatformLocale();
        String dbOption = (String)map.get("DATA_STORE");
        boolean embedded = dbOption.equals("embedded");
        AMSetupDSConfig dsConfig = AMSetupDSConfig.getInstance();
        dsConfig.setDSValues();
        if (!embedded) {
            boolean ssl;
            String sslEnabled = (String)map.get("DIRECTORY_SSL");
            boolean bl = ssl = sslEnabled != null && sslEnabled.equals("SSL");
            if (!dsConfig.isDServerUp(ssl)) {
                dsConfig = null;
                throw new ConfiguratorException("configurator.dsconnnectfailure", null, locale);
            }
            if (!DN.isDN((String)((String)map.get("ROOT_SUFFIX"))) || !dsConfig.connectDSwithDN(ssl)) {
                dsConfig = null;
                throw new ConfiguratorException("configurator.invalidsuffix", null, locale);
            }
            map.put("DIT_LOADED", dsConfig.isDITLoaded(ssl));
            map.put("DATASTORE_NOTIFICATION", "true");
            map.put("DISABLE_PERSISTENT_SEARCH", "aci,um");
        } else {
            map.put("DATASTORE_NOTIFICATION", "false");
            map.put("DISABLE_PERSISTENT_SEARCH", "aci,um,sm");
        }
        Map userRepo = (Map)map.get("UserStore");
        String umRootSuffix = null;
        boolean bl = bUseExtUMDS = userRepo != null && !userRepo.isEmpty();
        if (bUseExtUMDS) {
            map.put("UM_DS_DIRMGRDN", UserIdRepo.getBindDN(userRepo));
            map.put("UM_DS_DIRMGRPASSWD", UserIdRepo.getBindPassword(userRepo));
            map.put("UM_DIRECTORY_SERVER", UserIdRepo.getHost(userRepo));
            map.put("UM_DIRECTORY_PORT", UserIdRepo.getPort(userRepo));
            String s = (String)userRepo.get("userStoreSSL");
            String ssl = s != null && s.equals("SSL") ? "true" : "false";
            map.put("UM_SSL", ssl);
            umRootSuffix = (String)userRepo.get("userStoreRootSuffix");
        } else {
            map.put("UM_DS_DIRMGRDN", map.get("DS_DIRMGRDN"));
            map.put("UM_DS_DIRMGRPASSWD", map.get("DS_DIRMGRPASSWD"));
            map.put("UM_DIRECTORY_SERVER", map.get("DIRECTORY_SERVER"));
            map.put("UM_DIRECTORY_PORT", map.get("DIRECTORY_PORT"));
            map.put("UM_SSL", "false");
            umRootSuffix = (String)map.get("ROOT_SUFFIX");
        }
        umRootSuffix = umRootSuffix.trim();
        String normalizedDN = LDAPDN.normalize((String)umRootSuffix);
        String escapedDN = SMSSchema.escapeSpecialCharacters(normalizedDN);
        map.put("UM_NORMALIZED_ORGBASE", escapedDN);
    }

    private static void setPlatformLocale() {
        Map map = ServicesDefaultValues.instance.defValues;
        String locale = (String)map.get("PLATFORM_LOCALE");
        if (locale == null) {
            map.put("PLATFORM_LOCALE", "en_US");
        }
    }

    private static boolean isServiceURLValid() {
        String protocol = "http";
        String port = "80";
        Map map = ServicesDefaultValues.instance.defValues;
        String hostURL = (String)map.get("SERVER_URL");
        boolean valid = hostURL != null && hostURL.length() > 0;
        try {
            if (valid) {
                String hostName;
                if (hostURL.indexOf("http", 0) == -1 && hostURL.indexOf("https", 0) == -1) {
                    int idx = hostURL.lastIndexOf(":");
                    if (idx != -1) {
                        port = hostURL.substring(idx + 1);
                        hostName = hostURL.substring(0, idx);
                    } else {
                        hostName = hostURL;
                    }
                    if (port.equals("443")) {
                        protocol = "https";
                    }
                } else {
                    URL serverURL = new URL(hostURL);
                    int intPort = serverURL.getPort();
                    protocol = serverURL.getProtocol();
                    if (intPort < 0) {
                        if (protocol.equalsIgnoreCase("https")) {
                            port = "443";
                        }
                    } else {
                        port = Integer.toString(intPort);
                    }
                    hostName = serverURL.getHost();
                }
                if (ServicesDefaultValues.isHostnameValid(hostName)) {
                    map.put("SERVER_HOST", hostName);
                    map.put("SERVER_PROTO", protocol);
                    map.put("SERVER_PORT", port);
                    map.put("SERVER_URL", protocol + "://" + hostName + ":" + port);
                } else {
                    valid = false;
                }
            }
        }
        catch (MalformedURLException mue) {
            valid = false;
        }
        return valid;
    }

    private static boolean isHostnameValid(String hostname) {
        int idx;
        boolean valid;
        boolean bl = valid = hostname != null && hostname.length() > 0;
        if (valid && (idx = hostname.lastIndexOf(".")) != -1 && idx != hostname.length() - 1) {
            int idx1 = hostname.lastIndexOf(".", idx - 1);
            valid = idx1 != -1 && idx1 < idx - 1;
        }
        return valid;
    }

    private static boolean isCookieDomainValid(String cookieDomain) {
        boolean valid;
        boolean bl = valid = cookieDomain == null || cookieDomain.length() == 0;
        if (!valid) {
            int idx1 = cookieDomain.lastIndexOf(".");
            boolean bl2 = valid = idx1 == -1 || idx1 != cookieDomain.length() - 1;
            if (valid) {
                int idx2 = cookieDomain.lastIndexOf(".", idx1 - 1);
                valid = idx2 != -1 && idx2 < idx1 - 1;
            }
        }
        return valid;
    }

    private static String getCookieDomain(String cookieDomain, String hostname) {
        int idx = hostname.lastIndexOf(".");
        if (idx == -1 || idx == hostname.length() - 1 || ServicesDefaultValues.isIPAddress(hostname)) {
            cookieDomain = "";
        } else if (cookieDomain == null || cookieDomain.length() == 0) {
            String topLevelDomain = hostname.substring(idx + 1);
            int idx2 = hostname.lastIndexOf(".", idx - 1);
            if (idx2 != -1 && idx2 < idx - 1) {
                cookieDomain = hostname.substring(idx2);
            }
        }
        return cookieDomain;
    }

    private static boolean isIPAddress(String hostname) {
        boolean isIPAddr;
        StringTokenizer st = new StringTokenizer(hostname, ".");
        boolean bl = isIPAddr = st.countTokens() == 4;
        if (isIPAddr) {
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                try {
                    int node = Integer.parseInt(token);
                    isIPAddr = node >= 0 && node < 256;
                }
                catch (NumberFormatException e) {
                    isIPAddr = false;
                }
            }
        }
        return isIPAddr;
    }

    private static boolean isEncryptionKeyValid() {
        Map map = ServicesDefaultValues.instance.defValues;
        String ekey = (String)map.get("AM_ENC_KEY");
        if (ekey == null) {
            ekey = AMSetupServlet.getRandomString().trim();
            map.put("AM_ENC_KEY", ekey);
        }
        return ekey != null && ekey.length() > 0;
    }

    private static void validatePassword(Locale locale) {
        String dsMgrPwd;
        String urlAccessAgentPwd;
        String confirmAdminPwd;
        Map map = ServicesDefaultValues.instance.defValues;
        String adminPwd = ((String)map.get("ADMIN_PWD")).trim();
        if (ServicesDefaultValues.isPasswordValid(adminPwd, confirmAdminPwd = ((String)map.get("ADMIN_CONFIRM_PWD")).trim(), locale)) {
            SystemProperties.initializeProperties("am.encryption.pwd", ((String)map.get("AM_ENC_KEY")).trim());
            Crypt.reinitialize();
            map.put("HASHADMINPASSWD", Hash.hash((String)adminPwd));
        }
        if ((urlAccessAgentPwd = (String)map.get("AMLDAPUSERPASSWD")) != null) {
            urlAccessAgentPwd.trim();
            String urlAccessAgentPwdConfirm = ((String)map.get("AMLDAPUSERPASSWD_CONFIRM")).trim();
            ServicesDefaultValues.validateURLAccessAgentPassword(adminPwd, urlAccessAgentPwd, urlAccessAgentPwdConfirm, locale);
            map.remove("AMLDAPUSERPASSWD_CONFIRM");
        }
        String dbOption = (String)map.get("DATA_STORE");
        boolean embedded = dbOption.equals("embedded");
        boolean dbSunDS = false;
        boolean dbMsAD = false;
        if (embedded) {
            dbSunDS = true;
        } else {
            dbSunDS = dbOption.equals("dirServer");
            dbMsAD = dbOption.equals("activeDir");
        }
        if (dbSunDS || dbMsAD) {
            dsMgrPwd = ((String)map.get("DS_DIRMGRPASSWD")).trim();
            if (embedded && dsMgrPwd.length() == 0) {
                map.put("DS_DIRMGRPASSWD", adminPwd);
            }
        }
        dsMgrPwd = (String)map.get("DS_DIRMGRPASSWD");
        map.put("ENCDSDIRMGRPASSWD", Crypt.encrypt((String)dsMgrPwd));
        String ldapUserPwd = (String)map.get("AMLDAPUSERPASSWD");
        if (ldapUserPwd != null) {
            ldapUserPwd.trim();
            map.put("ENCLDAPUSERPASSWD", Crypt.encrypt((String)ldapUserPwd));
            map.put("HASHLDAPUSERPASSWD", Hash.hash((String)ldapUserPwd));
        }
        map.put("SSHA512LDAPUSERPWD", EmbeddedOpenDS.hash(adminPwd));
        String encryptAdminPwd = Crypt.encrypt((String)adminPwd);
        map.put("ENCADMINPASSWD", encryptAdminPwd);
        map.put("ENCADADMINPASSWD", encryptAdminPwd);
        map.remove("ADMIN_CONFIRM_PWD");
    }

    private static boolean isPasswordValid(String pwd, String cPwd, Locale locale) {
        if (pwd != null && pwd.length() > 7) {
            if (!pwd.equals(cPwd)) {
                throw new ConfiguratorException("configurator.nopasswdmatch", null, locale);
            }
        } else {
            throw new ConfiguratorException("configurator.passwdlength", null, locale);
        }
        return true;
    }

    private static boolean validateURLAccessAgentPassword(String amadminPwd, String pwd, String cPwd, Locale locale) {
        if (pwd != null && pwd.length() > 7) {
            if (!pwd.equals(cPwd)) {
                throw new ConfiguratorException("configurator.urlaccessagent.passwd.nomatch", null, locale);
            }
            if (amadminPwd.equals(pwd)) {
                throw new ConfiguratorException("configurator.urlaccessagent.passwd.match.amadmin.pwd", null, locale);
            }
        } else {
            throw new ConfiguratorException("configurator.passwdlength", null, locale);
        }
        return true;
    }

    public static Map getDefaultValues() {
        return ServicesDefaultValues.instance.defValues;
    }

    public static void setDeployURI(String deployURI, Map map) {
        map.put("IS_PRODNAME", deployURI);
        map.put("OLDCON_DEPLOY_URI", deployURI);
        map.put("CONSOLE_URI", deployURI);
        map.put("SERVER_URI", deployURI);
    }

    public static String tagSwap(String orig) {
        return ServicesDefaultValues.tagSwap(orig, false);
    }

    public static String tagSwap(String orig, boolean bXML) {
        Map map = ServicesDefaultValues.instance.defValues;
        for (String key : map.keySet()) {
            String value = (String)map.get(key);
            if (value == null) continue;
            value = value.replaceAll("[$]", "\\\\\\$");
            if (preappendSlash.contains(key)) {
                if (bXML) {
                    value = XMLUtils.escapeSpecialCharacters((String)value);
                }
                orig = orig.replaceAll("/@" + key + "@", value);
                if (!trimSlash.contains(key)) continue;
                orig = orig.replaceAll("@" + key + "@", value.substring(1));
                continue;
            }
            if (key.equals("ROOT_SUFFIX")) {
                String normalized = DNUtils.normalizeDN(value);
                String tmp = normalized.replaceAll(",", "^");
                tmp = bXML ? XMLUtils.escapeSpecialCharacters((String)tmp) : tmp;
                orig = orig.replaceAll("@SM_ROOT_SUFFIX_HAT@", tmp);
                String rfced = new DN(value).toRFCString();
                tmp = bXML ? XMLUtils.escapeSpecialCharacters((String)rfced) : rfced;
                orig = orig.replaceAll("@ROOT_SUFFIX@", tmp);
                continue;
            }
            if (key.equals("SM_ROOT_SUFFIX_HAT") || key.equals("NORMALIZED_RS") || key.equals("NORMALIZED_ORGBASE") || key.equals("SM_ROOT_SUFFIX_HAT")) {
                orig = orig.replaceAll("@" + key + "@", value);
                continue;
            }
            if (bXML) {
                value = XMLUtils.escapeSpecialCharacters((String)value);
            }
            orig = orig.replaceAll("@" + key + "@", value);
        }
        return orig;
    }

    static {
        preappendSlash.add("IS_PRODNAME");
        preappendSlash.add("OLDCON_DEPLOY_URI");
        preappendSlash.add("CONSOLE_URI");
        preappendSlash.add("SERVER_URI");
        trimSlash.add("CONSOLE_URI");
        trimSlash.add("SERVER_URI");
    }
}

