/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log;

import com.iplanet.sso.SSOException;
import com.sun.identity.log.ILogRecord;
import com.sun.identity.log.Logger;
import com.sun.identity.log.spi.Debug;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;

public class LogRecord
extends java.util.logging.LogRecord
implements ILogRecord {
    private Map logInfoMap = new HashMap();
    private Object token;

    public LogRecord(Level level, String msg) {
        super(level, msg);
    }

    public LogRecord(Level level, String msg, Object token) {
        this(level, msg);
        this.token = token;
        try {
            Logger.extractInfoFromLogFor(this);
        }
        catch (SSOException se) {
            Debug.error("LogRecord:LogRecord:SSOException: " + se.getMessage());
        }
    }

    public LogRecord(Level level, String msg, Hashtable properties) {
        this(level, msg);
        String clientDomain = (String)properties.get("Domain");
        String clientID = (String)properties.get("LoginID");
        String ipAddress = (String)properties.get("IPAddr");
        String loginIDSid = (String)properties.get("LoginIDSid");
        String moduleName = (String)properties.get("ModuleName");
        String contextID = (String)properties.get("ContextID");
        String messageID = (String)properties.get("MessageID");
        String nameID = (String)properties.get("NameID");
        String hostName = ipAddress;
        if (ipAddress != null) {
            try {
                hostName = Logger.resolveHostName ? InetAddress.getByName(ipAddress).getHostName() : ipAddress;
            }
            catch (Exception e) {
                Debug.error("LogRecord:LogRecord:Unable to get Host for:" + ipAddress);
            }
        }
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.addLogInfo("TIME", sdf.format(date));
        this.addLogInfo("Data", this.getMessage());
        this.addLogInfo("LogLevel", this.getLevel().toString());
        this.addLogInfo("Domain", clientDomain);
        this.addLogInfo("LoginID", clientID);
        this.addLogInfo("IPAddr", ipAddress);
        this.addLogInfo("HostName", hostName);
        this.addLogInfo("LoginIDSid", loginIDSid);
        this.addLogInfo("ModuleName", moduleName);
        if (messageID != null && messageID.length() > 0) {
            this.addLogInfo("MessageID", messageID);
        }
        if (contextID != null && contextID.length() > 0) {
            this.addLogInfo("ContextID", contextID);
        }
        if (nameID != null && nameID.length() > 0) {
            this.addLogInfo("NameID", nameID);
        }
    }

    public void addLogInfo(String key, Object value) {
        this.logInfoMap.put(key, value);
    }

    public void setLogInfoMap(Map logInfoMap) {
        this.logInfoMap = logInfoMap;
    }

    public Map getLogInfoMap() {
        return this.logInfoMap;
    }

    public Object getLogBy() {
        return null;
    }

    public Object getLogFor() {
        return this.token;
    }
}

