/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.safeword;

import com.iplanet.am.util.Misc;
import com.sun.identity.authentication.modules.safeword.SafeWordPrincipal;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import com.sun.identity.shared.debug.Debug;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import securecomputing.ssl.SimpleSSLClient;
import securecomputing.swec.AuthenState;
import securecomputing.swec.AuthenticatorData;
import securecomputing.swec.DynamicPwdData;
import securecomputing.swec.EasspMessage;
import securecomputing.swec.FixedPwdData;
import securecomputing.swec.SafeWordClient;
import securecomputing.swec.SwecConfig;

public class SafeWord
extends AMLoginModule {
    private ResourceBundle bundle = null;
    private static Debug debug = null;
    private Map sharedState;
    private static final String ATTRIBUTE_SERVER_SPECIFICATION = "iplanet-am-auth-safeword-server-specification";
    private static final String ATTRIBUTE_SYSTEM_NAME = "iplanet-am-auth-safeword-system-name";
    private static final String ATTRIBUTE_SRVR_VERIF_PATH = "iplanet-am-auth-safeword-srvr-verif-path";
    private static final String ATTRIBUTE_LOG_ENABLE = "iplanet-am-auth-safeword-log-enable";
    private static final String ATTRIBUTE_LOG_LEVEL = "iplanet-am-auth-safeword-log-level";
    private static final String ATTRIBUTE_LOG_PATH = "iplanet-am-auth-safeword-log-path";
    private static final String ATTRIBUTE_AUTH_LEVEL = "iplanet-am-auth-safeword-auth-level";
    private static final String ATTRIBUTE_CLIENT_TYPE = "iplanet-am-auth-safeword-client-type";
    private static final String ATTRIBUTE_MINIMUM_STRENGTH = "iplanet-am-auth-safeword-minimum-strength";
    private static final String ATTRIBUTE_EASSP_VERSION = "iplanet-am-auth-safeword-eassp-version";
    private static final String ATTRIBUTE_TIMEOUT = "iplanet-am-auth-safeword-timeout";
    private static final String DEFAULT_EASSP_VERSION = "101";
    private static final String DEFAULT_SERVER_SPECIFICATION = "localhost 7482";
    private static final String DEFAULT_TIMEOUT = "120";
    private static final String DEFAULT_MINIMUM_STRENGTH = "5";
    private static final String DEFAULT_LOG_LEVEL = "DEBUG";
    private static final String DEFAULT_VAR_DIR = "com.iplanet.am.install.vardir";
    private String serverSpec;
    private String serverVerifFilesPath = null;
    private String statusLogLevel;
    private String logEnabled = "ON";
    private String statusLogFilePath = null;
    private String authLevel;
    private String clientType;
    private String minimumStrength;
    private String version;
    private SafeWordClient swClient = null;
    private AuthenState aState = null;
    private String challengeID;
    private String timeOut;
    private boolean flag = false;
    private String userTokenId;
    private SafeWordPrincipal userPrincipal;
    private Map options;
    private static final int PAGE_USERNAME = 1;
    private static final int PAGE_PASSWORD = 2;
    private static final String amAuthSafeWord = "amAuthSafeWord";
    private boolean getCredentialsFromSharedState;

    public void init(Subject subject, Map sharedState, Map options) {
        Locale locale = this.getLoginLocale();
        this.bundle = amCache.getResBundle(amAuthSafeWord, locale);
        if (debug.messageEnabled()) {
            debug.message("SafeWord resource bundle locale = " + locale);
        }
        this.options = options;
        this.sharedState = sharedState;
    }

    public int process(Callback[] callbacks, int state) throws AuthLoginException {
        try {
            if (state == 1) {
                this.initAuthConfig();
                if (callbacks != null && callbacks.length == 0) {
                    this.userTokenId = (String)this.sharedState.get(this.getUserKey());
                    if (this.userTokenId == null) {
                        return 1;
                    }
                    this.getCredentialsFromSharedState = true;
                } else {
                    this.userTokenId = this.getUserName(callbacks);
                }
                this.initSafeWordClient();
                if (this.sendRequestForChallengeID()) {
                    this.setDynamicText(2);
                }
                if (this.version != null && this.version.equals(DEFAULT_EASSP_VERSION)) {
                    long time = System.currentTimeMillis();
                    new TimeoutThread(time).start();
                }
                return 2;
            }
            if (state == 2) {
                String password = this.getPassword(callbacks);
                this.storeUsernamePasswd(this.userTokenId, password);
                this.flag = true;
                this.authenticate(password);
                return -1;
            }
            if (debug.messageEnabled()) {
                debug.message("Invalid login state: " + state);
            }
            this.setFailureID(this.userTokenId);
            throw new AuthLoginException(amAuthSafeWord, "SafeWordInvalidState", new Object[]{new Integer(state)});
        }
        catch (AuthLoginException e) {
            if (this.getCredentialsFromSharedState && !this.isUseFirstPassEnabled()) {
                this.getCredentialsFromSharedState = false;
                return 1;
            }
            this.setFailureID(this.userTokenId);
            throw e;
        }
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.userTokenId != null) {
            this.userPrincipal = new SafeWordPrincipal(this.userTokenId);
            return this.userPrincipal;
        }
        return null;
    }

    public void destroyModuleState() {
        this.userTokenId = null;
        this.userPrincipal = null;
    }

    public void nullifyUsedVars() {
        this.bundle = null;
        this.sharedState = null;
        this.serverSpec = null;
        this.serverVerifFilesPath = null;
        this.statusLogLevel = null;
        this.logEnabled = null;
        this.statusLogFilePath = null;
        this.authLevel = null;
        this.clientType = null;
        this.minimumStrength = null;
        this.version = null;
        this.aState = null;
        this.challengeID = null;
        this.options = null;
    }

    private void initAuthConfig() throws AuthLoginException {
        if (this.options != null) {
            String strlogEnabled;
            this.serverSpec = Misc.getMapAttr(this.options, ATTRIBUTE_SERVER_SPECIFICATION, DEFAULT_SERVER_SPECIFICATION);
            this.version = Misc.getMapAttr(this.options, ATTRIBUTE_EASSP_VERSION, DEFAULT_EASSP_VERSION);
            this.serverVerifFilesPath = Misc.getMapAttr(this.options, ATTRIBUTE_SRVR_VERIF_PATH);
            if (this.serverVerifFilesPath == null) {
                this.serverVerifFilesPath = this.getServerConfigPath();
            }
            if ((strlogEnabled = Misc.getMapAttr(this.options, ATTRIBUTE_LOG_ENABLE, "true")).equals("false")) {
                this.logEnabled = "OFF";
            }
            this.statusLogLevel = Misc.getMapAttr(this.options, ATTRIBUTE_LOG_LEVEL, DEFAULT_LOG_LEVEL);
            this.statusLogFilePath = Misc.getMapAttr(this.options, ATTRIBUTE_LOG_PATH);
            if (this.statusLogFilePath == null) {
                this.statusLogFilePath = this.getServerLogPath();
            }
            this.authLevel = Misc.getMapAttr(this.options, ATTRIBUTE_AUTH_LEVEL);
            this.clientType = Misc.getMapAttr(this.options, ATTRIBUTE_CLIENT_TYPE);
            this.minimumStrength = Misc.getMapAttr(this.options, ATTRIBUTE_MINIMUM_STRENGTH, DEFAULT_MINIMUM_STRENGTH);
            this.timeOut = Misc.getMapAttr(this.options, ATTRIBUTE_TIMEOUT, DEFAULT_TIMEOUT);
            if (debug.messageEnabled()) {
                debug.message("SafeWord Auth config parameters:\niplanet-am-auth-safeword-server-specification: " + this.serverSpec + "\n" + ATTRIBUTE_SRVR_VERIF_PATH + ": " + this.serverVerifFilesPath + "\n" + ATTRIBUTE_TIMEOUT + ": " + " timeOut: " + this.timeOut + "\n" + ATTRIBUTE_LOG_ENABLE + ": " + this.logEnabled + "\n" + ATTRIBUTE_LOG_LEVEL + ": " + this.statusLogLevel + "\n" + ATTRIBUTE_LOG_PATH + ": " + this.statusLogFilePath + "\n" + ATTRIBUTE_EASSP_VERSION + ": " + this.version + "\n" + ATTRIBUTE_CLIENT_TYPE + ": " + this.clientType + "\n" + ATTRIBUTE_AUTH_LEVEL + ": " + this.authLevel + "\n");
            }
        } else {
            debug.error("options is null");
            throw new AuthLoginException(amAuthSafeWord, "SafeWordOptInit", null);
        }
    }

    private String getUserName(Callback[] callbacks) throws AuthLoginException {
        return ((NameCallback)callbacks[0]).getName();
    }

    private void initSafeWordClient() throws AuthLoginException {
        SwecConfig config = new SwecConfig();
        config.setDefaults();
        config.setProperty("Eassp_Version", this.version);
        config.setProperty("Server_Spec", this.serverSpec);
        config.setProperty("Server_Verification_Files_Path", this.serverVerifFilesPath);
        config.setProperty("Status_Log_File_Path", this.statusLogFilePath);
        config.setProperty("Socket_Timeout", this.timeOut);
        config.setProperty("File_Status_Log_Enable", this.logEnabled);
        config.setProperty("GLOBAL_Message_Level", this.statusLogLevel);
        config.setProperty("Socket_Timeout", this.timeOut);
        if (this.version != null && (this.version.equals("201") || this.version.equals("200"))) {
            if (debug.messageEnabled()) {
                debug.message("Set 20x specific configuration - EASSP Ver: " + this.version);
            }
            config.setProperty("SSL_Enable", "ON");
            SimpleSSLClient.seedRandomGenerator();
        }
        debug.message("About to get new SafeWordClient");
        try {
            this.swClient = new SafeWordClient(config);
            if (debug.messageEnabled()) {
                debug.message("New SafeWordClient: " + this.swClient.getResultText());
            }
        }
        catch (Exception ex) {
            debug.error("Failed to create new SafeWordClient.", (Throwable)ex);
            throw new AuthLoginException(amAuthSafeWord, "SafeWordNewSWClient", null, ex);
        }
        debug.message("Done init new SafeWordClient");
    }

    private boolean sendRequestForChallengeID() throws AuthLoginException {
        EasspMessage returnMsg;
        if (this.userTokenId == null || this.userTokenId.length() == 0) {
            this.closeClient();
            throw new AuthLoginException(amAuthSafeWord, "SafeWordUserIdNull", null);
        }
        try {
            if (!this.userTokenId.equals(new String(this.userTokenId.getBytes("ASCII"), "ASCII"))) {
                this.closeClient();
                throw new AuthLoginException(amAuthSafeWord, "SafeWordUseridNotASCII", null);
            }
        }
        catch (UnsupportedEncodingException ueex) {
            this.closeClient();
            throw new AuthLoginException(amAuthSafeWord, "SafeWordInputEncodingException", null);
        }
        try {
            EasspMessage requestMsg = this.swClient.createRequestMsg(this.userTokenId, "name");
            if (debug.messageEnabled()) {
                debug.message("Submitting requestMsg for userID: " + this.userTokenId);
            }
            requestMsg.setAgentName(this.clientType);
            requestMsg.setClientType(this.clientType);
            boolean requireSession = true;
            String authenticationService = null;
            requestMsg.setAuthenticationRequirements(requireSession, this.minimumStrength, authenticationService);
            returnMsg = this.swClient.sendMessage(requestMsg);
        }
        catch (Exception e) {
            debug.error("Failed to send/receive eassp message :" + e.getMessage());
            this.closeClient();
            throw new AuthLoginException(amAuthSafeWord, "SafeWordEasspError", null);
        }
        String id = returnMsg.getIdData();
        String statusMsg = returnMsg.getStatusText();
        switch (returnMsg.getMessageType()) {
            case 1: {
                if (debug.messageEnabled()) {
                    debug.message("Received challenge to auth request by " + id);
                }
                EasspMessage challengeMsg = returnMsg;
                this.aState = new AuthenState(challengeMsg);
                AuthenticatorData data = this.aState.getCurrentAuthenticator();
                try {
                    if (data instanceof FixedPwdData) {
                        debug.message("Current Authenticator Fixed Password");
                        return false;
                    }
                    if (data instanceof DynamicPwdData) {
                        debug.message("Current Authenticator Dynamic Password");
                        DynamicPwdData ddata = (DynamicPwdData)data;
                        this.challengeID = ddata.getChallenge();
                        return true;
                    }
                }
                catch (Exception e) {
                    debug.error("Received Non-Dynamic Authenticator");
                    this.setFailureID(this.userTokenId);
                    this.closeClient();
                    throw new AuthLoginException(amAuthSafeWord, "SafeWordUnsupportedAuthenticator", null, e);
                }
            }
            case 3: {
                this.closeClient();
                if (returnMsg.passedCheck()) {
                    debug.error("Successful Authentication, but only id sent. Msg: " + statusMsg);
                    this.setFailureID(this.userTokenId);
                    throw new AuthLoginException(amAuthSafeWord, "SafeWordSuccessOnlyUserID", new Object[]{statusMsg});
                }
                debug.error("Authentication Failed, only id sent. Check for lockout on server. Msg: " + statusMsg);
                this.setFailureID(this.userTokenId);
                throw new AuthLoginException(amAuthSafeWord, "SafeWordLoginFailed", new Object[]{statusMsg});
            }
        }
        this.closeClient();
        this.setFailureID(this.userTokenId);
        debug.error("Authentication Failed, unknown return value: " + returnMsg.getMessageType());
        throw new AuthLoginException(amAuthSafeWord, "SafeWordLoginFailedUnknown", new Object[]{statusMsg});
    }

    private void setDynamicText(int state) throws AuthLoginException {
        Callback[] callbacks = this.getCallback(state);
        String prompt = ((PasswordCallback)callbacks[0]).getPrompt();
        boolean echo = ((PasswordCallback)callbacks[0]).isEchoOn();
        if (debug.messageEnabled()) {
            debug.message("Set dynamic text: challengeID: " + this.challengeID);
        }
        if (this.challengeID != null) {
            prompt = prompt + "[" + this.challengeID + "]: ";
        }
        callbacks[0] = new PasswordCallback(prompt, echo);
        this.replaceCallback(state, 0, callbacks[0]);
    }

    private String getPassword(Callback[] callbacks) throws AuthLoginException {
        char[] tmpPassword = ((PasswordCallback)callbacks[0]).getPassword();
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        char[] pwd = new char[tmpPassword.length];
        System.arraycopy(tmpPassword, 0, pwd, 0, tmpPassword.length);
        ((PasswordCallback)callbacks[0]).clearPassword();
        return new String(pwd);
    }

    private void authenticate(String challengeResponse) throws AuthLoginException {
        if (challengeResponse == null || challengeResponse.length() == 0) {
            if (debug.messageEnabled()) {
                debug.message(this.userTokenId + " supplied no challenge response");
            }
            this.closeClient();
            throw new AuthLoginException(amAuthSafeWord, "SafeWordNoChallRsp", null);
        }
        try {
            if (!challengeResponse.equals(new String(challengeResponse.getBytes("ASCII"), "ASCII"))) {
                this.closeClient();
                throw new AuthLoginException(amAuthSafeWord, "SafeWordChalRspNotASCII", null);
            }
        }
        catch (UnsupportedEncodingException ueex) {
            this.closeClient();
            throw new AuthLoginException(amAuthSafeWord, "SafeWordInputEncodingException", null);
        }
        int ccount = this.aState.getAuthenComboCount();
        if (ccount > 1 && debug.messageEnabled()) {
            debug.message("Authenticator Combo (" + ccount + " authenticators) not supported");
        }
        if (debug.messageEnabled()) {
            debug.message("Anthenticator Combo count = " + ccount);
        }
        AuthenticatorData data = this.aState.getCurrentAuthenticator();
        debug.message("Checking challenge response return message type");
        try {
            if (data instanceof FixedPwdData) {
                FixedPwdData fdata = (FixedPwdData)data;
                fdata.setPwd(challengeResponse);
            } else if (data instanceof DynamicPwdData) {
                DynamicPwdData ddata = (DynamicPwdData)data;
                ddata.setPwd(challengeResponse);
            }
        }
        catch (Exception e) {
            this.closeClient();
            debug.error("Received unknown Authenticator");
            throw new AuthLoginException(amAuthSafeWord, "SafeWordUnsupportedAuthenticator", null, e);
        }
        debug.message("Challenge response return message type Dynamic");
        EasspMessage responseMsg = this.swClient.createResponseMsg(this.aState);
        debug.message("After creating new responseMsg");
        responseMsg.setAgentName(this.clientType);
        responseMsg.setClientType(this.clientType);
        boolean requireSession = true;
        String authenticationService = null;
        responseMsg.setAuthenticationRequirements(requireSession, this.minimumStrength, authenticationService);
        EasspMessage returnMsg = this.swClient.sendMessage(responseMsg);
        debug.message("After creating new returnMsg");
        String id = returnMsg.getIdData();
        String statusMsg = returnMsg.getStatusText();
        if (debug.messageEnabled()) {
            debug.message("Challenge response returns '" + statusMsg + "' for userid " + id);
        }
        this.closeClient();
        if (returnMsg.passedCheck()) {
            if (debug.messageEnabled()) {
                debug.message("Authentication successful for userid = " + this.userTokenId + ", id = " + id);
            }
        } else {
            if (debug.messageEnabled()) {
                debug.message("SafeWord authentication failed for userid = " + this.userTokenId + ", id = " + id);
            }
            throw new InvalidPasswordException(amAuthSafeWord, "SafeWordChallFailed", null, this.userTokenId, null);
        }
        this.setAuthLevel(Integer.parseInt(this.authLevel));
    }

    private String getServerConfigPath() {
        if (this.serverVerifFilesPath == null) {
            StringBuffer buf = new StringBuffer();
            buf.append(DEFAULT_VAR_DIR).append("/auth/safeword/serverVerification");
            this.serverVerifFilesPath = buf.toString();
        }
        return this.serverVerifFilesPath;
    }

    private String getServerLogPath() {
        if (this.statusLogFilePath == null) {
            StringBuffer buf = new StringBuffer();
            buf.append(DEFAULT_VAR_DIR).append("/auth/safeword/safe.log");
            this.statusLogFilePath = buf.toString();
        }
        return this.statusLogFilePath;
    }

    private void closeClient() {
        this.swClient.close();
        this.swClient = null;
    }

    static {
        if (debug == null) {
            debug = Debug.getInstance((String)amAuthSafeWord);
        }
    }

    class TimeoutThread
    extends Thread {
        long start;
        int iTimeOut;

        public TimeoutThread(long time) {
            this.iTimeOut = Integer.parseInt(SafeWord.this.timeOut);
            this.start = time;
        }

        public void run() {
            while (true) {
                long time = System.currentTimeMillis();
                try {
                    if (time - this.start >= (long)(this.iTimeOut * 1000) && !SafeWord.this.flag) {
                        SafeWord.this.closeClient();
                        break;
                    }
                    if (SafeWord.this.flag) break;
                    TimeoutThread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    if (!debug.messageEnabled()) continue;
                    debug.message("Error in timeout thread run : " + e);
                }
            }
        }
    }
}

