/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.opensso;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.entitlement.EntitlementThreadPool;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.interfaces.IThreadPool;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.SMSException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.AccessController;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Notifier
implements Runnable {
    private static final String currentServerInstance = SystemProperties.getServerInstanceName();
    private String action;
    private Map<String, String> params;
    private static IThreadPool threadPool = new EntitlementThreadPool(4);

    public static void submit(String action, Map<String, String> params) {
        threadPool.submit(new Notifier(action, params));
    }

    private Notifier(String action, Map<String, String> params) {
        this.action = action;
        this.params = params;
    }

    @Override
    public void run() {
        try {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            Set serverURLs = ServerConfiguration.getServerInfo(adminToken);
            for (String url : serverURLs) {
                int idx = url.indexOf("|");
                if (idx != -1) {
                    url = url.substring(0, idx);
                }
                if (url.equals(currentServerInstance)) continue;
                String strURL = url + "/notification" + "/" + this.action;
                StringBuffer buff = new StringBuffer();
                boolean bFirst = true;
                for (String k : this.params.keySet()) {
                    if (bFirst) {
                        bFirst = false;
                    } else {
                        buff.append("&");
                    }
                    buff.append(URLEncoder.encode(k, "UTF-8")).append("=").append(URLEncoder.encode(this.params.get(k), "UTF-8"));
                }
                this.postRequest(strURL, buff.toString());
            }
        }
        catch (UnsupportedEncodingException ex) {
            PrivilegeManager.debug.error("Notifier.notifyChanges", (Throwable)ex);
        }
        catch (IOException ex) {
            PrivilegeManager.debug.error("Notifier.notifyChanges", (Throwable)ex);
        }
        catch (SMSException ex) {
            PrivilegeManager.debug.error("Notifier.notifyChanges", (Throwable)ex);
        }
        catch (SSOException ex) {
            PrivilegeManager.debug.error("DataStore.notifyChanges", (Throwable)((Object)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String postRequest(String strURL, String data) throws IOException {
        OutputStreamWriter wr = null;
        BufferedReader rd = null;
        try {
            String line;
            URL url = new URL(strURL);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuffer result = new StringBuffer();
            while ((line = rd.readLine()) != null) {
                result.append(line).append("\n");
            }
            String string = result.toString();
            return string;
        }
        finally {
            if (wr != null) {
                wr.close();
            }
            if (rd != null) {
                rd.close();
            }
        }
    }
}

