/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tools.patch;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;

public class PatchGeneratorUtils {
    public static File getFile(String path) throws FileNotFoundException {
        File file = new File(path);
        if (file.exists() && file.isFile()) {
            return file;
        }
        throw new FileNotFoundException(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getManifest(JarFile warFile, String manifestPattern, char wildCard) throws Exception {
        Properties manifest = new Properties();
        Enumeration<JarEntry> entries = warFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !PatchGeneratorUtils.isMatch(entry.getName(), manifestPattern, wildCard)) continue;
            InputStream warIn = null;
            try {
                warIn = warFile.getInputStream(entry);
                manifest.load(warIn);
                break;
            }
            finally {
                try {
                    warIn.close();
                }
                catch (Exception ignored) {}
            }
        }
        return manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getManifest(JarInputStream in, String manifestPattern, char wildCard) throws Exception {
        Properties manifest = new Properties();
        JarEntry entry = null;
        while ((entry = in.getNextJarEntry()) != null) {
            if (entry.isDirectory() || !PatchGeneratorUtils.isMatch(entry.getName(), manifestPattern, wildCard)) continue;
            try {
                manifest.load(in);
                break;
            }
            finally {
                try {
                    in.closeEntry();
                }
                catch (Exception ignored) {}
            }
        }
        return manifest;
    }

    public static JarInputStream getCorrectInputStream(JarInputStream jin, String entryName) throws Exception {
        if (entryName == null || entryName.length() == 0) {
            return jin;
        }
        JarEntry entry = null;
        while ((entry = jin.getNextJarEntry()) != null) {
            if (entry.isDirectory()) continue;
            String tempName = entry.getName();
            if (entryName.equals(tempName)) {
                return new JarInputStream(jin);
            }
            if (!entryName.startsWith(tempName)) continue;
            return PatchGeneratorUtils.getCorrectInputStream(new JarInputStream(jin), entryName.substring(tempName.length() + 1, entryName.length()));
        }
        return null;
    }

    public static boolean isMatch(String actualString, String pattern, char wildCard) {
        String tempPattern = pattern.trim();
        int matchOffset = 0;
        boolean matched = true;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < tempPattern.length(); ++i) {
            if (tempPattern.charAt(i) != wildCard) {
                buffer.append(tempPattern.charAt(i));
            }
            if (i != tempPattern.length() - 1 && tempPattern.charAt(i) != wildCard || buffer.length() <= 0) continue;
            while (matchOffset < actualString.length()) {
                int matchedIndex = actualString.indexOf(buffer.toString(), matchOffset);
                if (matchedIndex >= matchOffset) {
                    if (i != tempPattern.length() - 1) {
                        matchOffset = matchedIndex + buffer.length();
                        break;
                    }
                    if (tempPattern.charAt(i) == wildCard || actualString.substring(matchedIndex).length() == buffer.length()) break;
                    matchOffset = matchedIndex + 1;
                    continue;
                }
                matched = false;
                break;
            }
            buffer = new StringBuffer();
        }
        return matched;
    }
}

