/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.agentconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.configuration.AgentConfiguration;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.sm.SMSException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;

public class DeleteAgentGroups
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        ArrayList names = rc.getOption("agentgroupnames");
        String file = this.getStringOptionValue("file");
        if (names == null) {
            names = new ArrayList();
        }
        if (file != null) {
            names.addAll(AttributeValues.parseValues(file));
        }
        if (names.isEmpty()) {
            throw new CLIException(this.getResourceString("missing-agent-group-names"), 127);
        }
        String displayableNames = this.tokenize(names);
        String[] params = new String[]{realm, displayableNames};
        this.writeLog(0, Level.INFO, "ATTEMPT_DELETE_AGENT_GROUPS", params);
        try {
            HashSet<AMIdentity> setDelete = new HashSet<AMIdentity>();
            for (String name : names) {
                AMIdentity amid = new AMIdentity(adminSSOToken, name, IdType.AGENTGROUP, realm, null);
                setDelete.add(amid);
            }
            AgentConfiguration.deleteAgentGroups(adminSSOToken, realm, setDelete);
            IOutput outputWriter = this.getOutputWriter();
            outputWriter.printlnMessage(this.getResourceString("delete-agent-group-succeeded"));
            Iterator i = names.iterator();
            while (i.hasNext()) {
                outputWriter.printlnMessage("    " + (String)i.next());
            }
            this.writeLog(0, Level.INFO, "SUCCEED_DELETE_AGENT_GROUPS", params);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, displayableNames, e.getMessage()};
            this.debugError("DeleteAgentGroups.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_DELETE_AGENT_GROUPS", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, displayableNames, e.getMessage()};
            this.debugError("DeleteAgentGroups.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_DELETE_AGENT_GROUPS", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{realm, displayableNames, e.getMessage()};
            this.debugError("DeleteAgentGroups.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_DELETE_AGENT_GROUPS", args);
            throw new CLIException(e, 127);
        }
    }
}

