/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMDisplayType;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.delegation.model.DelegationConfig;
import com.sun.identity.console.policy.ActionTiledView;
import com.sun.identity.console.policy.PolicyOpViewBeanBase;
import com.sun.identity.console.policy.ProfileViewBeanBase;
import com.sun.identity.console.policy.model.CachedPolicy;
import com.sun.identity.console.policy.model.PolicyCache;
import com.sun.identity.console.policy.model.PolicyModel;
import com.sun.identity.policy.ActionSchema;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.Rule;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCEditableListModel;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.html.CCSelectableList;
import com.sun.web.ui.view.table.CCActionTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public abstract class RuleOpViewBeanBase
extends ProfileViewBeanBase {
    protected static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    public static final String CALLING_VIEW_BEAN = "RuleOpViewBeanBaseCallingVB";
    public static final String WITH_RESOURCE = "withResource";
    private static final String PG_SESSION_ACTION_SCHEMA_NAMES = "actionSchemaNames";
    private static final String SELECTION_CHKBOX_NAME = "tblActions.SelectionCheckbox";
    protected static final String SERVICE_TYPE = "tfServiceType";
    protected static final String SERVICE_TYPE_NAME_LBL = "serviceTypeName";
    protected static final String SERVICE_TYPE_NAME = "tfServiceTypeName";
    protected static final String RULE_NAME = "tfRuleName";
    protected static final String MANAGED_RESOURCES = "cbManagedResources";
    protected static final String RESOURCE_NAME = "tfResourceName";
    public static final String ACTIONS_TILED_VIEW = "actionTiledView";
    public static final String TBL_ACTIONS = "tblActions";
    public static final String TBL_ACTIONS_COL_NAME = "tblActionsColName";
    public static final String TBL_ACTIONS_COL_VALUE = "tblActionsColAction";
    public static final String TBL_ACTIONS_DATA_NAME = "tblActionsDataName";
    public static final String TBL_ACTIONS_TEXT_VALUE = "tblActionsTextValue";
    public static final String TBL_ACTIONS_PASSWORD_VALUE = "tblActionsPasswordValue";
    public static final String TBL_ACTIONS_RADIO_VALUE = "tblActionsRadioValue";
    public static final String TBL_ACTIONS_CHECKBOX_VALUE = "tblActionsCheckBoxValue";
    public static final String TBL_ACTIONS_TEXTAREA_VALUE = "tblActionsTextAreaValue";
    public static final String TBL_ACTIONS_DROPDOWN_MENU = "tblActionsDropDownMenuValue";
    public static final String TBL_ACTIONS_SELECTABLE_LIST = "tblActionsSelectableListValue";
    public static final String TBL_ACTIONS_EDITABLE_LIST = "tblActionsEditableListValue";
    protected CCPageTitleModel ptModel;
    private CCActionTableModel tblActionsModel;
    public AMPropertySheetModel propertySheetModel;
    protected boolean submitCycle;
    protected boolean canModify;
    protected Map actionValues = null;
    private List actionSchemas = new ArrayList();

    public RuleOpViewBeanBase(String name, String defaultDisplayURL) {
        super(name, defaultDisplayURL);
        this.createPageTitleModel();
    }

    protected void initialize() {
        if (!this.initialized) {
            try {
                CachedPolicy cachedPolicy = this.getCachedPolicy();
                if (cachedPolicy != null) {
                    super.initialize();
                    this.createPropertyModel();
                    this.createTableModels();
                    this.registerChildren();
                    this.initialized = true;
                }
            }
            catch (AMConsoleException e) {
                debug.warning("RuleOpViewBeanBase.initialize", (Throwable)e);
            }
        }
    }

    protected void createPropertyModel() {
        String realmName = (String)this.getPageSessionAttribute("currentRealm");
        DelegationConfig dConfig = DelegationConfig.getInstance();
        this.canModify = dConfig.hasPermission(realmName, null, "MODIFY", this.getModel(), ((Object)((Object)this)).getClass().getName());
        this.propertySheetModel = new AMPropertySheetModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.getPropertyXMLFileName(!this.canModify)));
        this.propertySheetModel.clear();
    }

    private void createTableModels() {
        this.tblActionsModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblPMRulesActions.xml"));
        this.tblActionsModel.setTitleLabel("label.items");
        this.tblActionsModel.setActionValue(TBL_ACTIONS_COL_NAME, (Object)"policy.rules.actions.table.column.name");
        this.tblActionsModel.setActionValue(TBL_ACTIONS_COL_VALUE, (Object)"policy.rules.actions.table.column.value");
        this.tblActionsModel.setModel(TBL_ACTIONS_EDITABLE_LIST, (Object)new CCEditableListModel());
        this.propertySheetModel.setModel(TBL_ACTIONS, this.tblActionsModel);
    }

    protected abstract void createPageTitleModel();

    protected abstract String getPropertyXMLFileName(boolean var1);

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        this.registerChild(ACTIONS_TILED_VIEW, ActionTiledView.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        if (name.equals(ACTIONS_TILED_VIEW)) {
            view = new ActionTiledView((View)this, this.tblActionsModel, name);
        } else if (this.ptModel.isChildSupported(name)) {
            view = this.ptModel.createChild((View)this, name);
        } else if (name.equals(TBL_ACTIONS)) {
            CCActionTable table = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.tblActionsModel, name);
            table.setTiledView((ContainerView)((ActionTiledView)this.getChild(ACTIONS_TILED_VIEW)));
            view = table;
        } else {
            view = name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name, this.getModel()) : super.createChild(name));
        }
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
    }

    protected void getManagedResources() {
        if (this.canModify) {
            PolicyModel model = (PolicyModel)this.getModel();
            String realmName = (String)this.getPageSessionAttribute("currentRealm");
            String serviceType = (String)this.propertySheetModel.getValue(SERVICE_TYPE);
            CCSelectableList cb = (CCSelectableList)this.getChild(MANAGED_RESOURCES);
            cb.setOptions(this.createOptionList(model.getManagedResources(realmName, serviceType)));
        }
    }

    protected void populateActionsTable(boolean retainSelectedEntry) throws ModelControlException, AMConsoleException {
        CCActionTable table = (CCActionTable)this.getChild(TBL_ACTIONS);
        table.resetStateData();
        this.tblActionsModel.clearAll();
        PolicyModel model = (PolicyModel)this.getModel();
        String realmName = (String)this.getPageSessionAttribute("currentRealm");
        String serviceType = (String)this.propertySheetModel.getValue(SERVICE_TYPE);
        boolean withResource = false;
        Boolean b = (Boolean)this.getPageSessionAttribute(WITH_RESOURCE);
        if (b != null) {
            withResource = b;
        }
        this.actionSchemas = new ArrayList(model.getActionSchemas(this.getCachedPolicy().getPolicy(), realmName, serviceType, withResource));
        if (this.actionSchemas != null && !this.actionSchemas.isEmpty()) {
            int sz = this.actionSchemas.size();
            ArrayList<String> actionSchemaNames = new ArrayList<String>(sz);
            for (int i = 0; i < sz; ++i) {
                if (i > 0) {
                    this.tblActionsModel.appendRow();
                }
                ActionSchema as = (ActionSchema)this.actionSchemas.get(i);
                boolean sel = this.isActionSelected(as);
                this.tblActionsModel.setRowSelected(i, sel);
                actionSchemaNames.add(as.getName());
                this.tblActionsModel.setValue(TBL_ACTIONS_DATA_NAME, (Object)model.getActionSchemaLocalizedName(serviceType, as));
            }
            this.setPageSessionAttribute(PG_SESSION_ACTION_SCHEMA_NAMES, actionSchemaNames);
        }
    }

    protected Rule createRule() throws ModelControlException {
        Rule rule = null;
        String serviceType = (String)this.propertySheetModel.getValue(SERVICE_TYPE);
        String ruleName = this.getRuleName();
        Boolean b = (Boolean)this.getPageSessionAttribute(WITH_RESOURCE);
        boolean withResource = b != null ? b : false;
        String resourceName = withResource ? this.getResourceName() : null;
        Map map = this.actionValues = !this.isReferralPolicy() ? this.getActionValues(serviceType, withResource) : Collections.EMPTY_MAP;
        if (!(ruleName == null || withResource && resourceName == null || this.actionValues == null)) {
            rule = this.createRule(ruleName, serviceType, resourceName, this.actionValues);
        }
        return rule;
    }

    private Rule createRule(String ruleName, String serviceType, String resourceName, Map actionValues) {
        Rule rule = null;
        try {
            rule = new Rule(ruleName, serviceType, resourceName, actionValues);
        }
        catch (NameNotFoundException e) {
            this.setInlineAlertMessage("error", "message.error", this.getModel().getErrorString(e));
        }
        catch (InvalidNameException e) {
            this.setInlineAlertMessage("error", "message.error", this.getModel().getErrorString(e));
        }
        return rule;
    }

    private String getRuleName() {
        String ruleName = (String)this.propertySheetModel.getValue(RULE_NAME);
        if ((ruleName = ruleName.trim()).length() == 0) {
            this.setInlineAlertMessage("error", "message.error", "policy.missing.ruleName");
            ruleName = null;
        }
        return ruleName;
    }

    private String getResourceName() {
        String resourceName = (String)this.propertySheetModel.getValue(RESOURCE_NAME);
        if ((resourceName = resourceName.trim()).length() == 0) {
            this.setInlineAlertMessage("error", "message.error", "policy.missing.resourceName");
            resourceName = null;
        }
        return resourceName;
    }

    private Map getActionValues(String serviceType, boolean withResource) throws ModelControlException {
        HashMap<String, Set> actionValues = new HashMap<String, Set>();
        PolicyModel model = (PolicyModel)this.getModel();
        String realmName = (String)this.getPageSessionAttribute("currentRealm");
        try {
            Map mapActionSchemas = this.mapActionSchemaNameToActionSchema(model.getActionSchemas(this.getCachedPolicy().getPolicy(), realmName, serviceType, withResource));
            CCActionTable table = (CCActionTable)this.getChild(TBL_ACTIONS);
            table.restoreStateData();
            List actionSchemaNames = (List)this.getPageSessionAttribute(PG_SESSION_ACTION_SCHEMA_NAMES);
            if (actionSchemaNames != null && !actionSchemaNames.isEmpty()) {
                HttpServletRequest req = this.getRequestContext().getRequest();
                String chkName = this.getName() + "." + SELECTION_CHKBOX_NAME;
                int sz = actionSchemaNames.size();
                for (int i = 0; i < sz; ++i) {
                    String chkValue = req.getParameter(chkName + i);
                    if (chkValue == null || !chkValue.equals("true")) continue;
                    String actionSchemaName = (String)actionSchemaNames.get(i);
                    ActionSchema actionSchema = (ActionSchema)mapActionSchemas.get(actionSchemaName);
                    Set values = this.getActionSchemaValues(actionSchema, i);
                    actionValues.put(actionSchemaName, values);
                }
            }
            if (actionValues.isEmpty()) {
                this.setInlineAlertMessage("error", "message.error", "policy.missing.actionValues");
                actionValues = null;
            }
        }
        catch (AMConsoleException e) {
            debug.warning("RuleOpViewBeanBase.getActionValues", (Throwable)e);
        }
        return actionValues;
    }

    private Set getActionSchemaValues(ActionSchema actionSchema, int idx) {
        Set values = null;
        AMDisplayType.getInstance();
        int type = AMDisplayType.getDisplayType(actionSchema);
        AMDisplayType.getInstance();
        int syntax = AMDisplayType.getDisplaySyntax(actionSchema);
        this.tblActionsModel.setRowIndex(idx);
        if (type == 0) {
            values = syntax == 6 ? AMAdminUtils.toSet(this.tblActionsModel.getValues(TBL_ACTIONS_RADIO_VALUE)) : (syntax == 3 || syntax == 4 ? AMAdminUtils.toSet(this.tblActionsModel.getValues(TBL_ACTIONS_PASSWORD_VALUE)) : (syntax == 1 ? AMAdminUtils.toSet(this.tblActionsModel.getValues(TBL_ACTIONS_CHECKBOX_VALUE)) : (syntax == 5 ? AMAdminUtils.toSet(this.tblActionsModel.getValues(TBL_ACTIONS_TEXTAREA_VALUE)) : AMAdminUtils.toSet(this.tblActionsModel.getValues(TBL_ACTIONS_TEXT_VALUE)))));
        } else if (type == 3) {
            values = AMAdminUtils.toSet(this.tblActionsModel.getValues(TBL_ACTIONS_EDITABLE_LIST));
        } else if (type == 1) {
            values = AMAdminUtils.toSet(this.tblActionsModel.getValues(TBL_ACTIONS_DROPDOWN_MENU));
        } else if (type == 2) {
            values = AMAdminUtils.toSet(this.tblActionsModel.getValues(TBL_ACTIONS_SELECTABLE_LIST));
        }
        return values == null ? Collections.EMPTY_SET : values;
    }

    private Map mapActionSchemaNameToActionSchema(Set actionSchemas) {
        HashMap<String, ActionSchema> map = new HashMap<String, ActionSchema>(actionSchemas.size() * 2);
        for (ActionSchema as : actionSchemas) {
            map.put(as.getName(), as);
        }
        return map;
    }

    protected CachedPolicy getCachedPolicy() throws AMConsoleException {
        CachedPolicy policy = null;
        String cacheID = (String)this.getPageSessionAttribute("policyCacheID");
        if (cacheID != null) {
            PolicyCache cache = PolicyCache.getInstance();
            PolicyModel model = (PolicyModel)this.getModel();
            policy = model.getCachedPolicy(cacheID);
        }
        return policy;
    }

    public void handleButton3Request(RequestInvocationEvent event) {
        this.backTrail();
        this.forwardToPolicyViewBean();
    }

    protected void forwardToPolicyViewBean() {
        try {
            Class<?> clazz = Class.forName((String)this.removePageSessionAttribute(CALLING_VIEW_BEAN));
            PolicyOpViewBeanBase vb = (PolicyOpViewBeanBase)this.getViewBean(clazz);
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
        catch (ClassNotFoundException e) {
            debug.error("RuleOpViewBeanBase.forwardToPolicyViewBean", (Throwable)e);
            this.forwardTo();
        }
    }

    public OptionList getChoiceValues(String serviceType, ActionSchema as) {
        PolicyModel model = (PolicyModel)this.getModel();
        return model.getChoiceValues(serviceType, as);
    }

    public ActionSchema getActionSchema(int idx) {
        return (ActionSchema)this.actionSchemas.get(idx);
    }

    protected boolean isReferralPolicy() {
        try {
            CachedPolicy cachedPolicy = this.getCachedPolicy();
            Policy policy = cachedPolicy.getPolicy();
            return policy.isReferralPolicy();
        }
        catch (AMConsoleException e) {
            debug.warning("RuleOpViewBeanBase.isReferralPolicy", (Throwable)e);
            return false;
        }
    }

    public boolean isSubmitCycle() {
        return this.submitCycle;
    }

    public Set getCurrentActionValues(ActionSchema as) {
        Set values = null;
        if (this.actionValues != null) {
            values = (Set)this.actionValues.get(as.getName());
        }
        return values == null ? Collections.EMPTY_SET : values;
    }

    public abstract Set getDefaultActionValues(ActionSchema var1);

    public abstract boolean isActionSelected(ActionSchema var1);
}

