/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.cli;

import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cot.COTException;
import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.federation.cli.FederationManager;
import java.text.MessageFormat;
import java.util.Set;
import java.util.logging.Level;

public class ListCircleOfTrustMembers
extends AuthenticatedCommand {
    private String realm;
    private String cot;
    private String spec;

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        this.superAdminUserValidation();
        this.realm = this.getStringOptionValue("realm", "/");
        this.cot = this.getStringOptionValue("cot");
        IOutput outputWriter = this.getOutputWriter();
        this.spec = FederationManager.getIDFFSubCommandSpecification(rc);
        String[] params = new String[]{this.realm, this.cot, this.spec};
        this.writeLog(0, Level.INFO, "ATTEMPT_LIST_COT_MEMBERS", params);
        try {
            CircleOfTrustManager cotManager = new CircleOfTrustManager();
            Set circleOfTrusts = cotManager.getAllCirclesOfTrust(this.realm);
            if (!circleOfTrusts.contains(this.cot)) {
                Object[] obj = new Object[]{this.cot};
                String[] args = new String[]{this.realm, this.cot, this.spec, MessageFormat.format(this.getResourceString("list-circle-of-trust-members-cot-does-not-exists"), obj)};
                this.writeLog(1, Level.INFO, "FAILED_LIST_COT_MEMBERS", args);
                throw new CLIException(MessageFormat.format(this.getResourceString("list-circle-of-trust-members-cot-does-not-exists"), obj), 127);
            }
            Set members = cotManager.listCircleOfTrustMember(this.realm, this.cot, this.spec);
            if (members == null || members.isEmpty()) {
                Object[] obj = new Object[]{this.cot};
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("list-circle-of-trust-members-no-members"), obj));
            } else {
                Object[] obj = new Object[]{this.cot};
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("list-circle-of-trust-members-members"), obj));
                for (String entityId : members) {
                    outputWriter.printlnMessage("  " + entityId);
                }
            }
            this.writeLog(0, Level.INFO, "SUCCEEDED_LIST_COT_MEMBERS", params);
        }
        catch (COTException e) {
            this.debugWarning("ListCircleOfTrustMembers.handleRequest", e);
            String[] args = new String[]{this.realm, this.cot, this.spec, e.getMessage()};
            this.writeLog(1, Level.INFO, "FAILED_LIST_COT_MEMBERS", args);
            throw new CLIException(e.getMessage(), 127);
        }
    }
}

