/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.provider.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wss.provider.DiscoveryConfig;
import com.sun.identity.wss.provider.ProviderException;
import com.sun.identity.wss.provider.ProviderUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DiscoveryAgent
extends DiscoveryConfig {
    private static Set attrNames = new HashSet();
    private static final String AGENT_PASSWORD_ATTR = "userpassword";
    private static final String AGENT_DEVICE_STATUS_ATTR = "sunIdentityServerDeviceStatus";
    private static final String AGENT_TYPE_ATTR = "AgentType";
    private static final String ENDPOINT = "DiscoveryEndpoint";
    private static final String KEY_ALIAS = "privateKeyAlias";
    private static final String AUTHN_ENDPOINT = "AuthNServiceEndpoint";
    private AMIdentityRepository idRepo;
    private static Set agentConfigAttribute;
    private static Debug debug;
    private SSOToken token;
    private boolean profilePresent;

    public DiscoveryAgent() {
    }

    public DiscoveryAgent(AMIdentity amIdentity) throws ProviderException {
        try {
            this.name = amIdentity.getName();
            this.type = amIdentity.getType().getName();
            Map attributes = amIdentity.getAttributes(attrNames);
            this.parseAgentKeyValues(attributes);
        }
        catch (IdRepoException ire) {
            debug.error("STSAgent.constructor: Idrepo exception", (Throwable)ire);
            throw new ProviderException(ire.getMessage());
        }
        catch (SSOException se) {
            debug.error("STSAgent.constructor: SSO exception", (Throwable)se);
            throw new ProviderException(se.getMessage());
        }
    }

    public void init(String name, String type, SSOToken token) throws ProviderException {
        this.name = name;
        this.type = type;
        this.token = token;
        try {
            AMIdentity provider = new AMIdentity(token, name, IdType.AGENT, "/", null);
            if (!provider.isExists()) {
                if (debug.messageEnabled()) {
                    debug.message("DiscoveryAgent.init: provider " + name + "does not exist");
                }
                return;
            }
            Map attributes = provider.getAttributes(attrNames);
            this.profilePresent = true;
            this.parseAgentKeyValues(attributes);
        }
        catch (IdRepoException ire) {
            if (ire.getErrorCode().equals("402")) {
                this.profilePresent = false;
                return;
            }
            debug.error("DiscoveryAgent.init: Unable to get idRepo", (Throwable)ire);
            throw new ProviderException("idRepo exception: " + ire.getMessage());
        }
        catch (Exception e) {
            debug.error("DiscoveryAgent.init: Unable to get idRepo", (Throwable)e);
            throw new ProviderException("idRepo exception: " + e.getMessage());
        }
    }

    private void parseAgentKeyValues(Map attributes) throws ProviderException {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        for (String key : attributes.keySet()) {
            Set valSet = (Set)attributes.get(key);
            String value = null;
            if (valSet != null && valSet.size() > 0) {
                Iterator iter = valSet.iterator();
                StringBuffer sb = new StringBuffer(100);
                while (iter.hasNext()) {
                    sb.append((String)iter.next()).append(",");
                }
                sb = sb.deleteCharAt(sb.length() - 1);
                value = sb.toString();
            }
            this.setConfig(key, value);
        }
    }

    private void setConfig(String attr, String value) {
        if (debug.messageEnabled()) {
            debug.message("Attribute name: " + attr + " Value: " + value);
        }
        if (attr.equals(AUTHN_ENDPOINT)) {
            this.authServiceEndpoint = value;
        } else if (attr.equals(ENDPOINT)) {
            this.endpoint = value;
        } else if (attr.equals(KEY_ALIAS)) {
            this.privateKeyAlias = value;
        } else if (ProviderUtils.debug.messageEnabled()) {
            ProviderUtils.debug.message("DiscoveryAgent.setConfig: Invalid Attribute configured." + attr);
        }
    }

    public void store() throws ProviderException {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(AGENT_TYPE_ATTR, this.type);
        config.put(AGENT_PASSWORD_ATTR, this.name);
        config.put(AGENT_DEVICE_STATUS_ATTR, "Active");
        if (this.authServiceEndpoint != null) {
            config.put(AUTHN_ENDPOINT, this.authServiceEndpoint);
        }
        if (this.endpoint != null) {
            config.put(ENDPOINT, this.endpoint);
        }
        if (this.privateKeyAlias != null) {
            config.put(KEY_ALIAS, this.privateKeyAlias);
        }
        try {
            HashMap attributes = new HashMap();
            HashSet<String> values = null;
            for (String key : config.keySet()) {
                String value = (String)config.get(key);
                values = new HashSet<String>();
                values.add(value);
                attributes.put(key, values);
            }
            if (this.profilePresent) {
                attributes.remove(AGENT_TYPE_ATTR);
                AMIdentity id = new AMIdentity(this.token, this.name, IdType.AGENT, "/", null);
                if (debug.messageEnabled()) {
                    debug.message("Attributes to be stored: " + attributes);
                }
                id.setAttributes(attributes);
                id.store();
            } else {
                if (this.idRepo == null) {
                    this.idRepo = new AMIdentityRepository(this.token, "/");
                }
                this.idRepo.createIdentity(IdType.AGENT, this.name, attributes);
            }
        }
        catch (Exception e) {
            debug.error("DiscoveryAgent.store: Unable to get idRepo", (Throwable)e);
            throw new ProviderException("idRepo exception: " + e.getMessage());
        }
    }

    public void delete() throws ProviderException {
        if (!this.profilePresent) {
            return;
        }
        try {
            if (this.idRepo == null) {
                this.idRepo = new AMIdentityRepository(this.token, "/");
            }
            AMIdentity id = new AMIdentity(this.token, this.name, IdType.AGENT, "/", null);
            HashSet<AMIdentity> identities = new HashSet<AMIdentity>();
            identities.add(id);
            this.idRepo.deleteIdentities(identities);
        }
        catch (Exception e) {
            debug.error("DiscoveryAgent.delete: Unable to get idRepo", (Throwable)e);
            throw new ProviderException("idRepo exception: " + e.getMessage());
        }
    }

    private String getKeyValue(String key, String value) {
        return key + "=" + value;
    }

    static {
        debug = ProviderUtils.debug;
        attrNames.add(ENDPOINT);
        attrNames.add(AUTHN_ENDPOINT);
        attrNames.add(KEY_ALIAS);
    }
}

