/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.naming.share;

import com.iplanet.services.naming.share.NamingResponseParser;
import java.util.Enumeration;
import java.util.Hashtable;

public class NamingResponse {
    static final String QUOTE = "\"";
    static final String NL = "\n";
    private String responseVersion = "1.0";
    private String requestID = null;
    private Hashtable namingTable = new Hashtable();
    private String exception = null;

    public NamingResponse(String reqid) {
        this.requestID = reqid;
    }

    NamingResponse() {
    }

    public static NamingResponse parseXML(String xml) {
        NamingResponseParser parser = new NamingResponseParser(xml);
        return parser.parseXML();
    }

    void setResponseVersion(String version) {
        this.responseVersion = version;
    }

    public String getResponseVersion() {
        return this.responseVersion;
    }

    void setRequestID(String id) {
        this.requestID = id;
    }

    public String getRequestID() {
        return this.requestID;
    }

    public void setAttribute(String name, String value) {
        this.namingTable.put(name, value);
    }

    public String getAttribute(String name) {
        return (String)this.namingTable.get(name);
    }

    public Hashtable getNamingTable() {
        return this.namingTable;
    }

    public void setNamingTable(Hashtable table) {
        this.namingTable = table;
    }

    public void setException(String ex) {
        this.exception = ex;
    }

    public String getException() {
        return this.exception;
    }

    public void replaceURI(String uri) {
        if (this.namingTable != null && !this.namingTable.isEmpty()) {
            Hashtable<String, String> newNamingTable = new Hashtable<String, String>();
            Enumeration e = this.namingTable.keys();
            while (e.hasMoreElements()) {
                String name = e.nextElement().toString();
                String value = this.namingTable.get(name).toString();
                if (value.indexOf("%uri") != -1) {
                    value = value.replaceAll("%uri", uri);
                } else {
                    try {
                        Integer.parseInt(name);
                        int li = value.lastIndexOf(uri);
                        if (li != -1 && value.endsWith(uri)) {
                            value = value.substring(0, li);
                        }
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
                newNamingTable.put(name, value);
            }
            this.namingTable = newNamingTable;
        }
    }

    public String toXMLString() {
        StringBuffer xml = new StringBuffer(200);
        xml.append("<NamingResponse vers=").append(QUOTE).append(this.responseVersion).append(QUOTE).append(" reqid=").append(QUOTE).append(this.requestID).append(QUOTE).append(">").append(NL);
        xml.append("<GetNamingProfile>").append(NL);
        if (this.exception != null) {
            xml.append("<Exception>").append(this.exception).append("</Exception>").append(NL);
        } else {
            Enumeration e = this.namingTable.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = (String)this.namingTable.get(name);
                xml.append("<Attribute name=").append(QUOTE).append(name).append(QUOTE).append(" value=").append(QUOTE).append(value).append("\">").append("</Attribute>").append(NL);
            }
        }
        xml.append("</GetNamingProfile>\n");
        xml.append("</NamingResponse>");
        return xml.toString();
    }
}

