/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.opensso;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.IPrivilege;
import com.sun.identity.entitlement.Privilege;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.ReferralPrivilege;
import com.sun.identity.entitlement.ResourceSaveIndexes;
import com.sun.identity.entitlement.ResourceSearchIndexes;
import com.sun.identity.entitlement.SubjectAttributesManager;
import com.sun.identity.entitlement.opensso.EntitlementsStats;
import com.sun.identity.entitlement.opensso.Notifier;
import com.sun.identity.entitlement.opensso.SubjectUtils;
import com.sun.identity.entitlement.util.NetworkMonitor;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.BufferedIterator;
import com.sun.identity.shared.ldap.LDAPDN;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.shared.stats.Stats;
import com.sun.identity.shared.stats.StatsListener;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.SMSDataEntry;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataStore {
    private static DataStore instance = new DataStore();
    public static final String POLICY_STORE = "default";
    public static final String REFERRAL_STORE = "referrals";
    private static final String SERVICE_NAME = "sunEntitlementIndexes";
    private static final String INDEX_COUNT = "indexCount";
    private static final String REFERRAL_INDEX_COUNT = "referralIndexCount";
    private static final String REALM_DN_TEMPLATE = "ou={0},ou=default,ou=OrganizationConfig,ou=1.0,ou=sunEntitlementIndexes,ou=services,{1}";
    private static final String SUBJECT_INDEX_KEY = "subjectindex";
    private static final String HOST_INDEX_KEY = "hostindex";
    private static final String PATH_INDEX_KEY = "pathindex";
    private static final String PATH_PARENT_INDEX_KEY = "pathparentindex";
    private static final String SERIALIZABLE_INDEX_KEY = "serializable";
    public static final String REFERRAL_REALMS = "referralrealms";
    public static final String REFERRAL_APPLS = "referralappls";
    private static final String SUBJECT_FILTER_TEMPLATE = "(sunxmlKeyValue=subjectindex={0})";
    private static final String HOST_FILTER_TEMPLATE = "(sunxmlKeyValue=hostindex={0})";
    private static final String PATH_FILTER_TEMPLATE = "(sunxmlKeyValue=pathindex={0})";
    private static final String PATH_PARENT_FILTER_TEMPLATE = "(sunxmlKeyValue=pathparentindex={0})";
    private static final NetworkMonitor DB_MONITOR_PRIVILEGE = NetworkMonitor.getInstance("dbLookupPrivileges");
    private static final NetworkMonitor DB_MONITOR_REFERRAL = NetworkMonitor.getInstance("dbLookupReferrals");
    static HashMap<String, Integer> policiesPerRealm = new HashMap();
    static HashMap<String, Integer> referralsPerRealm = new HashMap();
    private static SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());

    private DataStore() {
    }

    public static DataStore getInstance() {
        return instance;
    }

    public static String getPrivilegeDistinguishedName(String name, String realm, String indexName) {
        return "ou=" + name + "," + DataStore.getSearchBaseDN(realm, indexName);
    }

    public static String getSearchBaseDN(String realm, String indexName) {
        if (indexName == null) {
            indexName = POLICY_STORE;
        }
        Object[] args = new Object[]{indexName, DNMapper.orgNameToDN(realm)};
        return MessageFormat.format(REALM_DN_TEMPLATE, args);
    }

    private String createDefaultSubConfig(SSOToken adminToken, String realm, String indexName) throws SMSException, SSOException {
        ServiceConfig orgConf;
        Set subConfigNames;
        if (indexName == null) {
            indexName = POLICY_STORE;
        }
        if (!(subConfigNames = (orgConf = this.getOrgConfig(adminToken, realm)).getSubConfigNames()).contains(indexName)) {
            orgConf.addSubConfig(indexName, "type", 0, Collections.EMPTY_MAP);
        }
        ServiceConfig defSubConfig = orgConf.getSubConfig(indexName);
        return defSubConfig.getDN();
    }

    private ServiceConfig getOrgConfig(SSOToken adminToken, String realm) throws SMSException, SSOException {
        ServiceConfigManager mgr = new ServiceConfigManager(SERVICE_NAME, adminToken);
        ServiceConfig orgConf = mgr.getOrganizationConfig(realm, null);
        if (orgConf == null) {
            mgr.createOrganizationConfig(realm, null);
        }
        return orgConf;
    }

    void clearIndexCount(String realm, boolean referral) {
        if (referral) {
            referralsPerRealm.remove(DNMapper.orgNameToDN(realm));
        } else {
            policiesPerRealm.remove(DNMapper.orgNameToDN(realm));
        }
    }

    private void updateIndexCount(String realm, int num, boolean referral) {
        try {
            String key = referral ? REFERRAL_INDEX_COUNT : INDEX_COUNT;
            ServiceConfig orgConf = this.getOrgConfig(adminToken, realm);
            Map map = orgConf.getAttributes();
            HashSet<String> set = (HashSet<String>)map.get(key);
            int count = num;
            if (set != null && !set.isEmpty()) {
                String strCount = (String)set.iterator().next();
                count += Integer.parseInt(strCount);
                set.clear();
            } else {
                set = new HashSet<String>();
                map.put(key, set);
            }
            set.add(Integer.toString(count));
            orgConf.setAttributes(map);
            if (referral) {
                referralsPerRealm.put(DNMapper.orgNameToDN(realm), count);
            } else {
                policiesPerRealm.put(DNMapper.orgNameToDN(realm), count);
            }
        }
        catch (NumberFormatException ex) {
            PrivilegeManager.debug.error("DataStore.updateIndexCount", (Throwable)ex);
        }
        catch (SMSException ex) {
            PrivilegeManager.debug.error("DataStore.updateIndexCount", (Throwable)ex);
        }
        catch (SSOException ex) {
            PrivilegeManager.debug.error("DataStore.updateIndexCount", (Throwable)((Object)ex));
        }
    }

    private int getIndexCount(String realm, boolean referral) {
        int count = 0;
        if (adminToken != null) {
            try {
                ServiceConfigManager mgr = new ServiceConfigManager(SERVICE_NAME, adminToken);
                ServiceConfig orgConf = mgr.getOrganizationConfig(realm, null);
                if (orgConf != null) {
                    Set set;
                    Map map = orgConf.getAttributes();
                    Set set2 = set = referral ? (Set)map.get(REFERRAL_INDEX_COUNT) : (Set)map.get(INDEX_COUNT);
                    if (set != null && !set.isEmpty()) {
                        String strCount = (String)set.iterator().next();
                        count = Integer.parseInt(strCount);
                    }
                }
            }
            catch (NumberFormatException ex) {
                PrivilegeManager.debug.error("DataStore.getIndexCount", (Throwable)ex);
            }
            catch (SMSException ex) {
                PrivilegeManager.debug.error("DataStore.getIndexCount", (Throwable)ex);
            }
            catch (SSOException ex) {
                PrivilegeManager.debug.error("DataStore.getIndexCount", (Throwable)((Object)ex));
            }
        }
        return count;
    }

    int getNumberOfPolicies(String realm) {
        int totalPolicies = 0;
        Integer tp = policiesPerRealm.get(realm);
        if (tp == null) {
            totalPolicies = this.getIndexCount(realm, false);
            policiesPerRealm.put(realm, totalPolicies);
        } else {
            totalPolicies = tp;
        }
        return totalPolicies;
    }

    int getNumberOfReferrals(String realm) {
        int referralCnt = 0;
        Integer tp = referralsPerRealm.get(realm);
        if (tp == null) {
            referralCnt = this.getIndexCount(realm, true);
            referralsPerRealm.put(realm, referralCnt);
        } else {
            referralCnt = tp;
        }
        return referralCnt;
    }

    public String add(Subject adminSubject, String realm, Privilege p) throws EntitlementException {
        ResourceSaveIndexes indexes = p.getEntitlement().getResourceSaveIndexes(adminSubject, realm);
        Set<String> subjectIndexes = SubjectAttributesManager.getSubjectSearchIndexes(p);
        String dn = null;
        try {
            long lastModifiedDate;
            long creationDate;
            String lastModifiedBy;
            String createdBy;
            String privilegeDesc;
            this.createDefaultSubConfig(adminToken, realm, null);
            dn = DataStore.getPrivilegeDistinguishedName(p.getName(), realm, null);
            SMSEntry s = new SMSEntry(adminToken, dn);
            HashMap map = new HashMap();
            HashSet<String> searchable = new HashSet<String>();
            map.put("sunxmlKeyValue", searchable);
            for (String i : indexes.getHostIndexes()) {
                searchable.add("hostindex=" + i);
            }
            for (String i : indexes.getPathIndexes()) {
                searchable.add("pathindex=" + i);
            }
            for (String i : indexes.getParentPathIndexes()) {
                searchable.add("pathparentindex=" + i);
            }
            for (String i : subjectIndexes) {
                searchable.add("subjectindex=" + i);
            }
            HashSet<String> setServiceID = new HashSet<String>(2);
            map.put("sunserviceID", setServiceID);
            setServiceID.add("indexes");
            HashSet<String> set = new HashSet<String>(2);
            map.put("sunKeyValue", set);
            set.add("serializable=" + p.toJSONObject().toString());
            HashSet<String> setObjectClass = new HashSet<String>(4);
            map.put("objectclass", setObjectClass);
            setObjectClass.add("top");
            setObjectClass.add("sunServiceComponent");
            HashSet<String> info = new HashSet<String>(8);
            String privilegeName = p.getName();
            if (privilegeName != null) {
                info.add("ou=" + privilegeName);
            }
            if ((privilegeDesc = p.getDescription()) != null) {
                info.add("description=" + privilegeDesc);
            }
            if ((createdBy = p.getCreatedBy()) != null) {
                info.add("createdby=" + createdBy);
            }
            if ((lastModifiedBy = p.getLastModifiedBy()) != null) {
                info.add("lastmodifiedby=" + lastModifiedBy);
            }
            if ((creationDate = p.getCreationDate()) > 0L) {
                String data = Long.toString(creationDate) + "=" + "creationdate";
                info.add(data);
                info.add("|" + data);
            }
            if ((lastModifiedDate = p.getLastModifiedDate()) > 0L) {
                String data = Long.toString(lastModifiedDate) + "=" + "lastmodifieddate";
                info.add(data);
                info.add("|" + data);
            }
            map.put("ou", info);
            s.setAttributes(map);
            s.save();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("name", privilegeName);
            params.put("realm", realm);
            Notifier.submit("privilegeadded", params);
            this.updateIndexCount(realm, 1, false);
        }
        catch (JSONException e) {
            throw new EntitlementException(210, (Throwable)e);
        }
        catch (SSOException e) {
            throw new EntitlementException(210, (Throwable)((Object)e));
        }
        catch (SMSException e) {
            throw new EntitlementException(210, (Throwable)e);
        }
        return dn;
    }

    public String addReferral(Subject adminSubject, String realm, ReferralPrivilege referral) throws EntitlementException {
        ResourceSaveIndexes indexes = referral.getResourceSaveIndexes(adminSubject, realm);
        SSOToken token = this.getSSOToken(adminSubject);
        String dn = null;
        try {
            long lastModifiedDate;
            long creationDate;
            String lastModifiedBy;
            String createdBy;
            String privilegeDesc;
            this.createDefaultSubConfig(token, realm, REFERRAL_STORE);
            dn = DataStore.getPrivilegeDistinguishedName(referral.getName(), realm, REFERRAL_STORE);
            SMSEntry s = new SMSEntry(token, dn);
            HashMap map = new HashMap();
            HashSet<String> searchable = new HashSet<String>();
            map.put("sunxmlKeyValue", searchable);
            if (indexes != null) {
                for (String i : indexes.getHostIndexes()) {
                    searchable.add("hostindex=" + i);
                }
                for (String i : indexes.getPathIndexes()) {
                    searchable.add("pathindex=" + i);
                }
                for (String i : indexes.getParentPathIndexes()) {
                    searchable.add("pathparentindex=" + i);
                }
            }
            HashSet<String> setServiceID = new HashSet<String>(2);
            map.put("sunserviceID", setServiceID);
            setServiceID.add("indexes");
            HashSet<String> set = new HashSet<String>(2);
            map.put("sunKeyValue", set);
            set.add("serializable=" + referral.toJSON());
            HashSet<String> setObjectClass = new HashSet<String>(4);
            map.put("objectclass", setObjectClass);
            setObjectClass.add("top");
            setObjectClass.add("sunServiceComponent");
            HashSet<String> info = new HashSet<String>(8);
            String privilegeName = referral.getName();
            if (privilegeName != null) {
                info.add("ou=" + privilegeName);
            }
            if ((privilegeDesc = referral.getDescription()) != null) {
                info.add("description=" + privilegeDesc);
            }
            if ((createdBy = referral.getCreatedBy()) != null) {
                info.add("createdby=" + createdBy);
            }
            if ((lastModifiedBy = referral.getLastModifiedBy()) != null) {
                info.add("lastmodifiedby=" + lastModifiedBy);
            }
            if ((creationDate = referral.getCreationDate()) > 0L) {
                String data = Long.toString(creationDate) + "=" + "creationdate";
                info.add(data);
                info.add("|" + data);
            }
            if ((lastModifiedDate = referral.getLastModifiedDate()) > 0L) {
                String data = Long.toString(lastModifiedDate) + "=" + "lastmodifieddate";
                info.add(data);
                info.add("|" + data);
            }
            for (String rlm : referral.getRealms()) {
                info.add("referralrealms=" + rlm);
            }
            for (String n : referral.getApplicationTypeNames(adminSubject, realm)) {
                info.add("referralappls=" + n);
            }
            map.put("ou", info);
            s.setAttributes(map);
            s.save();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("name", privilegeName);
            params.put("realm", realm);
            Notifier.submit("referraladded", params);
            this.updateIndexCount(realm, 1, true);
        }
        catch (SSOException e) {
            throw new EntitlementException(270, (Throwable)((Object)e));
        }
        catch (SMSException e) {
            throw new EntitlementException(270, (Throwable)e);
        }
        return dn;
    }

    public void remove(Subject adminSubject, String realm, String name) throws EntitlementException {
        SSOToken token = this.getSSOToken(adminSubject);
        if (token == null) {
            Object[] arg = new Object[]{name};
            throw new EntitlementException(55, arg);
        }
        String dn = null;
        try {
            dn = DataStore.getPrivilegeDistinguishedName(name, realm, null);
            if (SMSEntry.checkIfEntryExists(dn, token)) {
                SMSEntry s = new SMSEntry(token, dn);
                s.delete();
                this.updateIndexCount(realm, -1, false);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("name", name);
                params.put("realm", realm);
                Notifier.submit("privilegedeleted", params);
            }
        }
        catch (SMSException e) {
            Object[] arg = new Object[]{dn};
            throw new EntitlementException(51, arg, e);
        }
        catch (SSOException e) {
            throw new EntitlementException(10, null, (Throwable)((Object)e));
        }
    }

    public void removeReferral(Subject adminSubject, String realm, String name) throws EntitlementException {
        SSOToken token = this.getSSOToken(adminSubject);
        if (token == null) {
            Object[] arg = new Object[]{name};
            throw new EntitlementException(55, arg);
        }
        String dn = null;
        try {
            dn = DataStore.getPrivilegeDistinguishedName(name, realm, REFERRAL_STORE);
            if (SMSEntry.checkIfEntryExists(dn, token)) {
                SMSEntry s = new SMSEntry(token, dn);
                s.delete();
                this.updateIndexCount(realm, -1, true);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("name", name);
                params.put("realm", realm);
                Notifier.submit("referraldeleted", params);
            }
        }
        catch (SMSException e) {
            Object[] arg = new Object[]{dn};
            throw new EntitlementException(51, arg, e);
        }
        catch (SSOException e) {
            throw new EntitlementException(10, null, (Throwable)((Object)e));
        }
    }

    public Set<String> search(Subject adminSubject, String realm, String filter, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws EntitlementException {
        HashSet<String> results;
        block5: {
            results = new HashSet<String>();
            try {
                SSOToken token = this.getSSOToken(adminSubject);
                if (token == null) {
                    throw new EntitlementException(216);
                }
                String baseDN = DataStore.getSearchBaseDN(realm, null);
                if (SMSEntry.checkIfEntryExists(baseDN, token)) {
                    Set dns = SMSEntry.search(token, baseDN, filter);
                    for (String dn : dns) {
                        String[] rdns;
                        if (DataStore.areDNIdentical(baseDN, dn) || (rdns = LDAPDN.explodeDN((String)dn, (boolean)true)) == null || rdns.length <= 0) continue;
                        results.add(rdns[0]);
                    }
                    break block5;
                }
                return Collections.EMPTY_SET;
            }
            catch (SMSException ex) {
                throw new EntitlementException(215, (Throwable)ex);
            }
        }
        return results;
    }

    public Set<String> searchReferral(Subject adminSubject, String realm, String filter, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws EntitlementException {
        HashSet<String> results;
        block5: {
            results = new HashSet<String>();
            try {
                SSOToken token = this.getSSOToken(adminSubject);
                if (token == null) {
                    throw new EntitlementException(216);
                }
                String baseDN = DataStore.getSearchBaseDN(realm, REFERRAL_STORE);
                if (SMSEntry.checkIfEntryExists(baseDN, token)) {
                    Set dns = SMSEntry.search(token, baseDN, filter);
                    for (String dn : dns) {
                        String[] rdns;
                        if (DataStore.areDNIdentical(baseDN, dn) || (rdns = LDAPDN.explodeDN((String)dn, (boolean)true)) == null || rdns.length <= 0) continue;
                        results.add(rdns[0]);
                    }
                    break block5;
                }
                return Collections.EMPTY_SET;
            }
            catch (SMSException ex) {
                throw new EntitlementException(215, (Throwable)ex);
            }
        }
        return results;
    }

    private static boolean areDNIdentical(String dn1, String dn2) {
        DN dnObj1 = new DN(dn1);
        DN dnObj2 = new DN(dn2);
        return dnObj1.equals(dnObj2);
    }

    public Set<IPrivilege> search(Subject adminSubject, String realm, BufferedIterator iterator, ResourceSearchIndexes indexes, Set<String> subjectIndexes, boolean bSubTree, Set<String> excludeDNs) throws EntitlementException {
        SSOToken token = this.getSSOToken(adminSubject);
        Set<IPrivilege> results = this.searchPrivileges(realm, iterator, indexes, subjectIndexes, bSubTree, excludeDNs);
        int countInt = this.getNumberOfReferrals(realm);
        if (countInt > 0) {
            results.addAll(this.searchReferral(token, realm, iterator, indexes, bSubTree, excludeDNs));
        }
        return results;
    }

    private Set<IPrivilege> searchPrivileges(String realm, BufferedIterator iterator, ResourceSearchIndexes indexes, Set<String> subjectIndexes, boolean bSubTree, Set<String> excludeDNs) throws EntitlementException {
        HashSet<IPrivilege> results = new HashSet<IPrivilege>();
        String filter = this.getFilter(indexes, subjectIndexes, bSubTree);
        String baseDN = DataStore.getSearchBaseDN(realm, null);
        if (filter != null) {
            SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            long start = DB_MONITOR_PRIVILEGE.start();
            if (SMSEntry.checkIfEntryExists(baseDN, token)) {
                try {
                    Iterator i = SMSEntry.search(token, baseDN, filter, excludeDNs);
                    while (i.hasNext()) {
                        SMSDataEntry e = (SMSDataEntry)i.next();
                        Privilege privilege = Privilege.getInstance(new JSONObject(e.getAttributeValue(SERIALIZABLE_INDEX_KEY)));
                        iterator.add((Object)privilege);
                        results.add(privilege);
                    }
                }
                catch (JSONException e) {
                    Object[] arg = new Object[]{baseDN};
                    throw new EntitlementException(52, arg, e);
                }
                catch (SMSException e) {
                    Object[] arg = new Object[]{baseDN};
                    throw new EntitlementException(52, arg, e);
                }
            }
            DB_MONITOR_PRIVILEGE.end(start);
        }
        return results;
    }

    public Set<ReferralPrivilege> searchReferral(SSOToken adminToken, String realm, BufferedIterator iterator, ResourceSearchIndexes indexes, boolean bSubTree, Set<String> excludeDNs) throws EntitlementException {
        HashSet<ReferralPrivilege> results = new HashSet<ReferralPrivilege>();
        String filter = this.getFilter(indexes, null, bSubTree);
        String baseDN = DataStore.getSearchBaseDN(realm, REFERRAL_STORE);
        if (filter != null) {
            SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            long start = DB_MONITOR_REFERRAL.start();
            if (SMSEntry.checkIfEntryExists(baseDN, token)) {
                try {
                    Iterator i = SMSEntry.search(token, baseDN, filter, excludeDNs);
                    while (i.hasNext()) {
                        SMSDataEntry e = (SMSDataEntry)i.next();
                        ReferralPrivilege referral = ReferralPrivilege.getInstance(new JSONObject(e.getAttributeValue(SERIALIZABLE_INDEX_KEY)));
                        iterator.add((Object)referral);
                        results.add(referral);
                    }
                    iterator.isDone();
                }
                catch (JSONException e) {
                    Object[] arg = new Object[]{baseDN};
                    throw new EntitlementException(52, arg, e);
                }
                catch (SMSException e) {
                    Object[] arg = new Object[]{baseDN};
                    throw new EntitlementException(52, arg, e);
                }
            }
            DB_MONITOR_REFERRAL.end(start);
        }
        return results;
    }

    private String getFilter(ResourceSearchIndexes indexes, Set<String> subjectIndexes, boolean bSubTree) {
        Set<String> hostIndexes;
        StringBuffer filter = new StringBuffer();
        if (subjectIndexes != null && !subjectIndexes.isEmpty()) {
            filter.append("(|");
            for (String i : subjectIndexes) {
                Object[] o = new Object[]{i};
                filter.append(MessageFormat.format(SUBJECT_FILTER_TEMPLATE, o));
            }
            filter.append(")");
        }
        if ((hostIndexes = indexes.getHostIndexes()) != null && !hostIndexes.isEmpty()) {
            filter.append("(|");
            for (String h : indexes.getHostIndexes()) {
                Object[] o = new Object[]{h};
                filter.append(MessageFormat.format(HOST_FILTER_TEMPLATE, o));
            }
            filter.append(")");
        }
        if (bSubTree) {
            Set<String> parentPathIndexes = indexes.getParentPathIndexes();
            filter.append("(|");
            if (parentPathIndexes != null && !parentPathIndexes.isEmpty()) {
                for (String p : parentPathIndexes) {
                    Object[] o = new Object[]{p};
                    filter.append(MessageFormat.format(PATH_PARENT_FILTER_TEMPLATE, o));
                }
            }
            filter.append(")");
        } else {
            Set<String> pathIndexes = indexes.getPathIndexes();
            if (pathIndexes != null && !pathIndexes.isEmpty()) {
                filter.append("(|");
                for (String p : pathIndexes) {
                    Object[] o = new Object[]{p};
                    filter.append(MessageFormat.format(PATH_FILTER_TEMPLATE, o));
                }
                filter.append(")");
            }
        }
        String result = filter.toString();
        return result.length() > 0 ? "(&" + result + ")" : null;
    }

    public Set<ReferralPrivilege> searchReferrals(SSOToken adminToken, String realm, String filter) throws EntitlementException {
        HashSet<ReferralPrivilege> results = new HashSet<ReferralPrivilege>();
        String baseDN = DataStore.getSearchBaseDN(realm, REFERRAL_STORE);
        if (SMSEntry.checkIfEntryExists(baseDN, adminToken)) {
            try {
                Iterator i = SMSEntry.search(adminToken, baseDN, filter, Collections.EMPTY_SET);
                while (i.hasNext()) {
                    SMSDataEntry e = (SMSDataEntry)i.next();
                    ReferralPrivilege referral = ReferralPrivilege.getInstance(new JSONObject(e.getAttributeValue(SERIALIZABLE_INDEX_KEY)));
                    results.add(referral);
                }
            }
            catch (JSONException e) {
                Object[] arg = new Object[]{baseDN};
                throw new EntitlementException(52, arg, e);
            }
            catch (SMSException e) {
                Object[] arg = new Object[]{baseDN};
                throw new EntitlementException(52, arg, e);
            }
        }
        return results;
    }

    private SSOToken getSSOToken(Subject subject) {
        if (subject == PrivilegeManager.superAdminSubject) {
            return adminToken;
        }
        return SubjectUtils.getSSOToken(subject);
    }

    static {
        Stats stats = Stats.getInstance((String)"Entitlements");
        EntitlementsStats es = new EntitlementsStats(stats);
        stats.addStatsListener((StatsListener)es);
    }
}

