/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.agentconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.configuration.AgentConfiguration;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class AddAgentsToGroup
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String realm = this.getStringOptionValue("realm");
        String agentGroupName = this.getStringOptionValue("agentgroupname");
        List agentNames = rc.getOption("agentnames");
        String[] params = new String[]{realm, agentGroupName, ""};
        String agentName = "";
        try {
            AMIdentity amidGroup = new AMIdentity(adminSSOToken, agentGroupName, IdType.AGENTGROUP, realm, null);
            Iterator i = agentNames.iterator();
            while (i.hasNext()) {
                params[2] = agentName = (String)i.next();
                this.writeLog(0, Level.INFO, "ATTEMPT_ADD_AGENT_TO_GROUP", params);
                AMIdentity amid = new AMIdentity(adminSSOToken, agentName, IdType.AGENTONLY, realm, null);
                AgentConfiguration.AddAgentToGroup(amidGroup, amid);
                this.writeLog(0, Level.INFO, "SUCCEED_ADD_AGENT_TO_GROUP", params);
            }
            if (agentNames.size() > 1) {
                outputWriter.printlnMessage(this.getResourceString("add-agent-to-group-succeeded-pural"));
            } else {
                outputWriter.printlnMessage(this.getResourceString("add-agent-to-group-succeeded"));
            }
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, agentGroupName, agentName, e.getMessage()};
            this.debugError("AddAgentsToGroup.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_ADD_AGENT_TO_GROUP", args);
            throw new CLIException(e, 127);
        }
        catch (ConfigurationException e) {
            String[] args = new String[]{realm, agentGroupName, agentName, e.getMessage()};
            this.debugError("AddAgentsToGroup.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_ADD_AGENT_TO_GROUP", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, agentGroupName, agentName, e.getMessage()};
            this.debugError("AddAgentsToGroup.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_ADD_AGENT_TO_GROUP", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

