/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.idm;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.console.base.AMViewBeanBase;
import com.sun.identity.console.base.AMViewConfig;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.components.view.html.SerializedField;
import com.sun.identity.console.idm.EntityAddViewBean;
import com.sun.identity.console.idm.EntityEditViewBean;
import com.sun.identity.console.idm.model.EntitiesModel;
import com.sun.identity.console.idm.model.EntitiesModelImpl;
import com.sun.identity.console.realm.HasEntitiesTabs;
import com.sun.identity.console.realm.RealmPropertiesBase;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.shared.ldap.LDAPDN;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class EntitiesViewBean
extends RealmPropertiesBase
implements HasEntitiesTabs {
    public static final String DEFAULT_DISPLAY_URL = "/console/idm/Entities.jsp";
    public static final String PG_SESSION_ENTITY_TYPE = "entitytype";
    private static final String TF_FILTER = "tfFilter";
    private static final String BTN_SEARCH = "btnSearch";
    private static final String TBL_SEARCH = "tblSearch";
    private static final String TBL_BUTTON_ADD = "tblButtonAdd";
    private static final String TBL_BUTTON_DELETE = "tblButtonDelete";
    private static final String TBL_COL_NAME = "tblColName";
    private static final String TBL_DATA_NAME = "tblDataName";
    private static final String TBL_DATA_UNIVERSALNAME = "tblDataUniversalName";
    private static final String TBL_DATA_ACTION_HREF = "tblDataActionHref";
    private static final String TBL_COL_ID = "tblColId";
    private static final String TBL_DATA_ID = "tblDataId";
    private static final String PAGETITLE = "pgtitle";
    private static final String DEFAULT_ID_TYPE = "user";
    static final String ATTR_NAME_AGENT_TYPE = "Type=";
    private CCActionTableModel tblModel = null;
    private CCPageTitleModel ptModel;
    private boolean tblModelPopulated = false;
    private static Class wspProfileViewBeanClass;
    private static Class wscProfileViewBeanClass;
    private static boolean supportWSSecurityUI;

    public EntitiesViewBean() {
        super("Entities");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        this.createPageTitleModel();
        this.createTableModel();
        this.registerChildren();
    }

    public void resetView() {
        super.resetView();
        this.tblModelPopulated = false;
        SerializedField szCache = (SerializedField)this.getChild("szCache");
        szCache.setValue(null);
        this.tblModel.clearAll();
        this.setDisplayFieldValue(TF_FILTER, "*");
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(TF_FILTER, CCTextField.class);
        this.registerChild(BTN_SEARCH, CCButton.class);
        this.registerChild(PAGETITLE, CCPageTitle.class);
        this.registerChild(TBL_SEARCH, CCActionTable.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.tblModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        if (name.equals(TBL_SEARCH)) {
            this.populateTableModelEx();
            view = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.tblModel, name);
        } else {
            view = name.equals(PAGETITLE) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (this.tblModel.isChildSupported(name) ? this.tblModel.createChild((View)this, name) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name)));
        }
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event, false);
        this.resetButtonState(TBL_BUTTON_DELETE);
        EntitiesModel model = (EntitiesModel)this.getModel();
        CCButton b = (CCButton)this.getChild(TBL_BUTTON_ADD);
        String curRealm = (String)this.getPageSessionAttribute("currentRealm");
        if (model.repoExists(curRealm)) {
            b.setDisabled(false);
        } else {
            b.setDisabled(true);
        }
        Object[] param = new String[]{this.getDisplayIDType()};
        this.ptModel.setPageTitleText(MessageFormat.format(model.getLocalizedString("page.title.entities"), param));
        this.tblModel.setTitle(MessageFormat.format(model.getLocalizedString("table.entities.title.name"), param));
        this.tblModel.setTitleLabel(MessageFormat.format(model.getLocalizedString("table.entities.title.name"), param));
        this.tblModel.setSummary(MessageFormat.format(model.getLocalizedString("table.entities.summary"), param));
        this.getEntityNames();
        this.addEntitiesTab();
        this.tabModel.setSelectedNode(7);
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(this.getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/oneBtnPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)this.getBackButtonLabel("page.title.back.realms"));
    }

    private void addEntitiesTab() {
        EntitiesModel model = (EntitiesModel)this.getModel();
        String curRealm = (String)this.getPageSessionAttribute("currentRealm");
        AMViewConfig config = AMViewConfig.getInstance();
        config.addEntityTabs(this.tabModel, curRealm, model);
    }

    protected AMModel getModelInternal() {
        RequestContext rc = RequestManager.getRequestContext();
        HttpServletRequest req = rc.getRequest();
        return new EntitiesModelImpl(req, this.getPageSessionAttributes());
    }

    private void createTableModel() {
        this.tblModel = new CCActionTableModel(this.getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblIDMEntities.xml"));
        this.tblModel.setTitleLabel("label.items");
        this.tblModel.setActionValue(TBL_BUTTON_ADD, (Object)"table.entities.button.new");
        this.tblModel.setActionValue(TBL_BUTTON_DELETE, (Object)"table.entities.button.delete");
        this.tblModel.setActionValue(TBL_COL_NAME, (Object)"table.entities.name.column.name");
        this.tblModel.setActionValue(TBL_COL_ID, (Object)"table.entities.name.column.id");
    }

    private void getEntityNames() {
        EntitiesModel model = (EntitiesModel)this.getModel();
        String filter = (String)this.getDisplayFieldValue(TF_FILTER);
        if (filter == null || filter.length() == 0) {
            filter = "*";
            this.setDisplayFieldValue(TF_FILTER, "*");
        } else {
            filter = filter.trim();
        }
        try {
            String curRealm = (String)this.getPageSessionAttribute("currentRealm");
            IdSearchResults results = model.getEntityNames(curRealm, this.getDisplayIDType(), filter);
            int errorCode = results.getErrorCode();
            switch (errorCode) {
                case 1: {
                    this.setInlineAlertMessage("warning", "message.warning", "message.sizelimit.exceeded");
                    break;
                }
                case 2: {
                    this.setInlineAlertMessage("warning", "message.warning", "message.timelimit.exceeded");
                }
            }
            this.populateTableModel(results.getSearchResults());
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
            CCButton b = (CCButton)this.getChild(TBL_BUTTON_ADD);
            b.setDisabled(true);
        }
    }

    private String getDisplayIDType() {
        String idType = (String)this.getPageSessionAttribute(PG_SESSION_ENTITY_TYPE);
        if (idType == null || idType.length() == 0) {
            this.setPageSessionAttribute(PG_SESSION_ENTITY_TYPE, (Serializable)((Object)DEFAULT_ID_TYPE));
            idType = DEFAULT_ID_TYPE;
        }
        return idType;
    }

    private void populateTableModelEx() {
        if (!this.tblModelPopulated) {
            this.tblModelPopulated = true;
            SerializedField szCache = (SerializedField)this.getChild("szCache");
            List cache = (List)szCache.getSerializedObj();
            if (cache != null && !cache.isEmpty()) {
                EntitiesModel model = (EntitiesModel)this.getModel();
                SSOToken ssoToken = model.getUserSSOToken();
                ArrayList<AMIdentity> list = new ArrayList<AMIdentity>(cache.size());
                for (String id : cache) {
                    try {
                        list.add(IdUtils.getIdentity(ssoToken, id));
                    }
                    catch (IdRepoException e) {}
                }
                this.populateTableModel(list);
            }
        }
    }

    private void populateTableModel(Collection entityNames) {
        this.tblModel.clearAll();
        SerializedField szCache = (SerializedField)this.getChild("szCache");
        if (entityNames != null && !entityNames.isEmpty()) {
            EntitiesModel model = (EntitiesModel)this.getModel();
            this.tblModel.setMaxRows(model.getPageSize());
            String curRealm = (String)this.getPageSessionAttribute("currentRealm");
            Set specialUsers = model.getSpecialUsers(curRealm);
            entityNames.removeAll(specialUsers);
            AMIdentity curUser = null;
            try {
                curUser = IdUtils.getIdentity(model.getUserSSOToken(), model.getUniversalID());
            }
            catch (IdRepoException idr) {
                // empty catch block
            }
            int counter = 0;
            boolean firstEntry = true;
            ArrayList<String> cache = new ArrayList<String>(entityNames.size());
            for (AMIdentity entity : entityNames) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    this.tblModel.appendRow();
                }
                String name = AMFormatUtils.getIdentityDisplayName((AMModel)model, entity);
                boolean hide = curUser != null && !curUser.equals(entity);
                this.tblModel.setSelectionVisible(counter++, hide);
                String universalId = IdUtils.getUniversalId(entity);
                this.tblModel.setValue(TBL_DATA_NAME, (Object)name);
                String[] comps = LDAPDN.explodeDN((String)universalId, (boolean)true);
                this.tblModel.setValue(TBL_DATA_ID, (Object)comps[0]);
                this.tblModel.setValue(TBL_DATA_UNIVERSALNAME, (Object)universalId);
                this.tblModel.setValue(TBL_DATA_ACTION_HREF, (Object)EntitiesViewBean.stringToHex(universalId));
                cache.add(universalId);
            }
            szCache.setValue(cache);
        } else {
            szCache.setValue(null);
        }
    }

    public void handleBtnSearchRequest(RequestInvocationEvent event) {
        this.forwardTo();
    }

    public void handleTblButtonAddRequest(RequestInvocationEvent event) {
        EntityAddViewBean vb = (EntityAddViewBean)this.getViewBean(EntityAddViewBean.class);
        this.setPageSessionAttribute("entityTypeName", (Serializable)((Object)((String)this.getPageSessionAttribute(PG_SESSION_ENTITY_TYPE))));
        this.unlockPageTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleTblDataActionHrefRequest(RequestInvocationEvent event) {
        EntitiesModel model = (EntitiesModel)this.getModel();
        String universalId = EntitiesViewBean.hexToString((String)this.getDisplayFieldValue(TBL_DATA_ACTION_HREF));
        this.setPageSessionAttribute("universalId", (Serializable)((Object)universalId));
        try {
            AMIdentity amid = IdUtils.getIdentity(model.getUserSSOToken(), universalId);
            String idType = amid.getType().getName();
            AMViewBeanBase vb = supportWSSecurityUI ? this.getEntityEditViewBean(amid) : (AMViewBeanBase)this.getViewBean(EntityEditViewBean.class);
            this.setPageSessionAttribute("tfEntityName", (Serializable)((Object)amid.getName()));
            this.setPageSessionAttribute("entityTypeName", (Serializable)((Object)idType));
            this.unlockPageTrail();
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
        catch (SSOException e) {
            this.setInlineAlertMessage("error", "message.error", model.getErrorString((Throwable)((Object)e)));
            this.forwardTo();
        }
        catch (IdRepoException e) {
            this.setInlineAlertMessage("error", "message.error", model.getErrorString(e));
            this.forwardTo();
        }
    }

    private AMViewBeanBase getEntityEditViewBean(AMIdentity amid) throws SSOException, IdRepoException {
        Map attrValues = amid.getAttributes();
        Set deviceKeyValue = (Set)attrValues.get("sunIdentityServerDeviceKeyValue");
        String agentType = null;
        if (deviceKeyValue != null && !deviceKeyValue.isEmpty()) {
            Iterator i = deviceKeyValue.iterator();
            while (i.hasNext() && agentType == null) {
                String val = (String)i.next();
                if (!val.startsWith(ATTR_NAME_AGENT_TYPE)) continue;
                agentType = val.substring(ATTR_NAME_AGENT_TYPE.length());
            }
        }
        AMViewBeanBase vb = agentType != null && agentType.equalsIgnoreCase("WSC") ? (AMViewBeanBase)this.getViewBean(wscProfileViewBeanClass) : (agentType != null && agentType.equalsIgnoreCase("WSP") ? (AMViewBeanBase)this.getViewBean(wspProfileViewBeanClass) : (AMViewBeanBase)this.getViewBean(EntityEditViewBean.class));
        return vb;
    }

    public void handleTblButtonDeleteRequest(RequestInvocationEvent event) throws ModelControlException {
        CCActionTable table = (CCActionTable)this.getChild(TBL_SEARCH);
        table.restoreStateData();
        Integer[] selected = this.tblModel.getSelectedRows();
        HashSet<String> names = new HashSet<String>(selected.length * 2);
        SerializedField szCache = (SerializedField)this.getChild("szCache");
        List cache = (List)szCache.getSerializedObj();
        for (int i = 0; i < selected.length; ++i) {
            names.add((String)cache.get(selected[i]));
        }
        try {
            EntitiesModel model = (EntitiesModel)this.getModel();
            String curRealm = (String)this.getPageSessionAttribute("currentRealm");
            String idType = (String)this.getPageSessionAttribute(PG_SESSION_ENTITY_TYPE);
            model.deleteEntities(curRealm, names);
            if (selected.length == 1) {
                Object[] param = new Object[]{model.getLocalizedString(idType)};
                String msg = model.getLocalizedString("entities.message.deleted");
                this.setInlineAlertMessage("info", "message.information", MessageFormat.format(msg, param));
            } else {
                Object[] param = new Object[]{model.getLocalizedString(idType)};
                String msg = model.getLocalizedString("entities.message.deleted.pural");
                this.setInlineAlertMessage("info", "message.information", MessageFormat.format(msg, param));
            }
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        this.forwardTo();
    }

    public void handleButton1Request(RequestInvocationEvent event) {
        this.backTrail();
        this.forwardToRealmView(event);
    }

    static {
        try {
            wspProfileViewBeanClass = Class.forName("com.sun.identity.console.idm.WebServiceProviderEditViewBean");
            wscProfileViewBeanClass = Class.forName("com.sun.identity.console.idm.WebServiceClientEditViewBean");
            supportWSSecurityUI = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

