/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.opensso;

import com.sun.identity.entitlement.Privilege;
import com.sun.identity.entitlement.ReferralPrivilege;
import com.sun.identity.entitlement.opensso.Cache;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PolicyCache {
    private Cache cache;
    static HashMap<String, Integer> countByRealm;
    private ReadWriteLock rwlock = new ReentrantReadWriteLock();

    PolicyCache(int size) {
        this.cache = new Cache(size);
        countByRealm = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cache(String dn, Privilege p, String realm) {
        this.rwlock.writeLock().lock();
        try {
            Object e = this.cache.put(dn, p);
            if (e == null) {
                Integer i = countByRealm.get(realm);
                int count = i == null ? 1 : i + 1;
                countByRealm.put(realm, count);
            }
        }
        finally {
            this.rwlock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cache(String dn, ReferralPrivilege p, String realm) {
        this.rwlock.writeLock().lock();
        try {
            this.cache.put(dn, p);
        }
        finally {
            this.rwlock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cache(Map<String, Privilege> privileges, boolean force) {
        this.rwlock.writeLock().lock();
        try {
            for (String dn : privileges.keySet()) {
                if (force) {
                    this.cache.put(dn, privileges.get(dn));
                    continue;
                }
                Privilege p = privileges.get(dn);
                if (p != null) continue;
                this.cache.put(dn, privileges.get(dn));
            }
        }
        finally {
            this.rwlock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decache(String dn, String realm) {
        this.rwlock.writeLock().lock();
        try {
            Integer i;
            Object p = this.cache.remove(dn);
            if (p != null && (i = countByRealm.get(realm)) != null) {
                countByRealm.put(realm, i - 1);
            }
        }
        finally {
            this.rwlock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Privilege getPolicy(String dn) {
        this.rwlock.readLock().lock();
        try {
            Privilege privilege = (Privilege)this.cache.get(dn);
            return privilege;
        }
        finally {
            this.rwlock.readLock().unlock();
        }
    }

    int getCount(String realm) {
        Integer integer = countByRealm.get(realm);
        if (integer != null) {
            return integer;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferralPrivilege getReferral(String dn) {
        this.rwlock.readLock().lock();
        try {
            ReferralPrivilege referralPrivilege = (ReferralPrivilege)this.cache.get(dn);
            return referralPrivilege;
        }
        finally {
            this.rwlock.readLock().unlock();
        }
    }
}

