/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.https;

import com.iplanet.services.comm.https.JSSThreadPool;
import com.iplanet.services.comm.https.RWGroupJSSProxy;
import com.sun.identity.common.ShutdownListener;
import com.sun.identity.common.ShutdownManager;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.StringTokenizer;
import sun.net.www.protocol.http.HttpURLConnection;

public class JSSProxy
implements Runnable {
    public static HashMap connectHashMap = new HashMap();
    public static int serverPort;
    private static Thread thread;
    private static int threadPoolSize;
    public static JSSThreadPool threadPool;
    private static ServerSocket sconnection;
    private static Debug debug;
    private volatile boolean isShutdownCalled = false;

    private JSSProxy() {
    }

    public void shutdown() {
        try {
            this.isShutdownCalled = true;
            sconnection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        while (true) {
            try {
                while (true) {
                    Socket inconnection = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            return sconnection.accept();
                        }
                    });
                    try {
                        inconnection.setTcpNoDelay(true);
                    }
                    catch (SocketException e) {
                        debug.error("JSSProxy: Unable to  TcpNoDelay.", (Throwable)e);
                        try {
                            inconnection.close();
                        }
                        catch (IOException iOException) {}
                        continue;
                        finally {
                            inconnection = null;
                            continue;
                        }
                    }
                    JSSProxySessionRunnable p = new JSSProxySessionRunnable(inconnection);
                    threadPool.run(p);
                }
            }
            catch (SecurityException ex) {
                debug.error("JSSProxy: SecurityException:", (Throwable)ex);
                continue;
            }
            catch (RuntimeException ex) {
                debug.error("JSSProxy: RuntimeException:", (Throwable)ex);
                continue;
            }
            catch (Exception ex) {
                debug.error("JSSProxy: Exception:", (Throwable)ex);
                if (this.isShutdownCalled && ex.getClass().getName().equals(SocketException.class.getName())) return;
                continue;
            }
            catch (Throwable e) {
                debug.error("JSSProxy: Uncaught exception:", e);
                throw new Error(e);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        sconnection = null;
        debug = Debug.getInstance((String)"amJSS");
        try {
            sconnection = new ServerSocket(0, 50);
            try {
                threadPoolSize = Integer.parseInt(SystemPropertiesManager.get((String)"com.iplanet.am.jssproxy.threadpoolSize"));
            }
            catch (Exception ex) {
                threadPoolSize = 20;
            }
            if (debug.messageEnabled()) {
                debug.message("JSSThreadPool size = " + threadPoolSize);
            }
            threadPool = new JSSThreadPool("amJSS", threadPoolSize, false, debug);
        }
        catch (IOException e) {
            debug.error("JSSProxy: Unable to create server socket", (Throwable)e);
            sconnection = null;
        }
        if (sconnection != null) {
            serverPort = sconnection.getLocalPort();
            try {
                JSSProxy tempInstance = null;
                thread = null;
                ShutdownManager shutdownMan = ShutdownManager.getInstance();
                if (shutdownMan.acquireValidLock()) {
                    try {
                        tempInstance = new JSSProxy();
                        thread = new Thread(tempInstance);
                        final JSSProxy finalInstance = tempInstance;
                        shutdownMan.addShutdownListener(new ShutdownListener(){

                            public void shutdown() {
                                if (finalInstance != null) {
                                    finalInstance.shutdown();
                                }
                                if (threadPool != null) {
                                    threadPool.shutdown();
                                }
                            }
                        });
                    }
                    finally {
                        shutdownMan.releaseLockAndNotify();
                    }
                }
                JSSProxy instance = tempInstance;
                if (thread != null) {
                    thread.start();
                }
            }
            catch (Exception e) {
                debug.error("JSSProxy: Unable to run JSSProxy", (Throwable)e);
                try {
                    sconnection.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private class JSSProxySessionRunnable
    implements Runnable {
        private Socket inconnection = null;
        private Socket toProxySocket = null;

        JSSProxySessionRunnable(Socket socket) {
            this.inconnection = socket;
        }

        public void run() {
            String replyStr;
            StringTokenizer st;
            byte[] prebuffer;
            block19: {
                int port;
                Integer remotePort = new Integer(this.inconnection.getPort());
                prebuffer = new byte[1];
                try {
                    DataInputStream inFrom = new DataInputStream(this.inconnection.getInputStream());
                    inFrom.readFully(prebuffer, 0, 1);
                }
                catch (IOException e) {
                    debug.error("JSSProxySessionRunnable: Unable to open input stream on " + this.inconnection, (Throwable)e);
                    connectHashMap.remove(remotePort);
                    this.closeSockets();
                    return;
                }
                String info = (String)connectHashMap.remove(remotePort);
                st = new StringTokenizer(info);
                String host = st.nextToken();
                try {
                    port = Integer.parseInt(st.nextToken());
                }
                catch (Exception ex) {
                    port = 8080;
                }
                try {
                    this.toProxySocket = new Socket(host, port);
                    this.toProxySocket.setTcpNoDelay(true);
                }
                catch (Exception ex) {
                    this.toProxySocket = null;
                    if (!debug.messageEnabled()) break block19;
                    debug.message("JSSProxySessionRunnable: Unable to connect to " + host + ":" + port + ". ", (Throwable)ex);
                }
            }
            if (this.toProxySocket == null) {
                this.closeSockets();
                return;
            }
            String desthost = st.nextToken();
            String destport = st.nextToken();
            OutputStream out = null;
            InputStream in = null;
            byte[] reply = new byte[200];
            int replyLen = 0;
            int newlinesSeen = 0;
            boolean headerDone = false;
            try {
                byte[] b;
                out = this.toProxySocket.getOutputStream();
                String msg = "CONNECT " + desthost + ":" + destport + " HTTP/1.0\n" + "User-Agent: " + HttpURLConnection.userAgent + "\r\n\r\n";
                debug.message(msg);
                try {
                    b = msg.getBytes("ASCII7");
                }
                catch (UnsupportedEncodingException ignored) {
                    b = msg.getBytes();
                }
                out.write(b);
                out.flush();
                in = this.toProxySocket.getInputStream();
                boolean error = false;
                while (newlinesSeen < 2) {
                    int i = in.read();
                    if (i < 0) {
                        debug.error("JSSProxySessionRunnable: Unexpected EOF from proxy");
                        this.closeSockets();
                        return;
                    }
                    if (i == 10) {
                        headerDone = true;
                        ++newlinesSeen;
                        continue;
                    }
                    if (i == 13) continue;
                    newlinesSeen = 0;
                    if (headerDone || replyLen >= reply.length) continue;
                    reply[replyLen++] = (byte)i;
                }
            }
            catch (IOException ioe) {
                debug.error("JSSProxySessionRunnable: Unable to get OutputStream", (Throwable)ioe);
                this.closeSockets();
                return;
            }
            try {
                replyStr = new String(reply, 0, replyLen, "ASCII7");
            }
            catch (UnsupportedEncodingException ignored) {
                replyStr = new String(reply, 0, replyLen);
            }
            if (!replyStr.startsWith("HTTP/1.0 200")) {
                debug.error("JSSProxySessionRunnable: Unable to tunnel through ");
                this.closeSockets();
                return;
            }
            try {
                out.write(prebuffer);
                out.flush();
            }
            catch (IOException ioe) {
                debug.error("JSSProxySessionRunnable: Unable to write prebuffer.", (Throwable)ioe);
                this.closeSockets();
                return;
            }
            new RWGroupJSSProxy(this.inconnection, this.toProxySocket);
        }

        void closeSockets() {
            if (this.inconnection != null) {
                try {
                    this.inconnection.close();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            if (this.toProxySocket != null) {
                try {
                    this.toProxySocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

