/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.DataLayer;
import com.iplanet.ums.Guid;
import com.iplanet.ums.IDynamicMembership;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.URLEncDec;
import com.sun.identity.shared.ldap.LDAPDN;
import com.sun.identity.shared.ldap.LDAPUrl;
import java.net.MalformedURLException;
import java.security.Principal;

public class DynamicGroup
extends PersistentObject
implements IDynamicMembership {
    private static I18n i18n = I18n.getInstance("amSDK");
    private static Debug debug = Debug.getInstance((String)"amSDK");
    private static final String MEMBER_URL_NAME = "memberurl";
    private static final Class _class = DynamicGroup.class;

    protected DynamicGroup() {
    }

    DynamicGroup(Principal principal, Guid guid) throws UMSException {
        super(principal, guid);
        this.verifyClass();
    }

    DynamicGroup(AttrSet attrSet) throws UMSException {
        this(TemplateManager.getTemplateManager().getCreationTemplate(_class, null), attrSet);
    }

    public DynamicGroup(CreationTemplate template, AttrSet attrSet) throws UMSException {
        super(template, attrSet);
    }

    DynamicGroup(AttrSet attrSet, Guid baseGuid, String filter, int scope) throws UMSException {
        this(TemplateManager.getTemplateManager().getCreationTemplate(_class, null), attrSet, baseGuid, filter, scope);
    }

    public DynamicGroup(CreationTemplate template, AttrSet attrSet, Guid baseGuid, String filter, int scope) throws UMSException {
        super(template, attrSet);
        try {
            this.setUrl(baseGuid, filter, scope);
        }
        catch (Exception e) {
            debug.error("DynamicGroup : Exception : " + e.getMessage());
        }
    }

    public void setSearchFilter(String filter) {
        LDAPUrl url = this.getUrl();
        int scope = url.getScope();
        Guid baseGuid = new Guid(url.getDN());
        try {
            this.setUrl(baseGuid, filter, scope);
        }
        catch (Exception e) {
            debug.error("DynamicGroup.setSearchFilter : Exception : " + e.getMessage());
        }
    }

    public String getSearchFilter() {
        return this.getUrl().getFilter();
    }

    public void setSearchBase(Guid baseGuid) {
        LDAPUrl url = this.getUrl();
        int scope = url.getScope();
        String filter = url.getFilter();
        try {
            this.setUrl(baseGuid, filter, scope);
        }
        catch (Exception e) {
            debug.error("DynamicGroup.setSearchFilter : Exception : " + e.getMessage());
        }
    }

    public Guid getSearchBase() {
        return new Guid(this.getUrl().getDN());
    }

    public void setSearchScope(int scope) {
        LDAPUrl url = this.getUrl();
        Guid baseGuid = new Guid(url.getDN());
        String filter = url.getFilter();
        try {
            this.setUrl(baseGuid, filter, scope);
        }
        catch (Exception e) {
            debug.error("DynamicGroup.setSearchFilter : Exception : " + e.getMessage());
        }
    }

    public int getSearchScope() {
        return this.getUrl().getScope();
    }

    protected String toUrlStr(String base, String filter, int scope) {
        StringBuffer urlBuf = new StringBuffer();
        urlBuf.append("ldap:///" + base + "?");
        switch (scope) {
            case 0: {
                urlBuf.append("?base");
                break;
            }
            case 1: {
                urlBuf.append("?one");
                break;
            }
            default: {
                urlBuf.append("?sub");
            }
        }
        if (filter != null && filter.length() > 0) {
            urlBuf.append("?" + filter);
        } else {
            urlBuf.append("?");
        }
        return urlBuf.toString();
    }

    protected void setUrl(Guid baseGuid, String filter, int scope) {
        if (scope != 1 && scope != 2) {
            String msg = i18n.getString("ums-illegalgroupscope");
            throw new IllegalArgumentException(msg);
        }
        String urlStr = this.toUrlStr(baseGuid.getDn(), filter, scope);
        try {
            new LDAPUrl(urlStr);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.modify(new Attr(MEMBER_URL_NAME, urlStr), 2);
    }

    protected LDAPUrl getUrl() {
        Attr attr = this.getAttribute(MEMBER_URL_NAME);
        LDAPUrl url = null;
        try {
            if (attr != null && attr.getStringValues().length > 0) {
                url = new LDAPUrl(URLEncDec.encodeLDAPUrl((String)attr.getStringValues()[0]));
            }
            if (url == null) {
                url = new LDAPUrl(null, 0, "", (String[])null, 1, "");
            }
        }
        catch (MalformedURLException ex) {
            debug.error("DynamicGroup.setSearchFilter : Exception : " + ex.getMessage());
            throw new IllegalArgumentException(ex.getMessage());
        }
        return url;
    }

    protected void setUrl(LDAPUrl url) {
        String ldapurl;
        block3: {
            ldapurl = url.toString();
            try {
                ldapurl = LDAPUrl.decode((String)ldapurl);
            }
            catch (Exception ex) {
                if (!debug.messageEnabled()) break block3;
                debug.message("DynamicGroup.setUrl : Exception:" + ex.getMessage());
            }
        }
        if (url.getScope() != 1 && url.getScope() != 2) {
            String msg = i18n.getString("ums-illegalgroupscope");
            throw new IllegalArgumentException(msg);
        }
        this.modify(new Attr(MEMBER_URL_NAME, ldapurl), 2);
    }

    protected SearchResults getMemberIDs(String[] attributes) throws UMSException {
        return DataLayer.getInstance().search(this.getPrincipal(), this.getSearchBase(), this.getSearchScope(), this.getSearchFilter(), attributes, false, null);
    }

    public SearchResults getMemberIDs() throws UMSException {
        String[] attributesToGet = new String[]{"objectclass"};
        return this.getMemberIDs(attributesToGet);
    }

    public int getMemberCount() throws UMSException {
        int count = 0;
        String[] attributesToGet = new String[]{"dn"};
        SearchResults searchResults = this.getMemberIDs(attributesToGet);
        while (searchResults.hasMoreElements()) {
            searchResults.next().getDN();
            ++count;
        }
        return count;
    }

    public Guid getMemberIDAt(int index) throws UMSException {
        if (index < 0) {
            throw new IllegalArgumentException(Integer.toString(index));
        }
        String filter = this.getSearchFilter();
        if (filter == null) {
            return null;
        }
        String[] attributesToGet = new String[]{"dn"};
        SearchResults searchResults = this.getMemberIDs(attributesToGet);
        while (searchResults.hasMoreElements()) {
            String s = searchResults.next().getDN();
            if (index == 0) {
                searchResults.abandon();
                return new Guid(s);
            }
            --index;
        }
        throw new ArrayIndexOutOfBoundsException(Integer.toString(index));
    }

    public boolean hasMember(Guid guid) throws UMSException {
        String filter = this.getSearchFilter();
        if (filter == null) {
            return false;
        }
        String dn = guid.getDn();
        String rdn = LDAPDN.explodeDN((String)dn, (boolean)false)[0];
        filter = "(&" + filter + "(" + rdn + "))";
        String[] attributesToGet = new String[]{"dn"};
        SearchResults searchResults = DataLayer.getInstance().search(this.getPrincipal(), this.getSearchBase(), this.getSearchScope(), filter, attributesToGet, false, null);
        while (searchResults.hasMoreElements()) {
            String s = searchResults.next().getDN();
            if (!Guid.equals(s, dn)) continue;
            searchResults.abandon();
            return true;
        }
        return false;
    }
}

