/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.tomcat;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.core.StandardContext;
import org.gatein.wci.RequestDispatchCallback;
import org.gatein.wci.ServletContainer;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.ServletContainerVisitor;
import org.gatein.wci.authentication.AuthenticationException;
import org.gatein.wci.command.CommandDispatcher;
import org.gatein.wci.command.TomcatCommandDispatcher;
import org.gatein.wci.security.Credentials;
import org.gatein.wci.session.SessionTask;
import org.gatein.wci.session.SessionTaskVisitor;
import org.gatein.wci.spi.ServletContainerContext;
import org.gatein.wci.spi.WebAppContext;
import org.gatein.wci.tomcat.TomcatWebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatServletContainerContext
implements ServletContainerContext,
ContainerListener,
LifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(TomcatServletContainerContext.class);
    private static TomcatServletContainerContext instance;
    private final CommandDispatcher dispatcher = new TomcatCommandDispatcher("/tomcatgateinservlet");
    private final Set<String> monitoredHosts = new HashSet<String>();
    private final Set<String> monitoredContexts = new HashSet<String>();
    private static Map<String, String> manualMonitoredContexts;
    private final Engine engine;
    private ServletContainerContext.Registration registration;
    private boolean crossContextLogout = true;

    public static TomcatServletContainerContext getInstanceIfPresent() {
        return instance;
    }

    public TomcatServletContainerContext(Engine engine) {
        this.engine = engine;
    }

    public Object include(ServletContext targetServletContext, HttpServletRequest request, HttpServletResponse response, RequestDispatchCallback callback, Object handback) throws ServletException, IOException {
        if (manualMonitoredContexts.containsKey(targetServletContext.getServletContextName())) {
            String dispatherPath = manualMonitoredContexts.get(targetServletContext.getServletContextName());
            TomcatCommandDispatcher dispatcher = new TomcatCommandDispatcher(dispatherPath);
            return dispatcher.include(targetServletContext, request, response, callback, handback);
        }
        return this.dispatcher.include(targetServletContext, request, response, callback, handback);
    }

    public void setCallback(ServletContainerContext.Registration registration) {
        this.registration = registration;
    }

    public void unsetCallback(ServletContainerContext.Registration registration) {
        this.registration = null;
    }

    public void setCrossContextLogout(boolean val) {
        this.crossContextLogout = val;
    }

    public void login(HttpServletRequest request, HttpServletResponse response, Credentials credentials) throws ServletException, IOException {
        request.getSession();
        try {
            request.login(credentials.getUsername(), credentials.getPassword());
        }
        catch (ServletException se) {
            throw new AuthenticationException((Throwable)se);
        }
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        HttpSession sess = request.getSession(false);
        if (sess == null) {
            return;
        }
        if (!this.crossContextLogout) {
            return;
        }
        String sessId = sess.getId();
        ServletContainerFactory.getServletContainer().visit((ServletContainerVisitor)new SessionTaskVisitor(sessId, new SessionTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean executeTask(HttpSession session) {
                ClassLoader portalContainerCL = Thread.currentThread().getContextClassLoader();
                ClassLoader webAppCL = session.getServletContext().getClassLoader();
                Thread.currentThread().setContextClassLoader(webAppCL);
                try {
                    session.invalidate();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(portalContainerCL);
                }
                return true;
            }
        }));
        request.logout();
    }

    public String getContainerInfo() {
        return "Tomcat/7.x";
    }

    public synchronized void containerEvent(ContainerEvent event) {
        if (event.getData() instanceof Host) {
            Host host = (Host)event.getData();
            if ("addChild".equals(event.getType())) {
                this.registerHost(host);
            } else if ("removeChild".equals(event.getType())) {
                this.unregisterHost(host);
            }
        } else if (event.getData() instanceof StandardContext) {
            StandardContext context = (StandardContext)event.getData();
            if ("addChild".equals(event.getType())) {
                this.registerContext(context);
            } else if ("removeChild".equals(event.getType())) {
                this.unregisterContext(context);
            }
        }
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getSource() instanceof Context) {
            Context context = (Context)event.getSource();
            if ("after_start".equals(event.getType())) {
                this.start(context);
            } else if ("before_stop".equals(event.getType())) {
                this.stop(context);
            }
        }
    }

    public Engine getEngine() {
        return this.engine;
    }

    void start() {
        Container[] childrenContainers;
        ServletContainerFactory.registerContext((ServletContainerContext)this);
        instance = this;
        for (Container childContainer : childrenContainers = this.engine.findChildren()) {
            if (!(childContainer instanceof Host)) continue;
            Host host = (Host)childContainer;
            this.registerHost(host);
        }
        this.engine.addContainerListener((ContainerListener)this);
    }

    void stop() {
        Container[] childrenContainers;
        instance = null;
        this.engine.removeContainerListener((ContainerListener)this);
        for (Container childContainer : childrenContainers = this.engine.findChildren()) {
            if (!(childContainer instanceof Host)) continue;
            Host host = (Host)childContainer;
            this.unregisterHost(host);
        }
        if (this.registration != null) {
            this.registration.cancel();
            this.registration = null;
        }
    }

    private void registerHost(Host host) {
        if (!this.monitoredHosts.contains(host.getName())) {
            Container[] childrenContainers;
            this.monitoredHosts.add(host.getName());
            host.addContainerListener((ContainerListener)this);
            for (Container childContainer : childrenContainers = host.findChildren()) {
                if (!(childContainer instanceof StandardContext)) continue;
                StandardContext context = (StandardContext)childContainer;
                this.registerContext(context);
            }
        }
    }

    private void unregisterHost(Host host) {
        if (this.monitoredHosts.contains(host.getName())) {
            Container[] childrenContainers;
            this.monitoredHosts.remove(host.getName());
            host.removeContainerListener((ContainerListener)this);
            for (Container childContainer : childrenContainers = host.findChildren()) {
                if (!(childContainer instanceof StandardContext)) continue;
                StandardContext context = (StandardContext)childContainer;
                this.unregisterContext(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerContext(StandardContext context) {
        if (this.monitoredContexts.contains(context.getName())) {
            return;
        }
        Set<String> set = this.monitoredContexts;
        synchronized (set) {
            if (!this.monitoredContexts.contains(context.getName())) {
                this.monitoredContexts.add(context.getName());
                context.addLifecycleListener((LifecycleListener)this);
                if (LifecycleState.STARTED.equals((Object)context.getState())) {
                    this.start((Context)context);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterContext(StandardContext context) {
        if (!this.monitoredContexts.contains(context.getName())) {
            return;
        }
        Set<String> set = this.monitoredContexts;
        synchronized (set) {
            if (this.monitoredContexts.contains(context.getName())) {
                this.monitoredContexts.remove(context.getName());
                if (LifecycleState.STARTED.equals((Object)context.getState())) {
                    this.stop((Context)context);
                }
                context.removeLifecycleListener((LifecycleListener)this);
            }
        }
    }

    private void start(Context context) {
        try {
            if (!ServletContainer.isDisabledNativeRegistration((ServletContext)context.getServletContext())) {
                log.debug("Context added " + context.getPath());
                TomcatWebAppContext webAppContext = new TomcatWebAppContext(context);
                if (this.registration != null) {
                    this.registration.registerWebApp((WebAppContext)webAppContext);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void stop(Context context) {
        try {
            if (!ServletContainer.isDisabledNativeRegistration((ServletContext)context.getServletContext()) && this.registration != null) {
                this.registration.unregisterWebApp(context.getPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        manualMonitoredContexts = new HashMap<String, String>();
    }
}

