/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.wildfly;

import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.spec.ServletContextImpl;
import java.io.IOException;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.RequestDispatchCallback;
import org.gatein.wci.ServletContainer;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.ServletContainerVisitor;
import org.gatein.wci.authentication.AuthenticationException;
import org.gatein.wci.command.CommandDispatcher;
import org.gatein.wci.command.WildflyCommandDispatcher;
import org.gatein.wci.security.Credentials;
import org.gatein.wci.session.SessionTask;
import org.gatein.wci.session.SessionTaskVisitor;
import org.gatein.wci.spi.ServletContainerContext;
import org.gatein.wci.spi.WebAppContext;
import org.gatein.wci.wildfly.Wildfly11WebAppContext;

public class Wildfly11ServletContainerContext
implements ServletContainerContext,
ServletContainerInitializer,
ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(Wildfly11ServletContainerContext.class);
    private final CommandDispatcher dispatcher = new WildflyCommandDispatcher("/wildfly11gateinservlet");
    protected boolean crossContextLogout = true;
    protected ServletContainerContext.Registration registration;
    protected io.undertow.servlet.api.ServletContainer servletContainer;
    protected Set<String> monitoredDeployments = new HashSet<String>();
    protected static Wildfly11ServletContainerContext instance;

    public Wildfly11ServletContainerContext() {
    }

    public Wildfly11ServletContainerContext(io.undertow.servlet.api.ServletContainer servletContainer) {
        this.servletContainer = servletContainer;
        instance = this;
    }

    public Object include(ServletContext targetServletContext, HttpServletRequest request, HttpServletResponse response, RequestDispatchCallback callback, Object handback) throws ServletException, IOException {
        return this.dispatcher.include(targetServletContext, request, response, callback, handback);
    }

    public void setCallback(ServletContainerContext.Registration registration) {
        this.registration = registration;
    }

    public void unsetCallback(ServletContainerContext.Registration registration) {
        this.registration = null;
    }

    public void login(HttpServletRequest request, HttpServletResponse response, Credentials credentials) throws AuthenticationException, ServletException, IOException {
        request.getSession();
        try {
            request.login(credentials.getUsername(), credentials.getPassword());
        }
        catch (ServletException se) {
            throw new AuthenticationException((Throwable)se);
        }
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        HttpSession sess = request.getSession(false);
        if (sess == null) {
            return;
        }
        request.logout();
        if (!this.crossContextLogout) {
            return;
        }
        ServletContainerFactory.getServletContainer().visit((ServletContainerVisitor)new SessionTaskVisitor(sess.getId(), new SessionTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean executeTask(HttpSession session) {
                ClassLoader portalContainerCL = Thread.currentThread().getContextClassLoader();
                ClassLoader webAppCL = session.getServletContext().getClassLoader();
                Thread.currentThread().setContextClassLoader(webAppCL);
                try {
                    session.invalidate();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(portalContainerCL);
                }
                return true;
            }
        }));
    }

    public String getContainerInfo() {
        return "Wildfly/10";
    }

    public void setCrossContextLogout(boolean val) {
        this.crossContextLogout = val;
    }

    public void start() {
        ServletContainerFactory.registerContext((ServletContainerContext)this);
        if (Wildfly11ServletContainerContext.instance.servletContainer == null) {
            log.warn((Object)"Can't deploy Portlets and Extensions from external EARs because the servlet container wasn't found");
        }
        Collection listDeployments = Wildfly11ServletContainerContext.instance.servletContainer.listDeployments();
        for (String deploymentName : listDeployments) {
            try {
                DeploymentManager deployment = Wildfly11ServletContainerContext.instance.servletContainer.getDeployment(deploymentName);
                ServletContextImpl servletContext = deployment.getDeployment().getServletContext();
                this.contextInitialized(new ServletContextEvent((ServletContext)servletContext));
            }
            catch (Exception e) {
                log.error((Object)("Can't integrate deployment '" + deploymentName + "' to eXo Platform. It will not be considered as eXo extension or portlet"), (Throwable)e);
            }
        }
    }

    public void stop() {
        if (this.servletContainer != null) {
            log.debug((Object)"Destroying WCI Servlet container context");
            instance = null;
            Collection listDeployments = this.servletContainer.listDeployments();
            for (String deploymentName : listDeployments) {
                if (!this.monitoredDeployments.remove(deploymentName) || instance == null || Wildfly11ServletContainerContext.instance.registration == null) continue;
                Wildfly11ServletContainerContext.instance.registration.unregisterWebApp(deploymentName);
                DeploymentManager deploymentManager = this.servletContainer.getDeployment(deploymentName);
                deploymentManager.undeploy();
            }
            this.registration.cancel();
            this.registration = null;
            this.servletContainer = null;
        }
    }

    public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
        ServletContextImpl servletContextImpl;
        Deployment deployment;
        String deploymentName;
        if (instance != null && Wildfly11ServletContainerContext.instance.registration != null && !this.monitoredDeployments.contains(deploymentName = (deployment = (servletContextImpl = (ServletContextImpl)ctx).getDeployment()).getDeploymentInfo().getDeploymentName())) {
            deployment.getServletContext().addListener((EventListener)((Object)this));
            if (!ServletContainer.isDisabledNativeRegistration((ServletContext)servletContextImpl)) {
                this.monitoredDeployments.add(deploymentName);
                log.info((Object)("Integrate webapp '" + deploymentName + "' to eXo Platform context on context startup"));
                Wildfly11ServletContainerContext.instance.registration.registerWebApp((WebAppContext)new Wildfly11WebAppContext(deployment));
            }
        }
    }

    public void contextInitialized(ServletContextEvent sce) {
        Deployment deployment;
        String deploymentName;
        ServletContextImpl servletContextImpl;
        if (instance != null && Wildfly11ServletContainerContext.instance.registration != null && !ServletContainer.isDisabledNativeRegistration((ServletContext)(servletContextImpl = (ServletContextImpl)sce.getServletContext())) && !this.monitoredDeployments.contains(deploymentName = (deployment = servletContextImpl.getDeployment()).getDeploymentInfo().getDeploymentName())) {
            try {
                log.info((Object)("Integrate webapp '" + deploymentName + "' to eXo Platform context"));
                this.monitoredDeployments.add(deploymentName);
                Wildfly11ServletContainerContext.instance.registration.registerWebApp((WebAppContext)new Wildfly11WebAppContext(deployment));
            }
            catch (Exception e) {
                log.warn((Object)("Cannot register Webapp " + deploymentName + " to eXo Platfom context"), (Throwable)e);
            }
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ServletContextImpl servletContextImpl = (ServletContextImpl)sce.getServletContext();
        String contextPath = servletContextImpl.getContextPath();
        Deployment deployment = servletContextImpl.getDeployment();
        String deploymentName = deployment.getDeploymentInfo().getDeploymentName();
        if (this.monitoredDeployments.remove(deploymentName) && instance != null && Wildfly11ServletContainerContext.instance.registration != null) {
            Wildfly11ServletContainerContext.instance.registration.unregisterWebApp(contextPath);
        }
    }
}

