/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.injection.core.module;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.injection.helper.InjectorUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SpaceModule {
    private final Log LOG = ExoLogger.getLogger(SpaceModule.class);
    private static Boolean requestStarted = false;
    protected SpaceService spaceService;
    protected IdentityManager identityManager;
    protected OrganizationService organizationService;

    public SpaceModule(SpaceService spaceService, IdentityManager identityManager, OrganizationService organizationService) {
        this.spaceService = spaceService;
        this.identityManager = identityManager;
        this.organizationService = organizationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSpaces(JSONArray spaces, String defaultDataFolderPath) {
        for (int i = 0; i < spaces.length(); ++i) {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                JSONObject space = spaces.getJSONObject(i);
                boolean created = this.createSpace(space.getString("displayName"), space.getString("creator"));
                if (!created) continue;
                if (space.has("members")) {
                    JSONArray members = space.getJSONArray("members");
                    for (int j = 0; j < members.length(); ++j) {
                        Space spacet = this.spaceService.getSpaceByDisplayName(space.getString("displayName"));
                        if (spacet == null) continue;
                        this.spaceService.addMember(spacet, members.getString(j));
                    }
                }
                this.createSpaceAvatar(space.getString("displayName"), space.getString("creator"), space.getString("avatar"), defaultDataFolderPath);
                continue;
            }
            catch (JSONException e) {
                this.LOG.error((Object)("Syntax error on space n\u00b0" + i), (Throwable)e);
                continue;
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    private void createSpaceAvatar(String name, String editor, String avatarFile, String defaultDataFolderPath) {
        Space space = null;
        try {
            space = this.spaceService.getSpaceByDisplayName(name);
            if (space != null) {
                try {
                    AvatarAttachment avatarAttachment = InjectorUtils.getAvatarAttachment(avatarFile, defaultDataFolderPath);
                    space.setAvatarAttachment(avatarAttachment);
                    this.spaceService.updateSpace(space);
                    space.setEditor(editor);
                    this.spaceService.updateSpaceAvatar(space);
                }
                catch (Exception e) {
                    this.LOG.error((Object)("Unable to set avatar for space " + space.getDisplayName()), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)("Unable to create space " + space.getDisplayName()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createSpace(String name, String creator) {
        boolean spaceCreated;
        block6: {
            Space target = null;
            spaceCreated = true;
            target = this.spaceService.getSpaceByDisplayName(name);
            if (target == null) break block6;
            boolean bl = false;
            return bl;
        }
        try {
            String groupId = "/spaces/" + SpaceUtils.cleanString((String)name);
            this.forceDeleteGroupOfSpaceIfExists(groupId);
            Space space = new Space();
            space.setDisplayName(name);
            space.setPrettyName(name);
            space.setDescription("");
            space.setGroupId("/spaces/" + space.getPrettyName());
            space.setGroupId(groupId);
            space.setRegistration("open");
            space.setVisibility("private");
            space.setPriority("2");
            Identity identity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), true);
            if (identity != null) {
                space.setPrettyName(SpaceUtils.buildPrettyName((Space)space));
            }
            space.setType("classic");
            this.spaceService.createSpace(space, creator);
        }
        catch (Exception E) {
            this.LOG.error((Object)("========= ERROR when create space " + name), (Throwable)E);
            boolean bl = false;
            return bl;
        }
        return spaceCreated;
    }

    public void purgeSpaces(JSONArray spaces) {
        for (int i = 0; i < spaces.length(); ++i) {
            try {
                JSONObject space = spaces.getJSONObject(i);
                this.purgeSpace(space.getString("displayName"));
                continue;
            }
            catch (JSONException e) {
                this.LOG.error((Object)("Syntax error on space n\u00b0" + i), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeSpace(String displayName) {
        Space target = null;
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            target = this.spaceService.getSpaceByDisplayName(displayName);
            if (target != null) {
                this.spaceService.deleteSpace(target);
            }
        }
        catch (Exception E) {
            this.LOG.error((Object)("Space " + target.getPrettyName() + " can't be deleted "), (Throwable)E);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private void forceDeleteGroupOfSpaceIfExists(String groupId) throws Exception {
        Group spaceGroup = this.organizationService.getGroupHandler().findGroupById(groupId);
        if (spaceGroup != null) {
            this.LOG.warn("Space group {} already exists, it will be removed before injecting space", new Object[]{groupId});
            this.organizationService.getGroupHandler().removeGroup(spaceGroup, true);
        }
    }
}

