/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.injection.core.module;

import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.injection.helper.InjectorUtils;
import org.exoplatform.injection.services.AbstractModule;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.webui.exception.MessageException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UserModule
extends AbstractModule {
    private final Log LOG = ExoLogger.getLogger(UserModule.class);
    protected IdentityManager identityManager;
    protected OrganizationService organizationService;
    protected RelationshipManager relationshipManager;
    private static final String PLATFORM_USERS_GROUP = "/platform/administrators";
    private static Boolean requestStarted = false;
    private static final String MEMBERSHIP_TYPE_MANAGER = "*";
    private static final int WIDTH = 200;

    public UserModule(OrganizationService organizationService, IdentityManager identityManager, RelationshipManager relationshipManager) {
        this.organizationService = organizationService;
        this.identityManager = identityManager;
        this.relationshipManager = relationshipManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createUsers(JSONArray users, String defaultFolderPath) {
        for (int i = 0; i < users.length(); ++i) {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                JSONObject user = users.getJSONObject(i);
                boolean created = this.createUser(user.getString("username"), user.getString("position"), user.getString("firstname"), user.getString("lastname"), user.getString("email"), user.getString("password"), user.getString("isadmin"));
                if (!created) continue;
                this.saveUserAvatar(user.getString("username"), user.getString("avatar"), defaultFolderPath);
                continue;
            }
            catch (JSONException e) {
                this.LOG.error((Object)("Syntax error on user n\u00b0" + i), (Throwable)e);
                continue;
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    private boolean createUser(String username, String position, String firstname, String lastname, String email, String password, String isAdmin) {
        Identity identity;
        Boolean ok = true;
        User user = null;
        try {
            user = this.organizationService.getUserHandler().findUserByName(username);
        }
        catch (Exception e) {
            this.LOG.info((Object)e.getMessage());
        }
        if (user != null) {
            return false;
        }
        user = this.organizationService.getUserHandler().createUserInstance(username);
        user.setDisplayName(firstname + " " + lastname);
        user.setEmail(email);
        user.setFirstName(firstname);
        user.setLastName(lastname);
        user.setLastName(password);
        if (PropertyManager.getProperty((String)"exo.data.injection.password.random.enable") != null && PropertyManager.getProperty((String)"exo.data.injection.password.random.enable").equalsIgnoreCase("true")) {
            user.setPassword(RandomStringUtils.random((int)32, (int)0, (int)8, (boolean)true, (boolean)true, (char[])"eXoTribe".toCharArray()));
        }
        try {
            this.organizationService.getUserHandler().createUser(user, true);
        }
        catch (Exception e) {
            this.LOG.info((Object)e.getMessage());
            ok = false;
        }
        if (isAdmin != null && isAdmin.equals("true")) {
            try {
                Group group = this.organizationService.getGroupHandler().findGroupById(PLATFORM_USERS_GROUP);
                MembershipType membershipType = this.organizationService.getMembershipTypeHandler().findMembershipType(MEMBERSHIP_TYPE_MANAGER);
                this.organizationService.getMembershipHandler().linkMembership(user, group, membershipType, true);
            }
            catch (Exception e) {
                this.LOG.warn((Object)"Can not assign *:/platform/administrators membership to the created user");
                ok = false;
            }
        }
        if (!"".equals(position) && (identity = this.identityManager.getOrCreateIdentity("organization", username, true)) != null) {
            Profile profile = identity.getProfile();
            profile.setProperty("position", (Object)position);
            profile.setListUpdateTypes(Arrays.asList(Profile.UpdateType.CONTACT));
            try {
                this.identityManager.updateProfile(profile);
            }
            catch (MessageException e) {
                this.LOG.error("Error ro update user profile", new Object[]{e, e.getMessage()});
            }
        }
        return ok;
    }

    private void saveUserAvatar(String username, String fileName, String defaultFolder) {
        try {
            AvatarAttachment avatarAttachment = InjectorUtils.getAvatarAttachment(fileName, defaultFolder);
            Profile p = this.identityManager.getOrCreateIdentity("organization", username, true).getProfile();
            p.setProperty("avatar", (Object)avatarAttachment);
            p.setListUpdateTypes(Arrays.asList(Profile.UpdateType.AVATAR));
            Map props = p.getProperties();
            for (String key : props.keySet()) {
                if (!key.startsWith("avatar_")) continue;
                p.removeProperty(key);
            }
            this.identityManager.updateProfile(p);
        }
        catch (Exception e) {
            this.LOG.info((Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRelations(JSONArray relations) {
        for (int i = 0; i < relations.length(); ++i) {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                JSONObject relation = relations.getJSONObject(i);
                Identity idInviting = this.identityManager.getOrCreateIdentity("organization", relation.getString("inviting"), false);
                Identity idInvited = this.identityManager.getOrCreateIdentity("organization", relation.getString("invited"), false);
                this.relationshipManager.inviteToConnect(idInviting, idInvited);
                if (!relation.has("confirmed") || !relation.getBoolean("confirmed")) continue;
                this.relationshipManager.confirm(idInvited, idInviting);
                continue;
            }
            catch (JSONException e) {
                this.LOG.error((Object)("Syntax error on relation n\u00b0" + i), (Throwable)e);
                continue;
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    public void purgeUsers(JSONArray users) {
        for (int i = 0; i < users.length(); ++i) {
            try {
                JSONObject user = users.getJSONObject(i);
                this.purgeUser(user.getString("username"));
                continue;
            }
            catch (JSONException e) {
                this.LOG.error((Object)("Syntax error on user n\u00b0" + i), (Throwable)e);
            }
        }
    }

    private void purgeUser(String username) {
        User user = null;
        try {
            user = this.organizationService.getUserHandler().findUserByName(username);
        }
        catch (Exception e) {
            this.LOG.info("User {} doesn't exist in eXo store", new Object[]{username});
        }
        if (user != null) {
            try {
                this.organizationService.getUserHandler().removeUser(username, true);
            }
            catch (Exception e) {
                this.LOG.warn("Enable to drop User {} from eXo store", new Object[]{username});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeRelations(JSONArray relations) {
        for (int i = 0; i < relations.length(); ++i) {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                JSONObject relation = relations.getJSONObject(i);
                Identity idInviting = this.identityManager.getOrCreateIdentity("organization", relation.getString("inviting"), false);
                Identity idInvited = this.identityManager.getOrCreateIdentity("organization", relation.getString("invited"), false);
                Relationship oldRelationShip = this.relationshipManager.get(idInviting, idInvited);
                if (oldRelationShip == null) continue;
                this.relationshipManager.delete(oldRelationShip);
                continue;
            }
            catch (JSONException e) {
                this.LOG.error((Object)("Syntax error on relation n\u00b0" + i), (Throwable)e);
                continue;
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }
}

