/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.addons.rdbms.listener;

import javax.jcr.Node;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.impl.JCRDataStorage;
import org.exoplatform.commons.utils.ActivityTypeUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.cs.ext.impl.CalendarSpaceActivityPublisher;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;

public class CalendarActivityUpdaterListener
extends Listener<ExoSocialActivity, String> {
    private static final Log LOG = ExoLogger.getLogger(CalendarActivityUpdaterListener.class);
    private JCRDataStorage storage_;

    public CalendarActivityUpdaterListener(CalendarService calendarService) {
    }

    private JCRDataStorage getJCRDataStorage() throws Exception {
        if (this.storage_ == null) {
            this.storage_ = new JCRDataStorage((NodeHierarchyCreator)CommonsUtils.getService(NodeHierarchyCreator.class), (RepositoryService)CommonsUtils.getService(RepositoryService.class), (CacheService)CommonsUtils.getService(CacheService.class));
        }
        return this.storage_;
    }

    public void onEvent(Event<ExoSocialActivity, String> event) throws Exception {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        if ("cs-calendar:spaces".equals(activity.getType())) {
            String eventId = (String)activity.getTemplateParams().get(CalendarSpaceActivityPublisher.EVENT_ID_KEY);
            String calendarId = (String)activity.getTemplateParams().get(CalendarSpaceActivityPublisher.CALENDAR_ID_KEY);
            Node calendarNode = this.getJCRDataStorage().getPublicCalendarHome().getNode(calendarId);
            Node eventNode = calendarNode.getNode(eventId);
            ActivityTypeUtils.attachActivityId((Node)eventNode, (String)((String)event.getData()));
            eventNode.getSession().save();
            LOG.info((Object)String.format("Done migration the calendar activity with old id's %s and new id's %s", activity.getId(), event.getData()));
        }
    }
}

