/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity.listener;

import java.util.Map;
import javax.jcr.Node;
import org.exoplatform.commons.utils.ActivityTypeUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;

public class CommentUpdatedActivityListener
extends Listener<Node, Node> {
    public void onEvent(Event<Node, Node> event) throws Exception {
        Node commentNode = (Node)event.getData();
        String commentContent = "";
        if (commentNode.hasProperty("exo:commentContent")) {
            try {
                commentContent = commentNode.getProperty("exo:commentContent").getValue().getString();
            }
            catch (Exception e) {
                commentContent = null;
            }
        }
        if (commentContent == null) {
            return;
        }
        String activityID = ActivityTypeUtils.getActivityId((Node)commentNode);
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        ActivityManager activityManager = (ActivityManager)container.getComponentInstanceOfType(ActivityManager.class);
        ExoSocialActivity commentActivity = null;
        try {
            commentActivity = activityManager.getActivity(activityID);
        }
        catch (Exception e) {
            return;
        }
        Map paramsMap = commentActivity.getTemplateParams();
        paramsMap.put("systemComment", commentContent);
        commentActivity.setTemplateParams(paramsMap);
        activityManager.updateActivity(commentActivity);
    }
}

