/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.BaseUIActivityBuilder;
import org.exoplatform.wcm.ext.component.activity.FileUIActivity;

public class FileUIActivityBuilder
extends BaseUIActivityBuilder {
    private static final Log LOG = ExoLogger.getLogger(FileUIActivityBuilder.class);

    protected void extendUIActivity(BaseUIActivity uiActivity, ExoSocialActivity activity) {
        FileUIActivity fileActivity = (FileUIActivity)uiActivity;
        if (activity.getTemplateParams() != null) {
            fileActivity.setUIActivityData(activity.getTemplateParams());
        }
        RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
        ManageableRepository manageRepo = null;
        Node contentNode = null;
        try {
            manageRepo = repositoryService.getCurrentRepository();
            SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
            for (String ws : manageRepo.getWorkspaceNames()) {
                try {
                    if (StringUtils.isEmpty((String)fileActivity.getNodeUUID())) {
                        String contentLink = fileActivity.getContentLink();
                        String _ws = contentLink.split("/")[0];
                        String _repo = contentLink.split("/")[1];
                        String nodePath = contentLink.replace(_ws + "/" + _repo, "");
                        contentNode = (Node)sessionProvider.getSession(ws, manageRepo).getItem(nodePath);
                        fileActivity.setContentNode(contentNode);
                        return;
                    }
                    contentNode = sessionProvider.getSession(ws, manageRepo).getNodeByUUID(fileActivity.getNodeUUID());
                    fileActivity.docPath = contentNode.getPath();
                    fileActivity.workspace = ws;
                    fileActivity.repository = manageRepo.toString();
                    break;
                }
                catch (RepositoryException e) {
                }
            }
        }
        catch (RepositoryException re) {
            LOG.error((Object)"Can not get the repository. ", (Throwable)re);
        }
        fileActivity.setContentNode(contentNode);
    }
}

