/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.utils.permission.PermissionUtil;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIShareDocumentSpaceMention;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wcm.ext.component.document.service.IShareDocumentService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.commons.EventUIComponent;
import org.exoplatform.webui.commons.UISpacesSwitcher;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormTextAreaInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/ecm/social-integration/share-document/UIShareDocuments.gtmpl", events={@EventConfig(listeners={ShareActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={TextChangeActionListener.class}), @EventConfig(listeners={RemoveSpaceActionListener.class}), @EventConfig(listeners={SelectSpaceActionListener.class}, phase=Event.Phase.PROCESS)})
public class UIShareDocuments
extends UIForm
implements UIPopupComponent {
    private static final Log LOG = ExoLogger.getLogger(UIShareDocuments.class);
    private static final String SHARECONTENT_BUNDLE_LOCATION = "locale.extension.SocialIntegration";
    private static final String SHARE_OPTION_CANVEW = "UIShareDocuments.label.option.read";
    private static final String SHARE_OPTION_CANMODIFY = "UIShareDocuments.label.option.modify";
    private static final String SHARE_PERMISSION_VIEW = "read";
    private static final String SHARE_PERMISSION_MODIFY = "modify";
    private boolean permissionDropDown = false;
    private String nodePath;
    List<String> spaces = new ArrayList<String>();
    public String comment = "";
    private NodeLocation node;

    public boolean hasPermissionDropDown() {
        return this.permissionDropDown;
    }

    public void setPermissionDropDown(boolean permissionDropDown) {
        this.permissionDropDown = permissionDropDown;
    }

    public void init() {
        block4: {
            try {
                this.addChild(this.createUIComponent(UIShareDocumentSpaceMention.class, null, null));
                EventUIComponent temp = new EventUIComponent("UIShareDocuments", "SelectSpace", EventUIComponent.EVENTTYPE.EVENT);
                this.getSpace().init(temp);
                this.addChild((UIComponent)new UIFormTextAreaInput("textAreaInput", "textAreaInput", ""));
                ResourceBundleService resourceBundleService = (ResourceBundleService)WCMCoreUtils.getService(ResourceBundleService.class);
                ResourceBundle resourceBundle = resourceBundleService.getResourceBundle(SHARECONTENT_BUNDLE_LOCATION, Util.getPortalRequestContext().getLocale());
                String canView = resourceBundle.getString(SHARE_OPTION_CANVEW);
                String canModify = resourceBundle.getString(SHARE_OPTION_CANMODIFY);
                ArrayList<SelectItemOption> itemOptions = new ArrayList<SelectItemOption>();
                Node currentNode = this.getNode();
                if (PermissionUtil.canSetProperty((Node)currentNode)) {
                    itemOptions.add(new SelectItemOption(canView, (Object)SHARE_PERMISSION_VIEW));
                    itemOptions.add(new SelectItemOption(canModify, (Object)SHARE_PERMISSION_MODIFY));
                    ArrayList permOption = new ArrayList();
                    this.addChild((UIComponent)new UIFormSelectBox("permissionDropDown", "permissionDropDown", permOption));
                    ((UIFormSelectBox)this.getChild(UIFormSelectBox.class)).setOptions(itemOptions);
                    this.setPermissionDropDown(true);
                } else {
                    this.setPermissionDropDown(false);
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getDocumentName() {
        String[] arr = this.nodePath.split("/");
        return arr[arr.length - 1];
    }

    public Node getNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.node);
    }

    public String getFileExtension() {
        int index = this.nodePath.lastIndexOf(46);
        if (index != -1) {
            return this.nodePath.substring(index);
        }
        return "";
    }

    public String getIconURL() {
        try {
            return Utils.getNodeTypeIcon((Node)this.getNode(), (String)"uiIcon24x24");
        }
        catch (RepositoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public void setSelectedNode(NodeLocation node) {
        this.node = node;
        this.nodePath = node.getPath();
    }

    public UISpacesSwitcher getSpace() {
        return (UISpacesSwitcher)this.findFirstComponentOfType(UISpacesSwitcher.class);
    }

    public List<Space> getSpaces() {
        ArrayList<Space> lstSpaces = new ArrayList<Space>();
        SpaceService spaceService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
        for (String space : this.spaces) {
            Space spaceObject = spaceService.getSpaceByGroupId(space);
            if (spaceObject == null) continue;
            lstSpaces.add(spaceObject);
        }
        return lstSpaces;
    }

    public String getComment() {
        if (this.comment == null) {
            return "";
        }
        return this.comment;
    }

    public void activate() {
    }

    public void deActivate() {
    }

    public static class ShareActionListener
    extends EventListener<UIShareDocuments> {
        public void execute(Event<UIShareDocuments> event) throws Exception {
            if (((UIShareDocuments)((Object)event.getSource())).spaces.size() > 0) {
                UIFormSelectBox formSelectBox;
                IShareDocumentService service = (IShareDocumentService)WCMCoreUtils.getService(IShareDocumentService.class);
                List<String> spaces = ((UIShareDocuments)((Object)event.getSource())).spaces;
                Node node = ((UIShareDocuments)((Object)event.getSource())).getNode();
                String message = "";
                String perm = UIShareDocuments.SHARE_PERMISSION_VIEW;
                if (((UIFormTextAreaInput)((UIShareDocuments)((Object)event.getSource())).getChild(UIFormTextAreaInput.class)).getValue() != null) {
                    message = (String)((UIFormTextAreaInput)((UIShareDocuments)((Object)event.getSource())).getChild(UIFormTextAreaInput.class)).getValue();
                }
                if ((formSelectBox = (UIFormSelectBox)((UIShareDocuments)((Object)event.getSource())).getChild(UIFormSelectBox.class)) != null && formSelectBox.getValue() != null) {
                    perm = (String)((UIFormSelectBox)((UIShareDocuments)((Object)event.getSource())).getChild(UIFormSelectBox.class)).getValue();
                }
                for (String space : spaces) {
                    if (space.equals("")) continue;
                    service.publicDocumentToSpace(space, node, message, perm);
                }
                ((UIJCRExplorer)((UIShareDocuments)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class)).cancelAction();
            } else {
                UIShareDocuments uicomp = (UIShareDocuments)((Object)event.getSource());
                UIApplication uiApp = (UIApplication)uicomp.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIShareDocuments.label.NoSpace", null, 1));
            }
        }
    }

    public static class SelectSpaceActionListener
    extends EventListener<UIShareDocuments> {
        public void execute(Event<UIShareDocuments> event) throws Exception {
            List<String> spaces = ((UIShareDocuments)((Object)event.getSource())).spaces;
            ((UIShareDocuments)((Object)event.getSource())).comment = (String)((UIFormTextAreaInput)((UIShareDocuments)((Object)event.getSource())).getChild(UIFormTextAreaInput.class)).getValue();
            String space = event.getRequestContext().getRequestParameter("spaceId").toString();
            if (!spaces.contains(space)) {
                spaces.add(space);
            }
            UIShareDocumentSpaceMention uiShareDocumentSpaceMention = (UIShareDocumentSpaceMention)((UIShareDocuments)((Object)event.getSource())).findFirstComponentOfType(UIShareDocumentSpaceMention.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiShareDocumentSpaceMention);
            event.getRequestContext().getJavascriptManager().require("SHARED/share-content", "shareContent").addScripts("eXo.ecm.ShareContent.checkSelectedSpace('" + spaces + "');");
        }
    }

    public static class TextChangeActionListener
    extends EventListener<UIShareDocuments> {
        public void execute(Event<UIShareDocuments> event) throws Exception {
            UIShareDocuments uiform = (UIShareDocuments)((Object)event.getSource());
            uiform.comment = (String)((UIFormTextAreaInput)((UIShareDocuments)((Object)event.getSource())).getChild(UIFormTextAreaInput.class)).getValue();
            event.getRequestContext().addUIComponentToUpdateByAjax(((UIShareDocuments)((Object)event.getSource())).getChild(UIFormTextAreaInput.class));
        }
    }

    public static class CancelActionListener
    extends EventListener<UIShareDocuments> {
        public void execute(Event<UIShareDocuments> event) throws Exception {
            ((UIJCRExplorer)((UIShareDocuments)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class)).cancelAction();
        }
    }

    public static class RemoveSpaceActionListener
    extends EventListener<UIShareDocuments> {
        public void execute(Event<UIShareDocuments> event) throws Exception {
            UIShareDocuments uiform = (UIShareDocuments)((Object)event.getSource());
            uiform.spaces.remove(event.getRequestContext().getRequestParameter("objectId").toString());
            uiform.comment = ((UIFormTextAreaInput)((UIShareDocuments)((Object)event.getSource())).getChild(UIFormTextAreaInput.class)).getValue() == null ? "" : (String)((UIFormTextAreaInput)((UIShareDocuments)((Object)event.getSource())).getChild(UIFormTextAreaInput.class)).getValue();
            UIShareDocumentSpaceMention uiShareDocumentSpaceMention = (UIShareDocumentSpaceMention)((UIShareDocuments)((Object)event.getSource())).findFirstComponentOfType(UIShareDocumentSpaceMention.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiShareDocumentSpaceMention);
            event.getRequestContext().getJavascriptManager().require("SHARED/share-content", "shareContent").addScripts("eXo.ecm.ShareContent.checkSelectedSpace('" + uiform.spaces + "');");
        }
    }
}

