/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.BaseUIActivityBuilder;
import org.exoplatform.wcm.ext.component.activity.FileUIActivityBuilder;
import org.exoplatform.wcm.ext.component.activity.SharedFileUIActivity;
import org.exoplatform.wcm.ext.component.activity.listener.Utils;

public class UISharedFileBuilder
extends BaseUIActivityBuilder {
    private static final Log LOG = ExoLogger.getLogger(FileUIActivityBuilder.class);

    protected void extendUIActivity(BaseUIActivity uiActivity, ExoSocialActivity activity) {
        Node contentNode;
        SharedFileUIActivity fileActivity;
        block7: {
            fileActivity = (SharedFileUIActivity)uiActivity;
            String nodeUUID = "";
            String workspaceName = "";
            if (activity.getTemplateParams() != null) {
                fileActivity.setUIActivityData(activity.getTemplateParams());
                nodeUUID = (String)activity.getTemplateParams().get("nodeUUID");
                workspaceName = (String)activity.getTemplateParams().get("workspace");
            }
            contentNode = null;
            try {
                Node currentNode;
                ManageableRepository manageRepo = WCMCoreUtils.getRepository();
                if (StringUtils.isEmpty((String)workspaceName)) {
                    workspaceName = manageRepo.getConfiguration().getDefaultWorkspaceName();
                }
                SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
                LinkManager linkManager = (LinkManager)PortalContainer.getInstance().getComponentInstanceOfType(LinkManager.class);
                TrashService trashService = (TrashService)WCMCoreUtils.getService(TrashService.class);
                if (!trashService.isInTrash(currentNode = sessionProvider.getSession(workspaceName, manageRepo).getNodeByUUID(nodeUUID))) {
                    contentNode = linkManager.getTarget(currentNode);
                    fileActivity.docPath = contentNode.getPath();
                    fileActivity.workspace = workspaceName;
                    fileActivity.repository = manageRepo.toString();
                } else {
                    Utils.deleteFileActivity(currentNode);
                }
            }
            catch (ItemNotFoundException infe) {
                LOG.error((Object)"Item not found. Activity will be deleted ", (Throwable)infe);
                ActivityManager activityManager = (ActivityManager)WCMCoreUtils.getService(ActivityManager.class);
                activityManager.deleteActivity(activity);
            }
            catch (RepositoryException re) {
                if (!LOG.isErrorEnabled()) break block7;
                LOG.error((Object)"Can not get the repository. ", (Throwable)re);
            }
        }
        fileActivity.setActivityTitle(activity.getTitle().replace("</br></br>", ""));
        fileActivity.setContentNode(contentNode);
    }
}

