/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity.listener;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Value;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wcm.ext.component.activity.listener.Utils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;

public class FileAddPropertyActivityListener
extends Listener<Node, String> {
    private static final Log LOG = ExoLogger.getExoLogger(FileAddPropertyActivityListener.class);
    private String[] editedField = new String[]{"dc:title", "dc:description", "dc:creator", "dc:source"};
    private String[] bundleMessage = new String[]{"SocialIntegration.messages.editTitle", "SocialIntegration.messages.editDescription", "SocialIntegration.messages.singleCreator", "SocialIntegration.messages.addSource"};
    private boolean[] needUpdate = new boolean[]{false, false, false, false};
    private int consideredFieldCount = this.editedField.length;

    public void onEvent(Event<Node, String> event) throws Exception {
        Node currentNode = (Node)event.getSource();
        String propertyName = (String)event.getData();
        StringBuilder newValueBuilder = new StringBuilder();
        StringBuilder commentValueBuilder = new StringBuilder();
        try {
            if (currentNode.getProperty(propertyName).getDefinition().isMultiple()) {
                Value[] values = currentNode.getProperty(propertyName).getValues();
                if (values != null) {
                    for (Value value : values) {
                        newValueBuilder.append(value.getString()).append(ActivityCommonService.METADATA_VALUE_SEPERATOR);
                        commentValueBuilder.append(value.getString()).append(", ");
                    }
                    if (newValueBuilder.length() >= ActivityCommonService.METADATA_VALUE_SEPERATOR.length()) {
                        newValueBuilder.delete(newValueBuilder.length() - ActivityCommonService.METADATA_VALUE_SEPERATOR.length(), newValueBuilder.length());
                    }
                    if (commentValueBuilder.length() >= 2) {
                        commentValueBuilder.delete(commentValueBuilder.length() - 2, commentValueBuilder.length());
                    }
                }
            } else {
                Property prop = currentNode.getProperty(propertyName);
                newValueBuilder = prop.getDefinition().getRequiredType() == 2 ? new StringBuilder() : new StringBuilder(currentNode.getProperty(propertyName).getString());
            }
        }
        catch (Exception e) {
            newValueBuilder = new StringBuilder();
            commentValueBuilder = new StringBuilder();
        }
        String newValue = newValueBuilder.toString().trim();
        String commentValue = commentValueBuilder.toString().trim();
        if (newValue != null && newValue.length() > 0) {
            if (currentNode.isNodeType("nt:resource")) {
                currentNode = currentNode.getParent();
            }
            String resourceBundle = "";
            boolean hit = false;
            for (int i = 0; i < this.consideredFieldCount; ++i) {
                if (!propertyName.equals(this.editedField[i])) continue;
                resourceBundle = this.bundleMessage[i];
                if (propertyName.equals("dc:creator") && newValue.split(ActivityCommonService.METADATA_VALUE_SEPERATOR).length > 1) {
                    resourceBundle = "SocialIntegration.messages.multiCreator";
                }
                if (propertyName.equals("dc:source") && newValue.split(ActivityCommonService.METADATA_VALUE_SEPERATOR).length > 1) {
                    resourceBundle = "SocialIntegration.messages.addMultiSource";
                }
                Utils.postFileActivity(currentNode, resourceBundle, this.needUpdate[i], true, commentValue, "");
                hit = true;
                break;
            }
            if (!hit && propertyName.startsWith("dc:") && !propertyName.equals("dc:date")) {
                PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
                String dcProperty = propertyName;
                try {
                    dcProperty = portletRequestContext.getApplicationResourceBundle().getString("ElementSet.dialog.label." + propertyName.substring(propertyName.lastIndexOf(":") + 1, propertyName.length()));
                }
                catch (Exception ex) {
                    LOG.info((Object)"cannot get property name");
                }
                resourceBundle = "SocialIntegration.messages.updateMetadata";
                resourceBundle = portletRequestContext.getApplicationResourceBundle().getString(resourceBundle);
                resourceBundle = resourceBundle.replace("{0}", dcProperty);
                resourceBundle = resourceBundle.replace("{1}", commentValue);
                Utils.postFileActivity(currentNode, resourceBundle, false, true, commentValue, "");
            }
        }
    }
}

