/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.ext.activity;

import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.processor.I18NActivityUtils;

public enum ForumActivityType {
    ADD_TOPIC("forum.add-topic", "%s"),
    UPDATE_TOPIC_TITLE("forum.update-topic-title", "Title has been updated to: %s"),
    UPDATE_TOPIC_CONTENT("forum.update-topic-content", "Content has been edited."),
    UPDATE_TOPIC_RATE("forum.update-topic-rate", "Rated the topic: %s"),
    CLOSE_TOPIC("forum.closed-topic", "Topic has been closed."),
    OPEN_TOPIC("forum.opened-topic", "Topic has been opened."),
    LOCK_TOPIC("forum.locked-topic", "Topic has been locked."),
    UNLOCK_TOPIC("forum.unlocked-topic", "Topic has been unlocked."),
    APPROVED_TOPIC("forum.approved-topic", "Topic has been approved."),
    UNAPPROVED_TOPIC("forum.unapproved-topic", "Topic has been unapproved."),
    MERGE_TOPICS("forum.merge-topic", "%s"),
    SPLIT_TOPIC("forum.split-topic", "%s"),
    MOVE_TOPIC("forum.move-topic", "Topic have been moved to: %s>%s"),
    ADD_POST("forum.add-post", "%s"),
    UPDATE_POST("forum.update-post", "Edited his reply to: %s");

    private final String titleTemplate;
    private final String resourceBundleKey;

    private ForumActivityType(String resourceBundleKey, String titleTemplate) {
        this.titleTemplate = titleTemplate;
        this.resourceBundleKey = resourceBundleKey;
    }

    public String getTitle(ExoSocialActivity a, String value) {
        String got = this.titleTemplate;
        if (value != null) {
            got = String.format(this.titleTemplate, value);
        }
        I18NActivityUtils.addResourceKey((ExoSocialActivity)a, (String)this.resourceBundleKey, (String[])new String[]{value});
        return got;
    }

    public ExoSocialActivity getActivity(ExoSocialActivity a, String ... values) {
        if (values != null && values.length > 0) {
            a.setTitle(String.format(this.titleTemplate, values));
        } else {
            a.setTitle(this.titleTemplate);
        }
        I18NActivityUtils.addResourceKey((ExoSocialActivity)a, (String)this.resourceBundleKey, (String[])values);
        return a;
    }

    public String getTitle(ExoSocialActivity a, String ... values) {
        String got = this.titleTemplate;
        if (values != null && values.length > 0) {
            got = String.format(this.titleTemplate, values);
        }
        I18NActivityUtils.addResourceKey((ExoSocialActivity)a, (String)this.resourceBundleKey, (String[])values);
        return got;
    }
}

