/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.ext.impl;

import java.beans.PropertyChangeEvent;
import java.util.List;
import org.exoplatform.commons.utils.PropertyChangeSupport;
import org.exoplatform.forum.ext.activity.ActivityExecutor;
import org.exoplatform.forum.ext.activity.ForumActivityContext;
import org.exoplatform.forum.ext.activity.ForumActivityUtils;
import org.exoplatform.forum.ext.activity.PostActivityTask;
import org.exoplatform.forum.ext.activity.TopicActivityTask;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumEventListener;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;

public class ForumSpaceActivityPublisher
extends ForumEventListener {
    public static final int APPROVE = 3;
    public static final int WAITING = 5;
    public static final int HIDDEN = 9;

    public void saveCategory(Category category) {
    }

    public void saveForum(Forum forum) {
    }

    public void addPost(Post post) {
        ForumActivityContext ctx = ForumActivityContext.makeContextForAddPost(post);
        PostActivityTask task = PostActivityTask.ADD_POST;
        ctx = ForumActivityUtils.processBBCode(ctx);
        ExoSocialActivity comment = ActivityExecutor.execute(task, ctx);
        ForumActivityUtils.takeCommentBack(post, comment);
    }

    public void updatePost(Post post) {
        ForumActivityContext ctx = ForumActivityContext.makeContextForUpdatePost(post);
        PostActivityTask task = PostActivityTask.UPDATE_POST;
        ctx = ForumActivityUtils.processBBCode(ctx);
        ActivityExecutor.execute(task, ctx);
    }

    public void updatePost(Post post, int type) {
        switch (type) {
            case 9: {
                if (post.getIsHidden()) {
                    ForumActivityContext ctx = ForumActivityContext.makeContextForUpdatePost(post);
                    PostActivityTask task = PostActivityTask.HIDE_POST;
                    ActivityExecutor.execute(task, ctx);
                    break;
                }
                ForumActivityContext ctx = ForumActivityContext.makeContextForUpdatePost(post);
                PostActivityTask task = PostActivityTask.UNHIDE_POST;
                ActivityExecutor.execute(task, ctx);
                break;
            }
            case 5: {
                if (post.getIsWaiting()) {
                    ForumActivityContext ctx = ForumActivityContext.makeContextForUpdatePost(post);
                    PostActivityTask task = PostActivityTask.HIDE_POST;
                    ActivityExecutor.execute(task, ctx);
                    break;
                }
                ForumActivityContext ctx = ForumActivityContext.makeContextForUpdatePost(post);
                PostActivityTask task = PostActivityTask.UNHIDE_POST;
                ActivityExecutor.execute(task, ctx);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void addTopic(Topic topic) {
        ForumActivityContext ctx = ForumActivityContext.makeContextForAddTopic(topic);
        TopicActivityTask task = TopicActivityTask.ADD_TOPIC;
        ctx = ForumActivityUtils.processBBCode(ctx);
        ExoSocialActivity got = ActivityExecutor.execute(task, ctx);
        ForumActivityUtils.takeActivityBack(topic, got);
    }

    public void updateTopic(Topic topic) {
        TopicActivityTask task = null;
        ForumActivityContext ctx = ForumActivityContext.makeContextForUpdateTopic(topic);
        this.updateProperties(topic, ctx);
        PropertyChangeEvent[] events = topic.getChangeEvent();
        for (int i = 0; i < events.length; ++i) {
            task = this.getTaskFromUpdateTopic(events[i], ctx);
            ActivityExecutor.execute(task, ctx);
        }
    }

    public void updateTopics(List<Topic> topics, boolean isLock) {
        for (Topic topic : topics) {
            topic.setIsLock(isLock);
            ForumActivityContext ctx = ForumActivityContext.makeContextForAddTopic(topic);
            TopicActivityTask task = TopicActivityTask.UPDATE_FORUM_TOPIC;
            ActivityExecutor.execute(task, ctx);
        }
    }

    private void updateProperties(Topic topic, ForumActivityContext ctx) {
        PropertyChangeSupport newPcs = new PropertyChangeSupport((Object)topic);
        PropertyChangeSupport pcs = topic.getPcs();
        if (pcs.hasPropertyName(Topic.TOPIC_NAME)) {
            newPcs.addPropertyChange(pcs.getPropertyChange(Topic.TOPIC_NAME));
        }
        if (pcs.hasPropertyName(Topic.TOPIC_CONTENT)) {
            newPcs.addPropertyChange(pcs.getPropertyChange(Topic.TOPIC_CONTENT));
        }
        if (newPcs.getChangeEvents().length > 1) {
            ctx.setPcs(newPcs);
            TopicActivityTask task = TopicActivityTask.UPDATE_TOPIC_PROPERTIES;
            ctx = ForumActivityUtils.processBBCode(ctx);
            ActivityExecutor.execute(task, ctx);
            pcs.removePropertyChange(Topic.TOPIC_NAME);
            pcs.removePropertyChange(Topic.TOPIC_CONTENT);
        }
    }

    public void moveTopic(Topic topic, String toCategoryName, String toForumName) {
        ForumActivityContext ctx = ForumActivityContext.makeContextForMoveTopic(topic, toCategoryName, toForumName);
        TopicActivityTask task = TopicActivityTask.MOVE_TOPIC;
        ActivityExecutor.execute(task, ctx);
    }

    public void mergeTopic(Topic newTopic, String removeActivityId1, String removeActivityId2) {
        ForumActivityContext ctx = ForumActivityContext.makeContextForMergeTopic(newTopic, removeActivityId1, removeActivityId2);
        TopicActivityTask task = TopicActivityTask.MERGE_TOPIC;
        ExoSocialActivity got = ActivityExecutor.execute(task, ctx);
        ForumActivityUtils.takeActivityBack(ctx.getTopic(), got);
    }

    public void splitTopic(Topic newTopic, Topic splitedTopic, String removeActivityId) {
        ForumActivityContext ctx = ForumActivityContext.makeContextForSplitTopic(newTopic, splitedTopic, removeActivityId);
        TopicActivityTask task = TopicActivityTask.SPLIT_TOPIC;
        ExoSocialActivity activity = ActivityExecutor.execute(task, ctx);
        ForumActivityUtils.takeActivityBack(newTopic, activity);
    }

    public void removeActivity(String activityId) {
        ForumActivityUtils.removeActivities(activityId);
    }

    public void removeComment(String activityId, String commentId) {
        ForumActivityUtils.removeComment(activityId, commentId);
    }

    private TopicActivityTask getTaskFromUpdateTopic(PropertyChangeEvent event, ForumActivityContext ctx) {
        TopicActivityTask got = null;
        if (Topic.TOPIC_NAME.equals(event.getPropertyName())) {
            got = TopicActivityTask.UPDATE_TOPIC_TITLE;
        } else if (Topic.TOPIC_CONTENT.equals(event.getPropertyName())) {
            got = TopicActivityTask.UPDATE_TOPIC_CONTENT;
            ctx = ForumActivityUtils.processBBCode(ctx);
        } else if (Topic.TOPIC_RATING.equals(event.getPropertyName())) {
            got = TopicActivityTask.UPDATE_TOPIC_RATE;
        } else if (Topic.TOPIC_STATE_CLOSED.equals(event.getPropertyName())) {
            boolean isClose = (Boolean)event.getNewValue();
            got = isClose ? TopicActivityTask.CLOSE_TOPIC : TopicActivityTask.OPEN_TOPIC;
        } else if (Topic.TOPIC_STATUS_LOCK.equals(event.getPropertyName())) {
            boolean isLock = (Boolean)event.getNewValue();
            got = isLock ? TopicActivityTask.LOCK_TOPIC : TopicActivityTask.UNLOCK_TOPIC;
        } else if (Topic.TOPIC_STATUS_APPROVED.equals(event.getPropertyName())) {
            boolean isLock = (Boolean)event.getNewValue();
            got = isLock ? TopicActivityTask.APPROVED_TOPIC : TopicActivityTask.UNAPPROVED_TOPIC;
        } else if (Topic.TOPIC_STATUS_ACTIVE.equals(event.getPropertyName())) {
            boolean isActive = (Boolean)event.getNewValue();
            got = isActive ? TopicActivityTask.ACTIVE_TOPIC : TopicActivityTask.HIDDEN_TOPIC;
        } else if (Topic.TOPIC_STATUS_WAITING.equals(event.getPropertyName())) {
            boolean isWaiting = (Boolean)event.getNewValue();
            got = isWaiting ? TopicActivityTask.CENSORING_TOPIC : TopicActivityTask.UNCENSORING_TOPIC;
        }
        return got;
    }
}

