/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.ext.activity;

import java.util.Map;
import org.exoplatform.commons.utils.PropertyChangeSupport;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.UserHelper;
import org.exoplatform.forum.ext.activity.ActivityTask;
import org.exoplatform.forum.ext.activity.ForumActivityBuilder;
import org.exoplatform.forum.ext.activity.ForumActivityContext;
import org.exoplatform.forum.ext.activity.ForumActivityType;
import org.exoplatform.forum.ext.activity.ForumActivityUtils;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;

public abstract class TopicActivityTask
implements ActivityTask<ForumActivityContext> {
    protected static final Log LOG = ExoLogger.getLogger(TopicActivityTask.class);
    public static final String SPACE_GROUP_ID = "SpaceGroupId";
    public static TopicActivityTask ADD_TOPIC = new TopicActivityTask(){

        @Override
        protected ExoSocialActivity processTitle(ForumActivityContext ctx, ExoSocialActivity activity) {
            return ForumActivityType.ADD_TOPIC.getActivity(activity, activity.getTitle());
        }

        @Override
        protected ExoSocialActivity processActivity(ForumActivityContext ctx, ExoSocialActivity activity) {
            if (ctx.getTopic().getIsWaiting()) {
                activity.isHidden(true);
            }
            if (!ctx.getTopic().getIsApproved()) {
                activity.isLocked(true);
            }
            return this.processTitle(ctx, activity);
        }

        @Override
        public ExoSocialActivity execute(ForumActivityContext ctx) {
            try {
                ActivityManager am = ForumActivityUtils.getActivityManager();
                Identity streamOwner = this.getOwnerStream(ctx);
                ExoSocialActivity newActivity = ForumActivityBuilder.createActivity(ctx.getTopic(), ctx);
                newActivity = this.processActivity(ctx, newActivity);
                Identity poster = ForumActivityUtils.getIdentity(ctx.getTopic().getOwner());
                newActivity.setUserId(poster.getId());
                am.saveActivityNoReturn(streamOwner, newActivity);
                return newActivity;
            }
            catch (Exception e) {
                LOG.warn((Object)("Can not record Activity for when add topic's id: " + ctx.getTopic().getId()));
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
    };
    public static TopicActivityTask UPDATE_TOPIC_PROPERTIES = new TopicActivityTask(){

        @Override
        protected ExoSocialActivity processTitle(ForumActivityContext ctx, ExoSocialActivity activity) {
            return activity;
        }

        @Override
        protected ExoSocialActivity processComment(ForumActivityContext ctx) {
            ExoSocialActivity newComment = ForumActivityBuilder.createActivityComment(ctx.getTopic(), ctx);
            PropertyChangeSupport newPcs = ctx.getPcs();
            Topic topic = ctx.getTopic();
            StringBuilder sb = new StringBuilder();
            if (newPcs.hasPropertyName(Topic.TOPIC_NAME)) {
                String topicName = topic.getTopicName();
                ForumActivityType.UPDATE_TOPIC_TITLE.getTitle(newComment, CommonUtils.decodeSpecialCharToHTMLnumberIgnore((String)topicName));
                String title = ForumActivityType.UPDATE_TOPIC_TITLE.getTitleTemplate();
                title = String.format(title, CommonUtils.decodeSpecialCharToHTMLnumber((String)topicName));
                sb.append(title).append("\n");
            }
            if (newPcs.hasPropertyName(Topic.TOPIC_CONTENT)) {
                String description = topic.getDescription();
                sb.append(ForumActivityType.UPDATE_TOPIC_CONTENT.getTitle(newComment, description));
            }
            newComment.setTitle(sb.toString());
            return newComment;
        }

        @Override
        protected ExoSocialActivity processActivity(ForumActivityContext ctx, ExoSocialActivity activity) {
            activity.setTitle(CommonUtils.decodeSpecialCharToHTMLnumber((String)ctx.getTopic().getTopicName()));
            activity.setBody(ForumActivityBuilder.getFourFirstLines(ctx.getTopic().getDescription()));
            return activity;
        }

        @Override
        public ExoSocialActivity execute(ForumActivityContext ctx) {
            try {
                ActivityManager am = ForumActivityUtils.getActivityManager();
                ExoSocialActivity a = ForumActivityUtils.getActivityOfTopic(ctx);
                a = this.processActivity(ctx, a);
                am.updateActivity(a);
                ExoSocialActivity newComment = this.processComment(ctx);
                Identity poster = ForumActivityUtils.getIdentity(ctx.getTopic().getModifiedBy());
                newComment.setUserId(poster.getId());
                am.saveComment(a, newComment);
                return newComment;
            }
            catch (Exception e) {
                LOG.warn((Object)("Can not record Comment for when update topic: " + ctx.getTopic().getId()));
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
    };
    public static TopicActivityTask UPDATE_TOPIC_TITLE = new TopicActivityTask(){

        @Override
        protected ExoSocialActivity processTitle(ForumActivityContext ctx, ExoSocialActivity activity) {
            String topicName = ctx.getTopic().getTopicName();
            String title = ForumActivityType.UPDATE_TOPIC_TITLE.getTitleTemplate();
            title = String.format(title, CommonUtils.decodeSpecialCharToHTMLnumber((String)topicName));
            activity.setTitle(title);
            ForumActivityType.UPDATE_TOPIC_TITLE.getTitle(activity, CommonUtils.decodeSpecialCharToHTMLnumberIgnore((String)topicName));
            return activity;
        }

        @Override
        protected ExoSocialActivity processActivity(ForumActivityContext ctx, ExoSocialActivity activity) {
            activity.setTitle(CommonUtils.decodeSpecialCharToHTMLnumber((String)ctx.getTopic().getTopicName()));
            return activity;
        }

        @Override
        public ExoSocialActivity execute(ForumActivityContext ctx) {
            try {
                ActivityManager am = ForumActivityUtils.getActivityManager();
                ExoSocialActivity a = ForumActivityUtils.getActivityOfTopic(ctx);
                a = this.processActivity(ctx, a);
                am.updateActivity(a);
                ExoSocialActivity newComment = this.processComment(ctx);
                Identity poster = ForumActivityUtils.getIdentity(ctx.getTopic().getModifiedBy());
                newComment.setUserId(poster.getId());
                am.saveComment(a, newComment);
                return newComment;
            }
            catch (Exception e) {
                LOG.warn((Object)("Can not record Comment for when update topic: " + ctx.getTopic().getId()));
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
    };
    public static TopicActivityTask UPDATE_TOPIC_CONTENT = new TopicActivityTask(){

        @Override
        protected ExoSocialActivity processTitle(ForumActivityContext ctx, ExoSocialActivity activity) {
            return ForumActivityType.UPDATE_TOPIC_CONTENT.getActivity(activity, new String[0]);
        }

        @Override
        protected ExoSocialActivity processActivity(ForumActivityContext ctx, ExoSocialActivity activity) {
            activity.setBody(ForumActivityBuilder.getFourFirstLines(ctx.getTopic().getDescription()));
            return activity;
        }

        @Override
        public ExoSocialActivity execute(ForumActivityContext ctx) {
            try {
                ActivityManager am = ForumActivityUtils.getActivityManager();
                ExoSocialActivity a = ForumActivityUtils.getActivityOfTopic(ctx);
                a = this.processActivity(ctx, a);
                am.updateActivity(a);
                ExoSocialActivity newComment = this.processComment(ctx);
                Identity poster = ForumActivityUtils.getIdentity(ctx.getTopic().getModifiedBy());
                newComment.setUserId(poster.getId());
                am.saveComment(a, newComment);
                return newComment;
            }
            catch (Exception e) {
                LOG.warn((Object)("Can not record Comment for when update topic's id: " + ctx.getTopic().getId()));
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
    };
    public static TopicActivityTask UPDATE_TOPIC_RATE = new TopicActivityTask(){

        @Override
        protected ExoSocialActivity processTitle(ForumActivityContext ctx, ExoSocialActivity activity) {
            return ForumActivityType.UPDATE_TOPIC_RATE.getActivity(activity, "" + ctx.getTopic().getVoteRating());
        }

        @Override
        protected ExoSocialActivity processActivity(ForumActivityContext ctx, ExoSocialActivity activity) {
            Map templateParams = activity.getTemplateParams();
            templateParams.put("TopicVoteRate", "" + ctx.getTopic().getVoteRating());
            return activity;
        }

        @Override
        public ExoSocialActivity execute(ForumActivityContext ctx) {
            try {
                ActivityManager am = ForumActivityUtils.getActivityManager();
                ExoSocialActivity a = ForumActivityUtils.getActivityOfTopic(ctx);
                a = this.processActivity(ctx, a);
                am.updateActivity(a);
                ExoSocialActivity newComment = this.processComment(ctx);
                Identity poster = ForumActivityUtils.getIdentity(UserHelper.getCurrentUser());
                newComment.setUserId(poster.getId());
                am.saveComment(a, newComment);
                return newComment;
            }
            catch (Exception e) {
                LOG.warn((Object)("Can not record Comment for when update topic's id: " + ctx.getTopic().getId()));
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
    };
    public static TopicActivityTask CLOSE_TOPIC = new TopicActivityTask(){

        @Override
        protected ExoSocialActivity processTitle(ForumActivityContext ctx, ExoSocialActivity activity) {
            return ForumActivityType.CLOSE_TOPIC.getActivity(activity, new String[0]);
        }

        @Override
        protected ExoSocialActivity processActivity(ForumActivityContext ctx, ExoSocialActivity activity) {
            activity.isLocked(true);
            return activity;
        }

        @Override
        public ExoSocialActivity execute(ForumActivityContext ctx) {
            try {
                ActivityManager am = ForumActivityUtils.getActivityManager();
                ExoSocialActivity a = ForumActivityUtils.getActivityOfTopic(ctx);
                a = this.processActivity(ctx, a);
                am.updateActivity(a);
                ExoSocialActivity newComment = this.processComment(ctx);
                Identity poster = ForumActivityUtils.getIdentity(ctx.getTopic().getModifiedBy());
                newComment.setUserId(poster.getId());
                am.saveComment(a, newComment);
                return newComment;
            }
            catch (Exception e) {
                LOG.warn((Object)("Can not record Comment for when close topic's id: " + ctx.getTopic().getId()));
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
    };
    public static TopicActivityTask OPEN_TOPIC = new TopicActivityTask(){

        @Override
        protected ExoSocialActivity processTitle(ForumActivityContext ctx, ExoSocialActivity activity) {
            return ForumActivityType.OPEN_TOPIC.getActivity(activity, new String[0]);
        }

        @Override
        protected ExoSocialActivity processActivity(ForumActivityContext ctx, ExoSocialActivity activity) {
            activity.isLocked(false);
            return activity;
        }

        @Override
        public ExoSocialActivity execute(ForumActivityContext ctx) {
            try {
                ActivityManager am = ForumActivityUtils.getActivityManager();
                ExoSocialActivity a = ForumActivityUtils.getActivityOfTopic(ctx);
                a = this.processActivity(ctx, a);
                am.updateActivity(a);
                ExoSocialActivity newComment = this.processComment(ctx);
                Identity poster = ForumActivityUtils.getIdentity(ctx.getTopic().getModifiedBy());
                newComment.setUserId(poster.getId());
                am.saveComment(a, newComment);
                return newComment;
            }
            catch (Exception e) {
                LOG.warn((Object)("Can not record Comment for when open topic's id: " + ctx.getTopic().getId()));
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
    };
    public static TopicActivityTask LOCK_TOPIC = new TopicActivityTask(){

        @Override
        protected ExoSocialActivity processTitle(ForumActivityContext ctx, ExoSocialActivity activity) {
            return ForumActivityType.LOCK_TOPIC.getActivity(activity, new String[0]);
        }

        @Override
        protected ExoSocialActivity processActivity(ForumActivityContext ctx, ExoSocialActivity activity) {
            activity.isLocked(true);
            return activity;
        }

        @Override
        public ExoSocialActivity execute(ForumActivityContext ctx) {
            try {
                ActivityManager am = ForumActivityUtils.getActivityManager();
                ExoSocialActivity a = ForumActivityUtils.getActivityOfTopic(ctx);
                a = this.processActivity(ctx, a);
                am.updateActivity(a);
                ExoSocialActivity newComment = this.processComment(ctx);
                Identity poster = ForumActivityUtils.getIdentity(ctx.getTopic().getModifiedBy());
                newComment.setUserId(poster.getId());
                am.saveComment(a, newComment);
                return newComment;
            }
            catch (Exception e) {
                LOG.warn((Object)("Can not record Comment for when lock topic's id: " + ctx.getTopic().getId()));
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
    };
    public static TopicActivityTask UNLOCK_TOPIC = new TopicActivityTask(){

        @Override
        protected ExoSocialActivity processTitle(ForumActivityContext ctx, ExoSocialActivity activity) {
            return ForumActivityType.UNLOCK_TOPIC.getActivity(activity, new String[0]);
        }

        @Override
        protected ExoSocialActivity processActivity(ForumActivityContext ctx, ExoSocialActivity activity) {
            activity.isLocked(false);
            return activity;
        }

        @Override
        public ExoSocialActivity execute(ForumActivityContext ctx) {
            try {
                ActivityManager am = ForumActivityUtils.getActivityManager();
                ExoSocialActivity a = ForumActivityUtils.getActivityOfTopic(ctx);
                a = this.processActivity(ctx, a);
                am.updateActivity(a);
                ExoSocialActivity newComment = this.processComment(ctx);
                Identity poster = ForumActivityUtils.getIdentity(ctx.getTopic().getModifiedBy());
                newComment.setUserId(poster.getId());
                am.saveComment(a, newComment);
                return newComment;
            }
            catch (Exception e) {
                LOG.warn((Object)("Can not record Comment for when unlock topic's id: " + ctx.getTopic().getId()));
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
    };
    public static TopicActivityTask APPROVED_TOPIC = new TopicActivityTask(){

        @Override
        protected ExoSocialActivity processTitle(ForumActivityContext ctx, ExoSocialActivity activity) {
            return ForumActivityType.APPROVED_TOPIC.getActivity(activity, new String[0]);
        }

        @Override
        protected ExoSocialActivity processActivity(ForumActivityContext ctx, ExoSocialActivity activity) {
            activity.isHidden(true);
            return activity;
        }

        @Override
        public ExoSocialActivity execute(ForumActivityContext ctx) {
            try {
                ActivityManager am = ForumActivityUtils.getActivityManager();
                ExoSocialActivity a = ForumActivityUtils.getActivityOfTopic(ctx);
                a = this.processActivity(ctx, a);
                am.updateActivity(a);
                ExoSocialActivity newComment = this.processComment(ctx);
                Identity poster = ForumActivityUtils.getIdentity(ctx.getTopic().getModifiedBy());
                newComment.setUserId(poster.getId());
                am.saveComment(a, newComment);
                return newComment;
            }
            catch (Exception e) {
                LOG.warn((Object)("Can not record Comment for when approved topic's id: " + ctx.getTopic().getId()));
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
    };
    public static TopicActivityTask UNAPPROVED_TOPIC = new TopicActivityTask(){

        @Override
        protected ExoSocialActivity processTitle(ForumActivityContext ctx, ExoSocialActivity activity) {
            return ForumActivityType.UNAPPROVED_TOPIC.getActivity(activity, new String[0]);
        }

        @Override
        protected ExoSocialActivity processActivity(ForumActivityContext ctx, ExoSocialActivity activity) {
            activity.isHidden(true);
            return activity;
        }

        @Override
        public ExoSocialActivity execute(ForumActivityContext ctx) {
            try {
                ActivityManager am = ForumActivityUtils.getActivityManager();
                ExoSocialActivity a = ForumActivityUtils.getActivityOfTopic(ctx);
                a = this.processActivity(ctx, a);
                am.updateActivity(a);
                ExoSocialActivity newComment = this.processComment(ctx);
                Identity poster = ForumActivityUtils.getIdentity(ctx.getTopic().getModifiedBy());
                newComment.setUserId(poster.getId());
                am.saveComment(a, newComment);
                return newComment;
            }
            catch (Exception e) {
                LOG.warn((Object)("Can not record Comment for when unapproved topic's id: " + ctx.getTopic().getId()));
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
    };
    public static TopicActivityTask HIDDEN_TOPIC = new TopicActivityTask(){

        @Override
        protected ExoSocialActivity processTitle(ForumActivityContext ctx, ExoSocialActivity activity) {
            return activity;
        }

        @Override
        protected ExoSocialActivity processActivity(ForumActivityContext ctx, ExoSocialActivity activity) {
            activity.isHidden(true);
            return activity;
        }

        @Override
        public ExoSocialActivity execute(ForumActivityContext ctx) {
            try {
                ActivityManager am = ForumActivityUtils.getActivityManager();
                ExoSocialActivity a = ForumActivityUtils.getActivityOfTopic(ctx);
                a = this.processActivity(ctx, a);
                am.updateActivity(a);
                return a;
            }
            catch (Exception e) {
                LOG.error((Object)("Can not record Comment for when hidden topic " + ctx.getTopic().getId()), (Throwable)e);
                return null;
            }
        }
    };
    public static TopicActivityTask CENSORING_TOPIC = new TopicActivityTask(){

        @Override
        protected ExoSocialActivity processTitle(ForumActivityContext ctx, ExoSocialActivity activity) {
            return activity;
        }

        @Override
        protected ExoSocialActivity processActivity(ForumActivityContext ctx, ExoSocialActivity activity) {
            activity.isHidden(true);
            return activity;
        }

        @Override
        public ExoSocialActivity execute(ForumActivityContext ctx) {
            try {
                ActivityManager am = ForumActivityUtils.getActivityManager();
                ExoSocialActivity a = ForumActivityUtils.getActivityOfTopic(ctx);
                a = this.processActivity(ctx, a);
                am.updateActivity(a);
                return a;
            }
            catch (Exception e) {
                LOG.warn((Object)("Can not record Comment for when hidden topic's id: " + ctx.getTopic().getId()));
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
    };
    public static TopicActivityTask UNCENSORING_TOPIC = new TopicActivityTask(){

        @Override
        public ExoSocialActivity processTitle(ForumActivityContext ctx, ExoSocialActivity activity) {
            return activity;
        }

        @Override
        protected ExoSocialActivity processActivity(ForumActivityContext ctx, ExoSocialActivity activity) {
            activity.isHidden(false);
            return activity;
        }

        @Override
        public ExoSocialActivity execute(ForumActivityContext ctx) {
            try {
                ActivityManager am = ForumActivityUtils.getActivityManager();
                ExoSocialActivity a = ForumActivityUtils.getActivityOfTopic(ctx);
                a = this.processActivity(ctx, a);
                am.updateActivity(a);
                return a;
            }
            catch (Exception e) {
                LOG.error((Object)("Can not show activity for uncensoring topic " + ctx.getTopic().getId()), (Throwable)e);
                return null;
            }
        }
    };
    public static TopicActivityTask ACTIVE_TOPIC = new TopicActivityTask(){

        @Override
        protected ExoSocialActivity processTitle(ForumActivityContext ctx, ExoSocialActivity activity) {
            return activity;
        }

        @Override
        protected ExoSocialActivity processActivity(ForumActivityContext ctx, ExoSocialActivity activity) {
            activity.isHidden(false);
            return activity;
        }

        @Override
        public ExoSocialActivity execute(ForumActivityContext ctx) {
            try {
                ActivityManager am = ForumActivityUtils.getActivityManager();
                ExoSocialActivity a = ForumActivityUtils.getActivityOfTopic(ctx);
                a = this.processActivity(ctx, a);
                am.updateActivity(a);
                return a;
            }
            catch (Exception e) {
                LOG.error((Object)("Can not record Comment for when active topic " + ctx.getTopic().getId()), (Throwable)e);
                return null;
            }
        }
    };
    public static TopicActivityTask MOVE_TOPIC = new TopicActivityTask(){

        @Override
        protected ExoSocialActivity processTitle(ForumActivityContext ctx, ExoSocialActivity activity) {
            return ForumActivityType.MOVE_TOPIC.getActivity(activity, ctx.getToCategoryName(), ctx.getToForumName());
        }

        @Override
        protected ExoSocialActivity processActivity(ForumActivityContext ctx, ExoSocialActivity activity) {
            Topic topic = ctx.getTopic();
            Map templateParams = activity.getTemplateParams();
            templateParams.put("TopicOwner", topic.getOwner());
            templateParams.put("ForumId", topic.getForumId());
            templateParams.put("CateId", topic.getCategoryId());
            if (ForumActivityUtils.hasSpace(topic.getForumId())) {
                templateParams.put(TopicActivityTask.SPACE_GROUP_ID, ForumActivityUtils.getSpaceGroupId(topic.getForumId()));
            }
            activity.setTemplateParams(templateParams);
            return activity;
        }

        @Override
        public ExoSocialActivity execute(ForumActivityContext ctx) {
            try {
                ExoSocialActivity aPoll;
                ActivityManager am = ForumActivityUtils.getActivityManager();
                ExoSocialActivity a = ForumActivityUtils.getActivityOfTopic(ctx);
                Identity streamOwner = this.getOwnerStream(ctx);
                if (ctx.getTopic().getIsPoll() && (aPoll = ForumActivityUtils.getActivityOfPollTopic(ctx)) != null) {
                    aPoll.setStreamOwner(streamOwner.getRemoteId());
                    am.updateActivity(aPoll);
                }
                a.setStreamOwner(streamOwner.getRemoteId());
                a = this.processActivity(ctx, a);
                am.updateActivity(a);
                ExoSocialActivity newComment = this.processComment(ctx);
                String currentUser = UserHelper.getCurrentUser();
                Identity poster = ForumActivityUtils.getIdentity(currentUser);
                newComment.setUserId(poster.getId());
                am.saveComment(a, newComment);
                return newComment;
            }
            catch (Exception e) {
                LOG.error((Object)("Can not record Comment for when moves topic " + ctx.getTopic().getId()), (Throwable)e);
                return null;
            }
        }
    };
    public static TopicActivityTask MERGE_TOPIC = new TopicActivityTask(){

        @Override
        protected ExoSocialActivity processTitle(ForumActivityContext ctx, ExoSocialActivity activity) {
            return ForumActivityType.MERGE_TOPICS.getActivity(activity, activity.getTitle());
        }

        @Override
        protected ExoSocialActivity processActivity(ForumActivityContext ctx, ExoSocialActivity activity) {
            return this.processTitle(ctx, activity);
        }

        @Override
        public ExoSocialActivity execute(ForumActivityContext ctx) {
            try {
                Identity streamOwner = this.getOwnerStream(ctx);
                ExoSocialActivity newActivity = ForumActivityBuilder.createActivity(ctx.getTopic(), ctx);
                newActivity = this.processActivity(ctx, newActivity);
                Identity poster = ForumActivityUtils.getIdentity(ctx.getTopic().getOwner());
                ForumActivityUtils.saveTopicActivity(poster, streamOwner, newActivity, ctx.getTopic());
                ForumActivityUtils.removeActivities(ctx.getRemoveActivities());
                return newActivity;
            }
            catch (Exception e) {
                LOG.error((Object)("Can not record Activity for merged topics " + ctx.getTopic().getId()), (Throwable)e);
                return null;
            }
        }
    };
    public static TopicActivityTask SPLIT_TOPIC = new TopicActivityTask(){

        @Override
        public ExoSocialActivity processTitle(ForumActivityContext ctx, ExoSocialActivity activity) {
            return ForumActivityType.SPLIT_TOPIC.getActivity(activity, activity.getTitle());
        }

        @Override
        protected ExoSocialActivity processActivity(ForumActivityContext ctx, ExoSocialActivity activity) {
            return this.processTitle(ctx, activity);
        }

        @Override
        public ExoSocialActivity execute(ForumActivityContext ctx) {
            try {
                Identity streamOwner = this.getOwnerStream(ctx);
                ExoSocialActivity newActivity = ForumActivityBuilder.createActivity(ctx.getTopic(), ctx);
                newActivity = this.processActivity(ctx, newActivity);
                Identity poster = ForumActivityUtils.getIdentity(ctx.getTopic().getOwner());
                ForumActivityUtils.saveTopicActivity(poster, streamOwner, newActivity, ctx.getTopic());
                ExoSocialActivity splitActivity = ForumActivityBuilder.createActivity(ctx.getSplitedTopic(), ctx);
                splitActivity = this.processActivity(ctx, splitActivity);
                poster = ForumActivityUtils.getIdentity(ctx.getSplitedTopic().getOwner());
                if (!"space".equals(streamOwner.getProviderId()) && !ctx.getTopic().getOwner().equals(ctx.getSplitedTopic().getOwner())) {
                    streamOwner = poster;
                }
                ForumActivityUtils.saveTopicActivity(poster, streamOwner, splitActivity, ctx.getSplitedTopic());
                ForumActivityUtils.takeActivityBack(ctx.getSplitedTopic(), splitActivity);
                ForumActivityUtils.removeActivities(ctx.getRemoveActivities());
                return newActivity;
            }
            catch (Exception e) {
                LOG.error((Object)("Can not record Activity for splited topic " + ctx.getTopic().getId()), (Throwable)e);
                return null;
            }
        }
    };
    public static TopicActivityTask UPDATE_FORUM_TOPIC = new TopicActivityTask(){

        @Override
        protected ExoSocialActivity processTitle(ForumActivityContext ctx, ExoSocialActivity activity) {
            return activity;
        }

        @Override
        protected ExoSocialActivity processActivity(ForumActivityContext ctx, ExoSocialActivity activity) {
            Topic topic = ctx.getTopic();
            if (!topic.getIsActiveByForum() || topic.getIsLock()) {
                activity.isLocked(true);
            } else {
                activity.isLocked(false);
            }
            return activity;
        }

        @Override
        public ExoSocialActivity execute(ForumActivityContext ctx) {
            try {
                ActivityManager am = ForumActivityUtils.getActivityManager();
                ExoSocialActivity a = ForumActivityUtils.getActivityOfTopic(ctx);
                a = this.processActivity(ctx, a);
                am.updateActivity(a);
                return a;
            }
            catch (Exception e) {
                LOG.error((Object)("Can not record Activity for when add topic's title " + ctx.getTopic().getId()), (Throwable)e);
                return null;
            }
        }
    };

    protected abstract ExoSocialActivity processTitle(ForumActivityContext var1, ExoSocialActivity var2);

    protected abstract ExoSocialActivity processActivity(ForumActivityContext var1, ExoSocialActivity var2);

    protected ExoSocialActivity processComment(ForumActivityContext ctx) {
        ExoSocialActivity activity = ForumActivityBuilder.createActivityComment(ctx.getTopic(), ctx);
        return this.processTitle(ctx, activity);
    }

    @Override
    public void start(ForumActivityContext ctx) {
    }

    @Override
    public void end(ForumActivityContext ctx) {
    }

    protected Identity getOwnerStream(ForumActivityContext ctx) {
        Identity ownerStream = null;
        Topic topic = ctx.getTopic();
        Identity userIdentity = ForumActivityUtils.getIdentity(topic.getOwner());
        try {
            String[] tab = topic.getPath().split("/");
            String forumId = tab[tab.length - 2];
            if (ForumActivityUtils.hasSpace(forumId)) {
                ownerStream = ForumActivityUtils.getSpaceIdentity(forumId);
            }
            if (ownerStream == null) {
                ownerStream = userIdentity;
            }
            return ownerStream;
        }
        catch (Exception e) {
            LOG.error((Object)("Can not get OwnerStream for topic " + ctx.getTopic().getId()), (Throwable)e);
            return userIdentity;
        }
    }
}

