/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.ext.activity;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.commons.utils.StringCommonUtils;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.TransformHTML;
import org.exoplatform.forum.ext.activity.ForumActivityContext;
import org.exoplatform.forum.ext.activity.ForumActivityUtils;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;

public class ForumActivityBuilder {
    public static final String FORUM_ACTIVITY_TYPE = "ks-forum:spaces";
    public static final String FORUM_ID_KEY = "ForumId";
    public static final String CATE_ID_KEY = "CateId";
    public static final String POST_TYPE = "Post";
    public static final String POST_ID_KEY = "PostId";
    public static final String POST_OWNER_KEY = "PostOwner";
    public static final String POST_LINK_KEY = "PostLink";
    public static final String POST_NAME_KEY = "PostName";
    public static final String TOPIC_ID_KEY = "TopicId";
    public static final String TOPIC_LINK_KEY = "TopicLink";
    public static final String TOPIC_OWNER_KEY = "TopicOwner";
    public static final String TOPIC_POST_COUNT_KEY = "NumberOfReplies";
    public static final String TOPIC_VOTE_RATE_KEY = "TopicVoteRate";
    private static final int NUMBER_CHARS = 430;
    public static final String SPACE_GROUP_ID = "SpaceGroupId";

    private ForumActivityBuilder() {
    }

    public static ExoSocialActivity createActivityComment(Post post, ForumActivityContext ctx) {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        return ForumActivityBuilder.updateActivityComment((ExoSocialActivity)activity, post, ctx);
    }

    public static ExoSocialActivity updateActivityComment(ExoSocialActivity activity, Post post, ForumActivityContext ctx) {
        String message = post.getMessage();
        message = ForumActivityBuilder.getMessageWithoutQuotedPost(post, post.getModifiedBy() != null);
        String title = ForumActivityBuilder.processContent(message, 3);
        activity.setTitle(title);
        activity.setBody(message);
        activity.isComment(true);
        activity.setType(FORUM_ACTIVITY_TYPE);
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put(POST_ID_KEY, post.getId());
        templateParams.put(POST_LINK_KEY, post.getLink());
        templateParams.put(POST_NAME_KEY, post.getName());
        templateParams.put(POST_OWNER_KEY, post.getOwner());
        templateParams.put(FORUM_ID_KEY, post.getForumId());
        templateParams.put(CATE_ID_KEY, post.getCategoryId());
        templateParams.put(TOPIC_ID_KEY, post.getTopicId());
        activity.setTemplateParams(templateParams);
        return activity;
    }

    private static String getMessageWithoutQuotedPost(Post post, boolean edit) {
        String fullName;
        String parentMessage;
        String parentCommentId = post.getQuotedPostId();
        try {
            if (edit) {
                ExoSocialActivity postCommentActivity = ForumActivityUtils.getCommentOfPost(post.getPath());
                if (postCommentActivity != null && postCommentActivity.getParentCommentId() != null) {
                    ExoSocialActivity parentActivity = ForumActivityUtils.getActivityManager().getActivity(postCommentActivity.getParentCommentId());
                    if (parentActivity != null) {
                        parentMessage = parentActivity.getBody();
                        Identity posterIdentity = ForumActivityUtils.getIdentityManager().getIdentity(parentActivity.getPosterId(), true);
                        fullName = posterIdentity.getProfile().getFullName();
                    } else {
                        parentMessage = null;
                        fullName = null;
                    }
                } else {
                    parentMessage = null;
                    fullName = null;
                }
            } else if (parentCommentId != null) {
                Post parentPost = ForumActivityUtils.getForumService().getPost(post.getCategoryId(), post.getForumId(), post.getTopicId(), parentCommentId);
                fullName = ForumActivityUtils.getForumService().getScreenName(parentPost.getOwner());
                parentMessage = parentPost.getMessage();
            } else {
                parentMessage = null;
                fullName = null;
            }
        }
        catch (Exception e) {
            parentMessage = null;
            fullName = null;
        }
        String message = post.getMessage();
        if (parentMessage != null && fullName != null) {
            parentMessage = StringCommonUtils.decodeSpecialCharToHTMLnumber(parentMessage);
            parentMessage = CommonUtils.processBBCode((String)parentMessage);
            parentMessage = TransformHTML.cleanHtmlCode((String)StringEscapeUtils.unescapeHtml((String)TransformHTML.getPlainText((String)parentMessage)), null);
            message = TransformHTML.cleanHtmlCode((String)StringEscapeUtils.unescapeHtml((String)TransformHTML.getPlainText((String)post.getMessage())), null);
            message = message.replaceFirst(fullName + ":((\\r)?(\\n)?( )*)*" + parentMessage + "((\\r)?(\\n)?( )*)*", "").trim();
            message = message.replaceAll("((\\r|\\n)+( )*)+", "<br/>");
        }
        return message;
    }

    public static ExoSocialActivity createActivityComment(Topic topic, ForumActivityContext ctx) {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        String body = ForumActivityBuilder.processContent(topic.getDescription(), 4);
        String title = StringCommonUtils.decodeSpecialCharToHTMLnumber((String)topic.getTopicName());
        activity.setTitle(title);
        activity.setBody(body);
        activity.isComment(true);
        activity.setType(FORUM_ACTIVITY_TYPE);
        return activity;
    }

    public static String decodeHTMLInput(String message) {
        message = StringCommonUtils.decodeSpecialCharToHTMLnumber((String)message);
        String[] tab = TransformHTML.getPlainText((String)message).replaceAll("(?m)^\\s*$[\n\r]{1,}", "").split("\\r?\\n");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tab.length; ++i) {
            sb.append(StringEscapeUtils.unescapeHtml((String)tab[i]));
            sb.append("<br/>");
        }
        return sb.toString();
    }

    public static String processContent(String content, int nbOfLines) {
        content = content.replaceAll("&nbsp;", "");
        String[] tab = TransformHTML.getPlainText((String)content).replaceAll("(?m)^\\s*$[\n\r]{1,}", "").split("\\r?\\n");
        int numberOfLine = Math.min(nbOfLines, tab.length);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numberOfLine; ++i) {
            sb.append(tab[i]);
            if (i >= numberOfLine - 1) continue;
            sb.append("BR_");
        }
        String str = null;
        str = sb.toString().contains("<a target=") ? StringEscapeUtils.escapeHtml((String)sb.toString()).trim() : StringEscapeUtils.unescapeHtml((String)TransformHTML.cleanHtmlCode((String)sb.toString(), null)).trim();
        return ForumActivityBuilder.trunc(str.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("BR_", "<br/>"), 430, tab.length > nbOfLines);
    }

    public static final String trunc(String str, int head, boolean needTail) {
        StringBuffer buf = null;
        buf = new StringBuffer();
        if (str.length() <= head + 7 + str.length() / 10) {
            buf.append(str);
            if (needTail) {
                buf.append("...");
            }
            return buf.toString();
        }
        buf.append(str.substring(0, head)).append("...");
        return buf.toString();
    }

    public static ExoSocialActivity createActivity(Topic topic, ForumActivityContext ctx) {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        String body = ForumActivityBuilder.processContent(topic.getDescription(), 4);
        activity.setTitle(StringCommonUtils.decodeSpecialCharToHTMLnumber((String)topic.getTopicName()));
        activity.setBody(body);
        activity.isComment(false);
        activity.isHidden(!topic.getIsApproved());
        activity.setType(FORUM_ACTIVITY_TYPE);
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put(TOPIC_POST_COUNT_KEY, "" + topic.getPostCount());
        templateParams.put(TOPIC_VOTE_RATE_KEY, "" + topic.getVoteRating());
        templateParams.put(TOPIC_ID_KEY, topic.getId());
        templateParams.put(TOPIC_OWNER_KEY, topic.getOwner());
        templateParams.put(TOPIC_LINK_KEY, CommonUtils.getURI((String)topic.getLink()));
        templateParams.put(FORUM_ID_KEY, topic.getForumId());
        templateParams.put(CATE_ID_KEY, topic.getCategoryId());
        if (ForumActivityUtils.hasSpace(topic.getForumId())) {
            templateParams.put(SPACE_GROUP_ID, ForumActivityUtils.getSpaceGroupId(topic.getForumId()));
        }
        activity.setTemplateParams(templateParams);
        return activity;
    }

    public static ExoSocialActivity updateNumberOfReplies(Topic topic, ExoSocialActivity activity) {
        Map templateParams = activity.getTemplateParams();
        templateParams.put(TOPIC_POST_COUNT_KEY, "" + topic.getPostCount());
        return activity;
    }

    public static ExoSocialActivity updateNumberOfReplies(ExoSocialActivity activity, boolean isDelete) {
        Map templateParams = activity.getTemplateParams();
        int nbReplies = Integer.parseInt((String)templateParams.get(TOPIC_POST_COUNT_KEY));
        if (isDelete) {
            templateParams.put(TOPIC_POST_COUNT_KEY, "" + (nbReplies - 1));
        } else {
            templateParams.put(TOPIC_POST_COUNT_KEY, "" + (nbReplies + 1));
        }
        activity.setTemplateParams(templateParams);
        return activity;
    }

    public static ExoSocialActivity updateVoteRate(Topic topic, ExoSocialActivity activity) {
        Map templateParams = activity.getTemplateParams();
        templateParams.put(TOPIC_VOTE_RATE_KEY, "" + topic.getVoteRating());
        return activity;
    }
}

