/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.ext.impl;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.utils.StringCommonUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.common.webui.WebUIUtils;
import org.exoplatform.forum.ext.activity.BuildLinkUtils;
import org.exoplatform.forum.ext.impl.BaseKSActivity;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.poll.service.Poll;
import org.exoplatform.poll.service.PollService;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/forum/social-integration/plugin/space/PollUIActivity.gtmpl", events={@EventConfig(listeners={BaseUIActivity.LoadLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeCommentActionListener.class})})
public class PollUIActivity
extends BaseKSActivity {
    private String totalOfUsersVote;
    private String totalOfVoters;

    public Map<String, List<String>> getVotes() throws Exception {
        LinkedHashMap<String, List<String>> info = new LinkedHashMap<String, List<String>>();
        String pollId = this.getActivityParamValue("Id");
        if (pollId.indexOf(Utils.TOPIC) == 0) {
            pollId = pollId.replace(Utils.TOPIC, Utils.POLL);
        }
        PollService pollService = (PollService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PollService.class);
        Poll poll = pollService.getPoll(pollId);
        String[] options = poll.getOption();
        String[] userVotes = poll.getUserVote();
        String[] votes = poll.getVote();
        this.setTotalUsersVotes(this.getStringFromNumberOfVotes(Integer.parseInt(poll.getVotes())));
        this.setTotalOfVoters(this.getStringFromNumberOfVoters(userVotes.length));
        int[] votesValues = this.getVotesOfOption(userVotes, options.length);
        for (int i = 0; i < options.length; ++i) {
            LinkedList<String> values = new LinkedList<String>();
            values.add(this.buildPercentVote(votes[i]));
            values.add(this.getStringFromNumberOfVotes(votesValues[i]));
            info.put(StringCommonUtils.decodeSpecialCharToHTMLnumberIgnore((String)options[i]), values);
        }
        return info;
    }

    private String buildPercentVote(String percent) {
        int index = percent.lastIndexOf(".");
        if (index > 0 && index + 2 < percent.length()) {
            percent = percent.substring(0, index + 3);
        }
        return percent;
    }

    public String getTotalUsersVotes() {
        return this.totalOfUsersVote;
    }

    public void setTotalUsersVotes(String totalOfUsersVote) {
        this.totalOfUsersVote = totalOfUsersVote;
    }

    private String getStringFromNumberOfVotes(int nbVotes) {
        if (nbVotes <= 1) {
            return WebUIUtils.getLabel(null, (String)"PollUIActivity.label.vote").replace("{0}", String.valueOf(nbVotes));
        }
        return WebUIUtils.getLabel(null, (String)"PollUIActivity.label.votes").replace("{0}", String.valueOf(nbVotes));
    }

    public String getTotalOfVoters() {
        return this.totalOfVoters;
    }

    public void setTotalOfVoters(String totalOfVoters) {
        this.totalOfVoters = totalOfVoters;
    }

    private String getStringFromNumberOfVoters(int nbVoters) {
        if (nbVoters <= 1) {
            return WebUIUtils.getLabel(null, (String)"PollUIActivity.label.voter").replace("{0}", String.valueOf(nbVoters));
        }
        return WebUIUtils.getLabel(null, (String)"PollUIActivity.label.voters").replace("{0}", String.valueOf(nbVoters));
    }

    private int[] getVotesOfOption(String[] userVotes, int length) {
        int[] tab = new int[length];
        for (String userVote : userVotes) {
            String[] votes = userVote.split(":");
            for (int i = 1; i < votes.length; ++i) {
                int index;
                int n = index = Integer.parseInt(votes[i]);
                tab[n] = tab[n] + 1;
            }
        }
        return tab;
    }

    protected String getLink() {
        String pollId = this.getActivityParamValue("Id");
        String parentPath = this.getActivityParamValue("PollLink");
        if (parentPath.indexOf(Utils.TOPIC) > 0) {
            String topicId = pollId.replace(Utils.POLL, Utils.TOPIC);
            return BuildLinkUtils.buildLink(this.getSpaceGroupId(), topicId, BuildLinkUtils.PORTLET_INFO.FORUM);
        }
        return BuildLinkUtils.buildLink(this.getSpaceGroupId(), pollId, BuildLinkUtils.PORTLET_INFO.POLL);
    }

    public String getSpaceGroupId() {
        return this.getActivityParamValue("SpaceGroupId");
    }
}

