/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.jdbc.listener;

import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NavigationESListenerImpl
extends Listener<NavigationService, SiteKey> {
    private static final Log LOG = ExoLogger.getExoLogger(NavigationESListenerImpl.class);
    private IndexingService indexingService;
    private NavigationService navigationService;

    public NavigationESListenerImpl(IndexingService indexingService, NavigationService navigationService) {
        this.indexingService = indexingService;
        this.navigationService = navigationService;
    }

    public void onEvent(Event<NavigationService, SiteKey> event) throws Exception {
        SiteKey siteKey = (SiteKey)event.getData();
        LOG.debug("Notifying indexing service for navigation={}", new Object[]{siteKey});
        if ("org.exoplatform.portal.mop.navigation.navigation_destroy".equals(event.getEventName())) {
            NavigationContext nav = this.navigationService.loadNavigation(siteKey);
            NodeContext node = this.navigationService.loadNode(NodeModel.SELF_MODEL, nav, Scope.ALL, null);
            this.unIndexTree(node);
        } else if ("org.exoplatform.portal.mop.navigation.navigation_created".equals(event.getEventName())) {
            NavigationContext nav = this.navigationService.loadNavigation(siteKey);
            NodeContext node = this.navigationService.loadNode(NodeModel.SELF_MODEL, nav, Scope.ALL, null);
            this.indexTree(node);
        }
    }

    private void unIndexTree(NodeContext node) {
        this.indexingService.unindex("navigation", node.getId());
        if (node.getNodes() != null) {
            for (Object child : node.getNodes()) {
                this.unIndexTree((NodeContext)child);
            }
        }
    }

    private void indexTree(NodeContext node) {
        this.indexingService.index("navigation", node.getId());
        if (node.getNodes() != null) {
            for (Object child : node.getNodes()) {
                this.indexTree((NodeContext)child);
            }
        }
    }
}

