/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.jdbc.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.jdbc.service.Util;
import org.exoplatform.portal.mop.Described;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.portal.mop.navigation.NavigationData;
import org.exoplatform.portal.mop.navigation.NavigationStore;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.seo.PageMetadataModel;
import org.exoplatform.services.seo.SEOService;
import org.json.JSONException;
import org.json.JSONObject;

public class NavigationIndexingServiceConnector
extends ElasticIndexingServiceConnector {
    private static final Log LOG = ExoLogger.getLogger(NavigationIndexingServiceConnector.class);
    private static final BaseEncodingObjectFormatter formatter = new BaseEncodingObjectFormatter();
    public static final String TYPE = "navigation";
    private NavigationStore navigationStore;
    private SEOService seoService;
    private PageService pageService;
    private DescriptionService descriptionService;

    public NavigationIndexingServiceConnector(InitParams initParams, NavigationStore navigationStore, SEOService seoService, PageService pageService, DescriptionService descriptionService) {
        super(initParams);
        this.navigationStore = navigationStore;
        this.seoService = seoService;
        this.pageService = pageService;
        this.descriptionService = descriptionService;
    }

    public Document create(String nodeId) {
        Map descriptions;
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            throw new IllegalArgumentException("nodeId is mandatory");
        }
        long ts = System.currentTimeMillis();
        NodeData node = this.navigationStore.loadNode(Long.valueOf(Util.parseLong((String)nodeId)));
        if (node == null) {
            LOG.debug("Node with id {} does not exist or has been removed", new Object[]{nodeId});
            return null;
        }
        NavigationData nav = this.navigationStore.loadNavigationData(Long.valueOf(Util.parseLong((String)node.getId())));
        String uri = this.getUri(node);
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("name", node.getName());
        fields.put("nodeId", node.getId());
        fields.put("siteName", nav.getSiteKey().getName());
        fields.put("siteType", nav.getSiteKey().getTypeName());
        String seoMetadata = this.getSEO(node);
        if (seoMetadata != null) {
            fields.put("seo", seoMetadata);
        }
        HashSet permissions = new HashSet();
        PageKey pageKey = node.getState().getPageRef();
        if (pageKey != null) {
            fields.put("pageRef", pageKey.format());
            PageContext page = this.pageService.loadPage(pageKey);
            String pageTitle = page.getState().getDisplayName();
            fields.put("pageTitle", pageTitle);
            permissions.addAll(page.getState().getAccessPermissions());
        }
        if ((descriptions = this.descriptionService.getDescriptions(node.getId())) != null && descriptions.size() > 0) {
            JSONObject json = new JSONObject();
            try {
                for (Locale locale : descriptions.keySet()) {
                    Described.State state = (Described.State)descriptions.get(locale);
                    if (state == null || state.getName() == null || locale.toLanguageTag() == null) continue;
                    json.put(locale.toLanguageTag(), (Object)state.getName());
                }
                fields.put("descriptions", json.toString());
            }
            catch (JSONException ex) {
                LOG.warn((Object)"Error while parsing description field to JSON", (Throwable)ex);
            }
        }
        Date createdDate = new Date();
        Document document = new Document(TYPE, nodeId, uri, createdDate, permissions, fields);
        LOG.debug("page document generated for node={} name={} duration_ms={}", new Object[]{nodeId, node.getName(), System.currentTimeMillis() - ts});
        return document;
    }

    private String getUri(NodeData node) {
        ArrayList<NodeData> nodes = new ArrayList<NodeData>();
        nodes.add(node);
        while (node.getParentId() != null) {
            node = this.navigationStore.loadNode(Long.valueOf(Util.parseLong((String)node.getParentId())));
            nodes.add(0, node);
        }
        nodes.remove(0);
        List paths = nodes.stream().map(n -> n.getName()).collect(Collectors.toList());
        return StringUtils.join(paths, (String)"/");
    }

    private String getSEO(NodeData node) {
        try {
            NavigationData nav = this.navigationStore.loadNavigationData(Long.valueOf(Util.parseLong((String)node.getId())));
            String siteName = formatter.encodeNodeName(null, nav.getSiteKey().getName());
            Map metaModels = this.seoService.getPageMetadatas(node.getId(), siteName);
            if (metaModels != null && metaModels.size() > 0) {
                JSONObject seo = new JSONObject();
                for (String key : metaModels.keySet()) {
                    PageMetadataModel meta = (PageMetadataModel)metaModels.get(key);
                    JSONObject json = new JSONObject();
                    json.put("description", (Object)meta.getDescription());
                    json.put("keywords", (Object)meta.getKeywords());
                    json.put("title", (Object)meta.getTitle());
                    json.put("robotContent", (Object)meta.getRobotsContent());
                    seo.put(key, (Object)json);
                }
                return seo.toString();
            }
        }
        catch (Exception e) {
            LOG.warn("Can not get SEO metadata of node {}, return null", new Object[]{node.getId(), e});
        }
        return null;
    }

    public Document update(String id) {
        return this.create(id);
    }

    public List<String> getAllIds(int offset, int limit) {
        LinkedList<String> ids = new LinkedList<String>();
        ids.addAll(this.getNodes(this.navigationStore.loadNavigations(SiteType.PORTAL)));
        ids.addAll(this.getNodes(this.navigationStore.loadNavigations(SiteType.GROUP)));
        ids.addAll(this.getNodes(this.navigationStore.loadNavigations(SiteType.USER)));
        return ids;
    }

    private Collection<? extends String> getNodes(List<NavigationData> navigations) {
        ArrayList<? extends String> ids = new ArrayList<String>();
        for (NavigationData nav : navigations) {
            ids.addAll(this.getNodes(nav.getRootId()));
        }
        return ids;
    }

    private Collection<? extends String> getNodes(String rootId) {
        ArrayList<? extends String> ids = new ArrayList<String>();
        ids.add(rootId);
        NodeData node = this.navigationStore.loadNode(Long.valueOf(Util.parseLong((String)rootId)));
        Iterator nodes = node.iterator(false);
        while (nodes != null && nodes.hasNext()) {
            String childId = (String)nodes.next();
            ids.addAll(this.getNodes(childId));
        }
        return ids;
    }

    public String getMapping() {
        StringBuilder mapping = new StringBuilder().append("{").append("  \"properties\" : {\n").append("    \"name\" : {").append("      \"type\" : \"text\",").append("      \"index_options\": \"offsets\",").append("      \"fields\": {").append("        \"raw\": {").append("          \"type\": \"keyword\"").append("        }").append("      }").append("    },\n").append("    \"nodeId\" : {\"type\" : \"keyword\"},\n").append("    \"siteName\": {\"type\" : \"keyword\"},\n").append("    \"siteType\": {\"type\" : \"keyword\"},\n").append("    \"pageRef\" : {\"type\" : \"keyword\"},\n").append("    \"pageTitle\" : {\"type\" : \"text\", \"index_options\": \"offsets\"},\n").append("    \"seo\" : {\"type\" : \"text\", \"index_options\": \"offsets\"},\n").append("    \"descriptions\" : {\"type\" : \"text\", \"index_options\": \"offsets\"},\n").append("    \"permissions\" : {\"type\" : \"keyword\"},\n").append("    \"lastUpdatedDate\" : {\"type\" : \"date\", \"format\": \"epoch_millis\"}\n").append("  }\n").append("}");
        return mapping.toString();
    }
}

