/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.doc;

import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.presentation.UIBaseNodePresentation;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;

@ComponentConfig(lifecycle=Lifecycle.class, events={@EventConfig(listeners={DownloadActionListener.class})})
public class UIDocViewer
extends UIBaseNodePresentation {
    private static final Log LOG = ExoLogger.getLogger(UIDocViewer.class);
    private Node originalNode;

    public void setOriginalNode(Node originalNode) {
        this.originalNode = originalNode;
    }

    public Node getOriginalNode() throws Exception {
        return this.originalNode;
    }

    public void setNode(Node node) {
        this.originalNode = node;
    }

    public Node getNode() throws Exception {
        return this.originalNode;
    }

    public String getTemplate() {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        try {
            String nodeType = this.getOriginalNode().getPrimaryNodeType().getName();
            if (templateService.isManagedNodeType(nodeType)) {
                return templateService.getTemplatePathByUser(false, nodeType, userName);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public String getTemplatePath() throws Exception {
        return this.getRepository();
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        String workspace = dmsConfiguration.getConfig().getSystemWorkspace();
        return new JCRResourceResolver(workspace);
    }

    public String getNodeType() {
        return null;
    }

    public boolean isNodeTypeSupported() {
        return false;
    }

    public UIComponent getCommentComponent() {
        return null;
    }

    public UIComponent getRemoveAttach() {
        return null;
    }

    public UIComponent getRemoveComment() {
        return null;
    }

    public UIComponent getUIComponent(String mimeType) throws Exception {
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        List extensions = manager.getUIExtensions("org.exoplatform.ecm.dms.FileViewer");
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("mimeType", mimeType);
        for (UIExtension extension : extensions) {
            UIComponent uiComponent = manager.addUIExtension(extension, context, (UIContainer)this);
            if (uiComponent == null) continue;
            return uiComponent;
        }
        return null;
    }

    public String getRepositoryName() {
        return "repository";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DownloadActionListener
    extends EventListener<UIDocViewer> {
        public void execute(Event<UIDocViewer> event) throws Exception {
            UIDocViewer uiComp = (UIDocViewer)((Object)event.getSource());
            String downloadLink = uiComp.getDownloadLink(Utils.getFileLangNode((Node)uiComp.getNode()));
            event.getRequestContext().getJavascriptManager().addJavascript((CharSequence)("ajaxRedirect('" + downloadLink + "');"));
        }
    }
}

