/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.doc;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.portlet.PortletRequest;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.plugin.doc.UIDocViewer;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.UIActivitiesContainer;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/plugin/doc/UIDocActivity.gtmpl", events={@EventConfig(listeners={DownloadDocumentActionListener.class}), @EventConfig(listeners={ViewDocumentActionListener.class}), @EventConfig(listeners={GotoFolderActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Activity"), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Comment")})
public class UIDocActivity
extends BaseUIActivity {
    private static final Log LOG = ExoLogger.getLogger(UIDocActivity.class);
    private static final String IMAGE_PREFIX = "image/";
    private static final String DOCUMENT_POSTFIX = "/pdf";
    public static final String ACTIVITY_TYPE = "DOC_ACTIVITY";
    public static final String DOCLINK = "DOCLINK";
    public static final String MESSAGE = "MESSAGE";
    public static final String REPOSITORY = "REPOSITORY";
    public static final String WORKSPACE = "WORKSPACE";
    public static final String DOCNAME = "DOCNAME";
    public static final String DOCPATH = "DOCPATH";
    public String docLink;
    public String message;
    public String docName;
    public String docPath;
    private Node docNode;

    public void setDocNode(Node docNode) {
        this.docNode = docNode;
    }

    public Node getDocNode() {
        return this.docNode;
    }

    protected boolean isPreviewable() {
        String mimeType = "";
        try {
            mimeType = this.docNode.getNode("jcr:content").getProperty("jcr:mimeType").getString();
        }
        catch (ValueFormatException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e);
            }
            return false;
        }
        catch (PathNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e);
            }
            return false;
        }
        catch (RepositoryException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e);
            }
            return false;
        }
        return mimeType.endsWith(DOCUMENT_POSTFIX) || mimeType.startsWith(IMAGE_PREFIX);
    }

    protected String getDocThumbnail() {
        String portalContainerName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getRestContextName((String)portalContainerName);
        return new StringBuffer().append("/").append(portalContainerName).append("/").append(restContextName).append("/thumbnailImage/big").append("/").append("repository").append("/").append("collaboration").append(this.docPath).toString();
    }

    public static class GotoFolderActionListener
    extends EventListener<UIDocActivity> {
        public void execute(Event<UIDocActivity> event) throws Exception {
            String folderPath = Utils.getEditLink((Node)((UIDocActivity)((Object)event.getSource())).getDocNode(), (boolean)false, (boolean)false);
            folderPath = folderPath.substring(0, folderPath.lastIndexOf("&amp;"));
            folderPath = folderPath.substring(0, folderPath.lastIndexOf("/"));
            StringBuilder siteExplorerURL = new StringBuilder();
            PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletRequest portletRequest = portletRequestContext.getRequest();
            siteExplorerURL.append(portletRequest.getScheme());
            siteExplorerURL.append("://");
            siteExplorerURL.append(portletRequest.getServerName());
            siteExplorerURL.append(":");
            siteExplorerURL.append(portletRequest.getServerPort());
            siteExplorerURL.append(folderPath);
            event.getRequestContext().getJavascriptManager().addJavascript((CharSequence)(";window.location.href='" + siteExplorerURL.toString() + "';"));
        }
    }

    public static class DownloadDocumentActionListener
    extends EventListener<UIDocActivity> {
        public void execute(Event<UIDocActivity> event) throws Exception {
            UIDocActivity uiComp = (UIDocActivity)((Object)event.getSource());
            String downloadLink = Utils.getDownloadLink((Node)uiComp.getDocNode());
            event.getRequestContext().getJavascriptManager().addJavascript((CharSequence)("ajaxRedirect('" + downloadLink + "');"));
        }
    }

    public static class ViewDocumentActionListener
    extends EventListener<UIDocActivity> {
        public void execute(Event<UIDocActivity> event) throws Exception {
            UIDocActivity docActivity = (UIDocActivity)((Object)event.getSource());
            UIActivitiesContainer activitiesContainer = (UIActivitiesContainer)docActivity.getParent();
            UIPopupWindow popupWindow = activitiesContainer.getPopupWindow();
            if (docActivity.getChild(UIDocViewer.class) != null) {
                docActivity.removeChild(UIDocViewer.class);
            }
            UIDocViewer docViewer = (UIDocViewer)popupWindow.createUIComponent(UIDocViewer.class, null, "DocViewer");
            Node docNode = docActivity.getDocNode();
            docViewer.setOriginalNode(docNode);
            docViewer.setNode(docNode);
            popupWindow.setUIComponent((UIComponent)docViewer);
            popupWindow.setWindowSize(800, 600);
            popupWindow.setShow(true);
            popupWindow.setResizable(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupWindow);
        }
    }
}

