/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.doc;

import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.portlet.PortletRequest;
import org.apache.commons.io.FileUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.jcr.model.VersionNode;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.friendly.FriendlyService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;
import org.exoplatform.social.plugin.doc.UIDocViewer;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.UIActivitiesContainer;
import org.exoplatform.social.webui.composer.PopupContainer;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.cssfile.CssClassManager;
import org.exoplatform.webui.cssfile.CssClassUtils;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/plugin/doc/UIDocActivity.gtmpl", events={@EventConfig(listeners={DownloadDocumentActionListener.class}), @EventConfig(listeners={ViewDocumentActionListener.class}), @EventConfig(listeners={BaseUIActivity.LoadLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class})})
public class UIDocActivity
extends BaseUIActivity {
    private static final Log LOG = ExoLogger.getLogger(UIDocActivity.class);
    private static final String IMAGE_PREFIX = "image/";
    private static final String DOCUMENT_POSTFIX = "/pdf";
    public static final String ACTIVITY_TYPE = "DOC_ACTIVITY";
    public static final String DOCLINK = "DOCLINK";
    public static final String MESSAGE = "MESSAGE";
    public static final String REPOSITORY = "REPOSITORY";
    public static final String WORKSPACE = "WORKSPACE";
    public static final String DOCNAME = "DOCNAME";
    public static final String ID = "id";
    public static final String DOCPATH = "DOCPATH";
    public static final String CONTENT_NAME = "contentName";
    public static final String CONTENT_LINK = "contenLink";
    public static final String IMAGE_PATH = "imagePath";
    public static final String MIME_TYPE = "mimeType";
    public static final String STATE = "state";
    public static final String AUTHOR = "author";
    public static final String DATE_CREATED = "dateCreated";
    public static final String LAST_MODIFIED = "lastModified";
    public static final String DOCUMENT_TYPE_LABEL = "docTypeLabel";
    public static final String DOCUMENT_TITLE = "docTitle";
    public static final String DOCUMENT_VERSION = "docVersion";
    public static final String DOCUMENT_SUMMARY = "docSummary";
    public String docLink;
    public String message;
    public String docName;
    public String docPath;
    public String repository;
    public String workspace;

    protected boolean isPreviewable() {
        return this.getMimeType().endsWith(DOCUMENT_POSTFIX);
    }

    protected boolean isImageFile() {
        return this.getMimeType().startsWith(IMAGE_PREFIX);
    }

    protected String getDocThumbnail() {
        String portalContainerName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getRestContextName((String)portalContainerName);
        return new StringBuffer().append("/").append(portalContainerName).append("/").append(restContextName).append("/thumbnailImage/big").append("/").append("repository").append("/").append("collaboration").append(this.docPath).toString();
    }

    protected String getSize() {
        double size = 0.0;
        Node docNode = this.getDocNode();
        try {
            if (docNode.hasNode("jcr:content")) {
                Node contentNode = docNode.getNode("jcr:content");
                if (contentNode.hasProperty("jcr:data")) {
                    size = contentNode.getProperty("jcr:data").getLength();
                }
                return FileUtils.byteCountToDisplaySize((long)((long)size));
            }
        }
        catch (PathNotFoundException e) {
            return "";
        }
        catch (ValueFormatException e) {
            return "";
        }
        catch (RepositoryException e) {
            return "";
        }
        return "";
    }

    protected int getVersion() {
        try {
            VersionNode rootVersion_ = new VersionNode(NodeLocation.getNodeByLocation((NodeLocation)new NodeLocation(this.repository, this.workspace, this.docPath)).getVersionHistory().getRootVersion(), this.getDocNode().getSession());
            if (rootVersion_ != null) {
                return rootVersion_.getChildren().size();
            }
        }
        catch (Exception e) {
            LOG.info((Object)"cannot version node");
        }
        return 0;
    }

    protected String getCssClassIconFile(String fileName, String fileType) {
        String cssClass = CssClassUtils.getCSSClassByFileNameAndFileType((String)fileName, (String)fileType, (CssClassManager.ICON_SIZE)CssClassManager.ICON_SIZE.ICON_64);
        if (cssClass.indexOf("FileDefault") > 0) {
            return "uiIcon64x64Templatent_file uiIcon64x64nt_file";
        }
        return cssClass;
    }

    protected boolean isDisplayThumbnail(String mimeType) {
        return mimeType.startsWith("application/pdf") || mimeType.startsWith("application/msword") || mimeType.startsWith("application/vnd.oasis.opendocument.text") || mimeType.startsWith("application/vnd.openxmlformats-officedocument.wordprocessingml.document") || mimeType.startsWith("application/rtf");
    }

    private boolean hasPermissionViewFile() {
        return this.getDocNode() != null;
    }

    protected Node getDocNode() {
        NodeLocation nodeLocation = new NodeLocation(this.repository, this.workspace, this.docPath);
        return NodeLocation.getNodeByLocation((NodeLocation)nodeLocation);
    }

    public String getWebdavURL() throws Exception {
        Node contentNode = this.getDocNode();
        NodeLocation nodeLocation = new NodeLocation(this.repository, this.workspace, this.docPath);
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequest portletRequest = portletRequestContext.getRequest();
        String repository = nodeLocation.getRepository();
        String workspace = nodeLocation.getWorkspace();
        String baseURI = portletRequest.getScheme() + "://" + portletRequest.getServerName() + ":" + String.format("%s", portletRequest.getServerPort());
        FriendlyService friendlyService = (FriendlyService)WCMCoreUtils.getService(FriendlyService.class);
        String link = "#";
        String portalName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getCurrentRestContextName();
        if (contentNode.isNodeType("nt:frozenNode")) {
            String uuid = contentNode.getProperty("jcr:frozenUuid").getString();
            Node originalNode = contentNode.getSession().getNodeByUUID(uuid);
            link = baseURI + "/" + portalName + "/" + restContextName + "/jcr/" + repository + "/" + workspace + originalNode.getPath() + "?version=" + contentNode.getParent().getName();
        } else {
            link = baseURI + "/" + portalName + "/" + restContextName + "/jcr/" + repository + "/" + workspace + contentNode.getPath();
        }
        return friendlyService.getFriendlyUri(link);
    }

    public String getSummary() {
        String desc;
        block6: {
            desc = "";
            Node node = this.getDocNode();
            try {
                if (node != null) {
                    Node content;
                    if (node.hasProperty("exo:summary")) {
                        desc = node.getProperty("exo:summary").getValue().getString();
                    } else if (node.hasNode("jcr:content") && (content = node.getNode("jcr:content")).hasProperty("dc:description") && content.getProperty("dc:description").getValues().length > 0) {
                        desc = content.getProperty("dc:description").getValues()[0].getString();
                    }
                }
            }
            catch (RepositoryException re) {
                if (!LOG.isWarnEnabled()) break block6;
                LOG.warn((Object)"RepositoryException: ", (Throwable)re);
            }
        }
        return desc;
    }

    public String getTitle() throws Exception {
        return Utils.getTitle((Node)this.getDocNode());
    }

    public static String getActivityOwnerId(Node node) {
        String activityOwnerId = "";
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            activityOwnerId = conversationState.getIdentity().getUserId();
        } else {
            try {
                activityOwnerId = node.getProperty("publication:lastUser").getString();
            }
            catch (Exception e) {
                LOG.info((Object)"No lastUser publication");
            }
        }
        return activityOwnerId;
    }

    public static String getIllustrativeImage(Node node) {
        WebSchemaConfigService schemaConfigService = (WebSchemaConfigService)WCMCoreUtils.getService(WebSchemaConfigService.class);
        WebContentSchemaHandler contentSchemaHandler = (WebContentSchemaHandler)schemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
        Node illustrativeImage = null;
        String uri = "";
        try {
            illustrativeImage = contentSchemaHandler.getIllustrationImage(node);
            uri = UIDocActivity.generateThumbnailImageURI(illustrativeImage);
        }
        catch (PathNotFoundException ex) {
            return uri;
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        return uri;
    }

    public static String generateThumbnailImageURI(Node file) throws Exception {
        StringBuilder builder = new StringBuilder();
        NodeLocation fielLocation = NodeLocation.getNodeLocationByNode((Node)file);
        String repository = fielLocation.getRepository();
        String workspaceName = fielLocation.getWorkspace();
        String nodeIdentifiler = file.getPath().replaceFirst("/", "");
        String portalName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getCurrentRestContextName();
        InputStream stream = file.getNode("jcr:content").getProperty("jcr:data").getStream();
        if (stream.available() == 0) {
            return null;
        }
        stream.close();
        builder.append("/").append(portalName).append("/").append(restContextName).append("/").append("thumbnailImage/medium/").append(repository).append("/").append(workspaceName).append("/").append(nodeIdentifiler);
        return builder.toString();
    }

    public static String getContentLink(Node node) throws RepositoryException {
        String repository = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName();
        String workspace = node.getSession().getWorkspace().getName();
        return repository + '/' + workspace + node.getPath();
    }

    public static String getMimeType(Node node) {
        try {
            if (node.getPrimaryNodeType().getName().equals("nt:file") && node.hasNode("jcr:content")) {
                return node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return "";
    }

    private String getMimeType() {
        String mimeType = "";
        try {
            mimeType = this.getDocNode().getNode("jcr:content").getProperty("jcr:mimeType").getString();
        }
        catch (ValueFormatException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e);
            }
            return "";
        }
        catch (PathNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e);
            }
            return "";
        }
        catch (RepositoryException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e);
            }
            return "";
        }
        return mimeType;
    }

    public static class DownloadDocumentActionListener
    extends EventListener<UIDocActivity> {
        public void execute(Event<UIDocActivity> event) throws Exception {
            UIDocActivity uiComp = (UIDocActivity)((Object)event.getSource());
            if (!uiComp.hasPermissionViewFile()) {
                WebuiRequestContext ctx = event.getRequestContext();
                UIApplication uiApplication = ctx.getUIApplication();
                uiApplication.addMessage(new ApplicationMessage("UIDocActivity.msg.noPermission", null, 1));
                return;
            }
            String downloadLink = null;
            if (this.getRealNode(uiComp.getDocNode()).getPrimaryNodeType().getName().equals("nt:file")) {
                downloadLink = Utils.getDownloadRestServiceLink((Node)uiComp.getDocNode());
            }
            event.getRequestContext().getJavascriptManager().addJavascript((CharSequence)("ajaxRedirect('" + downloadLink + "');"));
        }

        private Node getRealNode(Node node) throws Exception {
            if (node.isNodeType("nt:frozenNode")) {
                String uuid = node.getProperty("jcr:frozenUuid").getString();
                return node.getSession().getNodeByUUID(uuid);
            }
            return node;
        }
    }

    public static class ViewDocumentActionListener
    extends EventListener<UIDocActivity> {
        public void execute(Event<UIDocActivity> event) throws Exception {
            UIDocActivity docActivity = (UIDocActivity)((Object)event.getSource());
            if (!docActivity.hasPermissionViewFile()) {
                WebuiRequestContext ctx = event.getRequestContext();
                UIApplication uiApplication = ctx.getUIApplication();
                uiApplication.addMessage(new ApplicationMessage("UIDocActivity.msg.noPermission", null, 1));
                return;
            }
            UIActivitiesContainer activitiesContainer = (UIActivitiesContainer)docActivity.getParent();
            PopupContainer popupContainer = activitiesContainer.getPopupContainer();
            if (docActivity.getChild(UIDocViewer.class) != null) {
                docActivity.removeChild(UIDocViewer.class);
            }
            UIDocViewer docViewer = (UIDocViewer)popupContainer.createUIComponent(UIDocViewer.class, null, "DocViewer");
            docViewer.docPath = docActivity.docPath;
            docViewer.repository = docActivity.repository;
            docViewer.workspace = docActivity.workspace;
            popupContainer.activate((UIComponent)docViewer, 800, 600, true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupContainer);
        }
    }
}

