/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.doc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.plugin.doc.ComposerFileItem;
import org.exoplatform.social.plugin.doc.UIAbstractSelectFileComposer;
import org.exoplatform.social.plugin.doc.UIDocActivityPopup;
import org.exoplatform.social.plugin.doc.selector.UIComposerMultiUploadSelector;
import org.exoplatform.social.webui.composer.PopupContainer;
import org.exoplatform.social.webui.composer.UIActivityComposer;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.social.webui.profile.UIUserActivitiesDisplay;
import org.exoplatform.wcm.connector.fckeditor.DriverConnector;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(template="classpath:groovy/social/plugin/doc/UIDocActivityComposer.gtmpl", events={@EventConfig(listeners={UIActivityComposer.CloseActionListener.class}), @EventConfig(listeners={UIActivityComposer.SubmitContentActionListener.class}), @EventConfig(listeners={UIActivityComposer.ActivateActionListener.class}), @EventConfig(listeners={SelectDocumentActionListener.class}), @EventConfig(listeners={RemoveDocumentActionListener.class})})
public class UIDocActivityComposer
extends UIActivityComposer
implements UISelectable {
    private static final Log LOG = ExoLogger.getLogger(UIDocActivityComposer.class);
    public static final String REPOSITORY = "repository";
    public static final String WORKSPACE = "collaboration";
    protected static final String UI_COMPOSER_MULTIUPLOAD = "UIComposerMultiUpload";
    private static final String FILE_SPACES = "files:spaces";
    private static final String POPUP_COMPOSER = "UIPopupComposer";
    private final String docActivityTitle = "<a href=\"${DOCLINK}\">${DOCNAME}</a>";
    private SpaceService spaceService;
    private IdentityManager identityManager;
    private ActivityManager activityManager;
    private List<ComposerFileItem> selectedFileItems = new ArrayList<ComposerFileItem>();
    private String currentUser;
    private int maxFilesCount = 20;
    private int maxFileSize = 5;
    private int filesCounter = 5;
    private boolean duplicatedFilesSelection = false;
    private List<String> duplicatedFileNames = new ArrayList<String>();
    private Map<String, UIAbstractSelectFileComposer> uiFileSelectors = new HashMap<String, UIAbstractSelectFileComposer>();

    public UIDocActivityComposer() throws Exception {
        String maxFileSizeString;
        DriverConnector driverConnector = (DriverConnector)this.getApplicationComponent(DriverConnector.class);
        String maxFilesCountString = PropertyManager.getProperty((String)"exo.social.composer.maxToUpload");
        if (StringUtils.isNotBlank((String)maxFilesCountString)) {
            this.maxFilesCount = Integer.parseInt(maxFilesCountString);
        }
        this.maxFileSize = StringUtils.isNotBlank((String)(maxFileSizeString = PropertyManager.getProperty((String)"exo.social.composer.maxFileSizeInMB"))) ? Integer.parseInt(maxFileSizeString) : driverConnector.getLimitSize();
        this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        this.identityManager = (IdentityManager)this.getApplicationComponent(IdentityManager.class);
        this.activityManager = (ActivityManager)this.getApplicationComponent(ActivityManager.class);
        this.addChild((UIComponent)new UIFormStringInput("InputDoc", "InputDoc", null));
        UIComposerMultiUploadSelector uiMultiUpload = (UIComposerMultiUploadSelector)this.addChild(UIComposerMultiUploadSelector.class, null, "ComposerMultiUploadImportTab");
        uiMultiUpload.init(this.maxFilesCount, this.maxFileSize);
        this.uiFileSelectors.put(uiMultiUpload.getId(), uiMultiUpload);
        this.resetValues();
    }

    public boolean isReadyForPostingActivity() {
        return !this.getSelectedFileItems().isEmpty();
    }

    public int getAndIncrementFilesCounter() {
        return this.filesCounter++;
    }

    private void resetValues() {
        this.selectedFileItems.clear();
        for (UIAbstractSelectFileComposer selectFileComposer : this.getUIFileSelectors().values()) {
            selectFileComposer.resetSelection();
        }
        this.setReadyForPostingActivity(false);
    }

    public String getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(String currentUser) {
        this.currentUser = currentUser;
    }

    protected void onActivate(Event<UIActivityComposer> event) {
        this.setCurrentUser(event.getRequestContext().getRemoteUser());
    }

    protected void onClose(Event<UIActivityComposer> event) {
        this.resetValues();
    }

    protected void onSubmit(Event<UIActivityComposer> event) {
    }

    public void onPostActivity(UIComposer.PostContext postContext, UIComponent source, WebuiRequestContext requestContext, String postedMessage) throws Exception {
    }

    public ExoSocialActivity onPostActivity(UIComposer.PostContext postContext, String postedMessage) throws Exception {
        ExoSocialActivity activity = null;
        if (!this.isReadyForPostingActivity()) {
            ((UIPortletApplication)this.getAncestorOfType(UIPortletApplication.class)).addMessage(new ApplicationMessage("UIComposer.msg.error.Must_select_file", null, 2));
        } else {
            UIAbstractSelectFileComposer uiSelectFileComposer;
            LinkedHashMap<String, String> activityParams = new LinkedHashMap<String, String>();
            ArrayList<ComposerFileItem> selectedFileItemsList = new ArrayList<ComposerFileItem>(this.getSelectedFileItems());
            Collections.sort(selectedFileItemsList);
            for (ComposerFileItem composerFileItem : selectedFileItemsList) {
                uiSelectFileComposer = this.getResolver(composerFileItem.getResolverType());
                Object obj = uiSelectFileComposer.preActivitySave(composerFileItem, postContext);
                uiSelectFileComposer.putActivityParams(obj, composerFileItem, activityParams);
            }
            activityParams.put("MESSAGE", postedMessage);
            if (postContext == UIComposer.PostContext.SPACE) {
                Space space = this.spaceService.getSpaceByUrl(SpaceUtils.getSpaceUrlByContext());
                Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
                activity = this.saveActivity(activityParams, this.identityManager, spaceIdentity);
            } else if (postContext == UIComposer.PostContext.USER) {
                activity = this.postActivityToUser(activityParams);
            }
            for (ComposerFileItem composerFileItem : selectedFileItemsList) {
                uiSelectFileComposer = this.getResolver(composerFileItem.getResolverType());
                uiSelectFileComposer.postActivitySave(composerFileItem, postContext, activity);
            }
        }
        this.resetValues();
        return activity;
    }

    public Map<String, UIAbstractSelectFileComposer> getUIFileSelectors() {
        return this.uiFileSelectors;
    }

    private UIAbstractSelectFileComposer getResolver(String resolverType) {
        if (resolverType == null) {
            return null;
        }
        UIAbstractSelectFileComposer uiSelectFileComposer = null;
        for (UIAbstractSelectFileComposer uiFileSelector : this.uiFileSelectors.values()) {
            if (!StringUtils.equals((String)uiFileSelector.getResolverType(), (String)resolverType)) continue;
            uiSelectFileComposer = uiFileSelector;
            break;
        }
        return uiSelectFileComposer;
    }

    private ExoSocialActivity postActivityToUser(Map<String, String> activityParams) throws Exception {
        String ownerName = ((UIUserActivitiesDisplay)this.getActivityDisplay()).getOwnerName();
        IdentityManager identityManager = (IdentityManager)this.getApplicationComponent(IdentityManager.class);
        Identity ownerIdentity = identityManager.getOrCreateIdentity("organization", ownerName, true);
        return this.saveActivity(activityParams, identityManager, ownerIdentity);
    }

    public void doSelect(String selectField, Object value) throws Exception {
        if (StringUtils.isEmpty((String)selectField) || !selectField.equals("FILE_ITEMS")) {
            LOG.warn((Object)"No selection is not retrieved with expected type");
            return;
        }
        Set selectedComposerChildItems = (Set)value;
        HashSet duplicatedItems = new HashSet(selectedComposerChildItems);
        duplicatedItems.retainAll(this.selectedFileItems);
        for (Object composerFileItem : duplicatedItems) {
            this.addDuplicatedFileName(((ComposerFileItem)composerFileItem).getName());
        }
        selectedComposerChildItems.removeAll(this.selectedFileItems);
        int remainingFilesToSelect = this.getRemainingFilesToSelect();
        if (remainingFilesToSelect >= selectedComposerChildItems.size()) {
            for (ComposerFileItem composerFileItem : selectedComposerChildItems) {
                if (this.selectedFileItems.contains(composerFileItem)) continue;
                this.selectedFileItems.add(composerFileItem);
            }
        } else {
            ArrayList selectedItemList = new ArrayList(selectedComposerChildItems);
            List subList = selectedItemList.subList(0, remainingFilesToSelect);
            this.selectedFileItems.addAll(subList);
        }
        Collections.sort(this.selectedFileItems);
    }

    public boolean testAndSetMaxCountReached(boolean duplicated) {
        if (this.duplicatedFilesSelection) {
            this.duplicatedFilesSelection = duplicated;
            return true;
        }
        this.duplicatedFilesSelection = duplicated;
        return false;
    }

    public boolean hasDuplicatedFilesInSelection() {
        return !this.duplicatedFileNames.isEmpty();
    }

    public void addDuplicatedFileName(String duplicatedFileName) {
        this.duplicatedFileNames.add(duplicatedFileName);
    }

    public String getAndClearDuplicatedFiles() {
        String duplicatedFiles = StringUtils.join(this.duplicatedFileNames, (String)",");
        this.duplicatedFileNames.clear();
        return duplicatedFiles;
    }

    public void removeFileItem(ComposerFileItem fileItem) {
        for (UIAbstractSelectFileComposer selectFileComposer : this.uiFileSelectors.values()) {
            selectFileComposer.removeFile(fileItem);
        }
        this.selectedFileItems.remove(fileItem);
    }

    public List<ComposerFileItem> getSelectedFileItems() {
        return this.getSelectedFileItems(true);
    }

    public List<ComposerFileItem> getSelectedFileItems(boolean computeFromSelectors) {
        if (computeFromSelectors) {
            for (UIAbstractSelectFileComposer selectFileComposer : this.uiFileSelectors.values()) {
                Set<ComposerFileItem> selectFiles = selectFileComposer.getSelectFiles();
                if (selectFiles == null || selectFiles.isEmpty()) continue;
                for (ComposerFileItem composerFileItem : selectFiles) {
                    if (this.selectedFileItems.contains(composerFileItem)) continue;
                    this.selectedFileItems.add(composerFileItem);
                }
                Collections.sort(this.selectedFileItems);
            }
        }
        return this.selectedFileItems;
    }

    private ExoSocialActivity saveActivity(Map<String, String> activityParams, IdentityManager identityManager, Identity ownerIdentity) throws RepositoryException {
        String activity_type = FILE_SPACES;
        String remoteUser = ConversationState.getCurrent().getIdentity().getUserId();
        Identity userIdentity = identityManager.getOrCreateIdentity("organization", remoteUser, true);
        String title = activityParams.get("MESSAGE");
        if (title == null || title.length() == 0) {
            title = "<a href=\"${DOCLINK}\">${DOCNAME}</a>";
        }
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl(userIdentity.getId(), activity_type, title, null);
        activity.setTemplateParams(activityParams);
        this.activityManager.saveActivityNoReturn(ownerIdentity, (ExoSocialActivity)activity);
        return this.activityManager.getActivity(activity.getId());
    }

    protected Node getDocNode(String repository, String workspace, String docPath) {
        NodeLocation nodeLocation = new NodeLocation(repository, workspace, docPath);
        return NodeLocation.getNodeByLocation((NodeLocation)nodeLocation);
    }

    public int getRemainingFilesToSelect() {
        return this.getMaxUploadCount() - this.getSelectedFileItems().size();
    }

    public int getMaxUploadCount() {
        return this.maxFilesCount;
    }

    protected void clearComposerData() {
        this.resetValues();
    }

    public int getLimitFileSize() {
        return this.maxFileSize;
    }

    public static class RemoveDocumentActionListener
    extends EventListener<UIDocActivityComposer> {
        public void execute(Event<UIDocActivityComposer> event) throws Exception {
            UIDocActivityComposer docActivityComposer = (UIDocActivityComposer)((Object)event.getSource());
            String selectedId = event.getRequestContext().getRequestParameter("objectId");
            List<ComposerFileItem> selectedFileItems = docActivityComposer.getSelectedFileItems(false);
            Iterator<ComposerFileItem> iterator = selectedFileItems.iterator();
            while (iterator.hasNext()) {
                ComposerFileItem composerFileItem = iterator.next();
                if (!composerFileItem.getId().equals(selectedId)) continue;
                iterator.remove();
                for (UIAbstractSelectFileComposer uiAbstractSelectFileComposer : docActivityComposer.getUIFileSelectors().values()) {
                    uiAbstractSelectFileComposer.removeFile(composerFileItem);
                }
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)docActivityComposer);
        }
    }

    public static class SelectDocumentActionListener
    extends EventListener<UIDocActivityComposer> {
        public void execute(Event<UIDocActivityComposer> event) throws Exception {
            UIDocActivityComposer docActivityComposer = (UIDocActivityComposer)((Object)event.getSource());
            PopupContainer popupContainer = (PopupContainer)((UIPortletApplication)docActivityComposer.getAncestorOfType(UIPortletApplication.class)).findFirstComponentOfType(PopupContainer.class);
            UIDocActivityPopup uiDocActivityPopup = (UIDocActivityPopup)popupContainer.createUIComponent(UIDocActivityPopup.class, null, null);
            popupContainer.activate((UIComponent)uiDocActivityPopup, 570, 0, false, UIDocActivityComposer.POPUP_COMPOSER);
            for (UIAbstractSelectFileComposer uiSelector : uiDocActivityPopup.getUIFileSelectors()) {
                docActivityComposer.getUIFileSelectors().put(uiSelector.getId(), uiSelector);
            }
            uiDocActivityPopup.setMaxFilesCount(docActivityComposer.getRemainingFilesToSelect());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupContainer);
        }
    }
}

