/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.doc.selector;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.plugin.doc.ComposerFileItem;
import org.exoplatform.social.plugin.doc.UIAbstractSelectFileComposer;
import org.exoplatform.social.plugin.doc.UIDocActivityComposer;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.cssfile.CssClassManager;
import org.exoplatform.webui.cssfile.CssClassUtils;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.input.UIUploadInput;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIContainerLifecycle.class), @ComponentConfig(type=UIUploadInput.class, id="UIMultiUploadInput", template="classpath:/groovy/social/plugin/doc/selector/UIMultiUploadSelectorInput.gtmpl", events={@EventConfig(listeners={SelectUploadIdActionListener.class}), @EventConfig(listeners={UIUploadInput.CreateUploadIdActionListener.class}), @EventConfig(listeners={UIUploadInput.RemoveUploadIdActionListener.class})})})
public class UIComposerMultiUploadSelector
extends UIAbstractSelectFileComposer {
    public static final String UI_MULTI_UPLOAD_INPUT = "UIMultiUploadInput";
    private static final Log LOG = ExoLogger.getLogger(UIComposerMultiUploadSelector.class);
    private static final String UPLOAD_RESOLVER_TYPE = "UPLOAD";
    private static final String PUBLIC_ALIAS = "userPublic";
    private static final String FOLDER_UPLOAD_PARENT_NAME = "Activity Stream Documents";
    public static final String CONTAINER_ID = "ComposerMultiUploadImportTab";
    private String title;
    private int maxFileSize;
    private int maxFileCount;
    private UIUploadInput uiUploadInput;
    private SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);

    public UIComposerMultiUploadSelector() throws Exception {
        this.setId(CONTAINER_ID);
    }

    public void init(int limitFilesCount, int maxUploadSize) {
        this.maxFileCount = limitFilesCount;
        this.maxFileSize = maxUploadSize;
        this.resetSelection();
    }

    @Override
    public void resetSelection() {
        if (this.uiUploadInput != null) {
            this.removeChild(UIUploadInput.class);
        }
        this.uiUploadInput = new UIUploadInput(UI_MULTI_UPLOAD_INPUT, UI_MULTI_UPLOAD_INPUT, this.maxFileCount, this.maxFileSize){

            public String getTemplate() {
                return "classpath:/groovy/social/plugin/doc/selector/UIMultiUploadSelectorInput.gtmpl";
            }
        };
        this.uiUploadInput.setComponentConfig(UIUploadInput.class, UI_MULTI_UPLOAD_INPUT);
        this.addChild((UIComponent)this.uiUploadInput);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        this.renderChildren();
    }

    public UIUploadInput getUIUploadInput() {
        return this.uiUploadInput;
    }

    public int getLimitFileSize() {
        return this.maxFileSize;
    }

    public int getMaxUploadCount() {
        return this.maxFileCount;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public Set<ComposerFileItem> getSelectFiles() {
        String[] uploadIds = this.uiUploadInput.getUploadIds();
        if (uploadIds == null || uploadIds.length == 0) {
            return Collections.emptySet();
        }
        HashSet<ComposerFileItem> fileItems = new HashSet<ComposerFileItem>();
        for (String uploadId : uploadIds) {
            UploadResource uploadedResource = this.uiUploadInput.getUploadResource(uploadId);
            if (uploadedResource == null || uploadedResource.getStatus() == 2 || uploadedResource.getStatus() == 0 && uploadedResource.getEstimatedSize() != uploadedResource.getUploadedSize()) continue;
            ComposerFileItem fileItem = new ComposerFileItem();
            fileItem.setId(uploadId);
            fileItem.setTitle(uploadedResource.getFileName());
            fileItem.setName(uploadedResource.getFileName());
            fileItem.setMimeType(uploadedResource.getMimeType());
            fileItem.setNodeIcon(this.getFileTypeCSSClass(fileItem.getName(), fileItem.getMimeType(), CssClassManager.ICON_SIZE.ICON_64));
            double fileSize = uploadedResource.getUploadedSize();
            fileItem.setSizeInBytes(fileSize);
            String mbString = "MB";
            try {
                ResourceBundle resourceBundle = WebuiRequestContext.getCurrentInstance().getApplicationResourceBundle();
                mbString = resourceBundle.getString("UIComposerDocumentExtension.label.megabyte");
            }
            catch (Exception resourceBundle) {
                // empty catch block
            }
            String fileSizeMB = (double)((int)(Math.abs(fileSize / 1048576.0) * 100.0)) / 100.0 + " " + mbString;
            fileItem.setSize(fileSizeMB);
            fileItem.setResolverType(UPLOAD_RESOLVER_TYPE);
            fileItems.add(fileItem);
        }
        return fileItems;
    }

    public String getFileTypeCSSClass(String fileName, String mimeType, CssClassManager.ICON_SIZE iconSize) {
        String cssClass = CssClassUtils.getCSSClassByFileNameAndFileType((String)fileName, (String)mimeType, (CssClassManager.ICON_SIZE)iconSize).replace("uiIcon", "uiBgd");
        return cssClass;
    }

    @Override
    public String getResolverType() {
        return UPLOAD_RESOLVER_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object preActivitySave(Object resource, UIComposer.PostContext postContext) throws Exception {
        if (!(resource instanceof ComposerFileItem)) {
            return null;
        }
        if (!postContext.equals((Object)UIComposer.PostContext.SPACE) && !postContext.equals((Object)UIComposer.PostContext.USER)) {
            LOG.warn((Object)("PostContext '" + postContext + "' is not supported "));
            return null;
        }
        ComposerFileItem fileItem = (ComposerFileItem)resource;
        String uploadId = fileItem.getId();
        UploadResource uploadedResource = this.uiUploadInput.getUploadResource(uploadId);
        if (uploadedResource == null) {
            LOG.warn("Cannot proceed uploaded file {}, it may not exists", new Object[]{fileItem.getTitle()});
        }
        ActivityCommonService activityService = (ActivityCommonService)WCMCoreUtils.getService(ActivityCommonService.class);
        Node parentNode = null;
        RepositoryService repoService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)WCMCoreUtils.getService(NodeHierarchyCreator.class);
        SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
        ManageableRepository currentRepository = repoService.getCurrentRepository();
        String workspaceName = currentRepository.getConfiguration().getDefaultWorkspaceName();
        Session session = sessionProvider.getSession(workspaceName, currentRepository);
        if (postContext.equals((Object)UIComposer.PostContext.SPACE)) {
            Space space = this.spaceService.getSpaceByUrl(SpaceUtils.getSpaceUrlByContext());
            String groupPath = nodeHierarchyCreator.getJcrPath("groupsPath");
            String spaceParentPath = groupPath + space.getGroupId() + "/Documents";
            if (!session.itemExists(spaceParentPath)) {
                throw new IllegalStateException("Root node of space '" + spaceParentPath + "' doesn't exist");
            }
            parentNode = (Node)session.getItem(spaceParentPath);
        } else if (postContext.equals((Object)UIComposer.PostContext.USER)) {
            String remoteUser = Util.getPortalRequestContext().getRemoteUser();
            if (StringUtils.isBlank((String)remoteUser)) {
                throw new IllegalStateException("Remote user is empty");
            }
            Node userNode = nodeHierarchyCreator.getUserNode(sessionProvider, remoteUser);
            String publicPath = nodeHierarchyCreator.getJcrPath(PUBLIC_ALIAS);
            if (userNode == null || !userNode.hasNode(publicPath)) {
                throw new IllegalStateException("User '" + remoteUser + "' hasn't public folder");
            }
            parentNode = userNode.getNode(publicPath);
        }
        if (!parentNode.hasNode(FOLDER_UPLOAD_PARENT_NAME)) {
            parentNode.addNode(FOLDER_UPLOAD_PARENT_NAME);
            session.save();
        }
        Node parentUploadNode = parentNode.getNode(FOLDER_UPLOAD_PARENT_NAME);
        Node node = parentUploadNode.addNode(Utils.cleanName((String)fileItem.getName()), "nt:file");
        node.setProperty("exo:title", fileItem.getName());
        activityService.setCreating(node, true);
        Node resourceNode = node.addNode("jcr:content", "nt:resource");
        resourceNode.setProperty("jcr:mimeType", fileItem.getMimeType());
        resourceNode.setProperty("jcr:lastModified", Calendar.getInstance());
        String fileDiskLocation = uploadedResource.getStoreLocation();
        try (FileInputStream inputStream = null;){
            inputStream = new FileInputStream(fileDiskLocation);
            resourceNode.setProperty("jcr:data", (InputStream)inputStream);
            session.save();
            node = (Node)session.getItem(node.getPath());
        }
        activityService.setCreating(node, false);
        fileItem.setPath(node.getPath());
        return node;
    }

    @Override
    public void postActivitySave(Object obj, UIComposer.PostContext postContext, ExoSocialActivity activity) throws Exception {
        ComposerFileItem fileItem;
        if (obj instanceof ComposerFileItem && !StringUtils.isBlank((String)(fileItem = (ComposerFileItem)obj).getPath())) {
            UploadService uploadService = (UploadService)this.getApplicationComponent(UploadService.class);
            uploadService.removeUploadResource(fileItem.getId());
            SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
            RepositoryService repoService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
            ManageableRepository currentRepository = repoService.getCurrentRepository();
            String workspaceName = currentRepository.getConfiguration().getDefaultWorkspaceName();
            Session session = sessionProvider.getSession(workspaceName, currentRepository);
            obj = (Node)session.getItem(fileItem.getPath());
        }
        super.postActivitySave(obj, postContext, activity);
    }

    @Override
    protected void removeSelectedFile(ComposerFileItem fileItem) {
        UploadService service = (UploadService)this.getApplicationComponent(UploadService.class);
        service.removeUploadResource(fileItem.getId());
    }

    public static class SelectUploadIdActionListener
    extends EventListener<UIUploadInput> {
        public void execute(Event<UIUploadInput> event) throws Exception {
            UIUploadInput uiUploadInput = (UIUploadInput)event.getSource();
            UIComposerMultiUploadSelector multiUploadSelector = (UIComposerMultiUploadSelector)uiUploadInput.getParent();
            UIDocActivityComposer activityComposer = (UIDocActivityComposer)multiUploadSelector.getParent();
            activityComposer.getSelectedFileItems(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiUploadInput);
        }
    }
}

