/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.doc;

import java.io.Serializable;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.social.plugin.doc.selector.BreadcrumbLocation;

public class ComposerFileItem
implements Serializable,
Comparable<ComposerFileItem> {
    private static final long serialVersionUID = -290642886983269011L;
    private static long sharedIndice;
    private String name;
    private String title;
    private String id;
    private String mimeType;
    private String nodeIcon;
    private String link;
    private String size;
    private String path;
    private double sizeInBytes;
    private String resolverType;
    private long indice;
    private transient BreadcrumbLocation destinationLocation;

    public ComposerFileItem() {
        this.setIndice(sharedIndice++);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public double getSizeInBytes() {
        return this.sizeInBytes;
    }

    public void setSizeInBytes(double sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    public String getResolverType() {
        return this.resolverType;
    }

    public void setResolverType(String resolverType) {
        this.resolverType = resolverType;
    }

    public String getNodeIcon() {
        return this.nodeIcon;
    }

    public void setNodeIcon(String nodeIcon) {
        this.nodeIcon = nodeIcon;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public long getIndice() {
        return this.indice;
    }

    public void setIndice(long indice) {
        this.indice = indice;
    }

    public BreadcrumbLocation getDestinationLocation() {
        return this.destinationLocation;
    }

    public void setDestinationLocation(BreadcrumbLocation destinationLocation) {
        this.destinationLocation = destinationLocation;
    }

    public String getDestinationBreadCrumb() throws Exception {
        if (this.destinationLocation == null) {
            return null;
        }
        return this.destinationLocation.getCurrentFolderBreadcrumb();
    }

    public String getDestinationTitle() throws Exception {
        if (this.destinationLocation == null) {
            return null;
        }
        return this.destinationLocation.getCurrentFolderTitle();
    }

    public boolean isUploadedFile() {
        return StringUtils.equals((String)"UPLOAD", (String)this.resolverType);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ComposerFileItem)) {
            return false;
        }
        ComposerFileItem fileItem = (ComposerFileItem)obj;
        return StringUtils.equals((String)fileItem.getTitle(), (String)this.getTitle());
    }

    public int hashCode() {
        if (StringUtils.isBlank((String)this.title)) {
            return super.hashCode();
        }
        return this.title.hashCode();
    }

    @Override
    public int compareTo(ComposerFileItem o) {
        return (int)(this.getIndice() - o.getIndice());
    }

    private String getTitle(Node destinationNode) throws RepositoryException {
        if (destinationNode == null) {
            return null;
        }
        if (destinationNode.isNodeType("exo:symlink")) {
            destinationNode = ((LinkManager)CommonsUtils.getService(LinkManager.class)).getTarget(destinationNode);
        }
        if (destinationNode.hasProperty("exo:title")) {
            return destinationNode.getProperty("exo:title").getString();
        }
        return destinationNode.getName();
    }
}

