/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.doc;

import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.plugin.doc.UIDocActivityComposer;
import org.exoplatform.social.plugin.doc.selector.BreadcrumbLocation;
import org.exoplatform.social.plugin.doc.selector.UIDocumentSelector;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=Lifecycle.class, template="classpath:groovy/social/plugin/doc/UIFolderActivityPopup.gtmpl", events={@EventConfig(listeners={SelectFolderActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIFolderActivityPopup
extends UIContainer
implements UIPopupComponent {
    private static final Log LOG = ExoLogger.getLogger(UIFolderActivityPopup.class);
    protected static final String UI_FOLDER_SELECTOR_TAB = "UIFolderSelectorTab";
    protected static final String CANCEL = "Cancel";
    public static final String SELECTEDFILE = "SelectedFile";
    private UIDocumentSelector uiDocumentSelector;
    private String destinationFileId;

    public UIFolderActivityPopup() {
        try {
            ResourceBundle resourceBundle = WebuiRequestContext.getCurrentInstance().getApplicationResourceBundle();
            String documentSelectorTitle = resourceBundle.getString("UIComposerMultiUpload.label.tab.document");
            this.uiDocumentSelector = (UIDocumentSelector)this.addChild(UIDocumentSelector.class, null, UI_FOLDER_SELECTOR_TAB);
            this.uiDocumentSelector.setFolderSelection(true);
            this.uiDocumentSelector.setTitle(documentSelectorTitle);
        }
        catch (Exception e) {
            LOG.error((Object)"An exception happens when init UIFolderActivityPopup", (Throwable)e);
        }
    }

    public void activate() {
    }

    public void deActivate() {
        UIPopupWindow popup = (UIPopupWindow)this.getParent();
        popup.setUIComponent(null);
        popup.setShow(false);
        popup.setRendered(false);
        ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).addUIComponentToUpdateByAjax(popup.getParent());
    }

    public void setDestinationFileId(String destinationFileId) {
        this.destinationFileId = destinationFileId;
    }

    public String getDestinationFileId() {
        return this.destinationFileId;
    }

    public boolean isFolder() {
        return this.uiDocumentSelector.getBreadcrumbLocation().isFolder();
    }

    public static class SelectFolderActionListener
    extends EventListener<UIFolderActivityPopup> {
        public void execute(Event<UIFolderActivityPopup> event) throws Exception {
            UIFolderActivityPopup uiFolderActivityPopup = (UIFolderActivityPopup)((Object)event.getSource());
            UIPortletApplication uiApp = (UIPortletApplication)uiFolderActivityPopup.getAncestorOfType(UIPortletApplication.class);
            BreadcrumbLocation breadcrumbLocation = uiFolderActivityPopup.uiDocumentSelector.getBreadcrumbLocation();
            if (breadcrumbLocation == null) {
                throw new IllegalStateException("No selected folder");
            }
            UIComposer uiComposer = (UIComposer)uiApp.findFirstComponentOfType(UIComposer.class);
            UIDocActivityComposer uiDocActivityComposer = (UIDocActivityComposer)uiComposer.findFirstComponentOfType(UIDocActivityComposer.class);
            uiFolderActivityPopup.deActivate();
            String destinationFile = uiFolderActivityPopup.getDestinationFileId();
            if (StringUtils.isBlank((CharSequence)destinationFile)) {
                destinationFile = "DESTINATION_FOLDER";
            }
            uiDocActivityComposer.doSelect(destinationFile, breadcrumbLocation);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiDocActivityComposer.getParent());
        }
    }

    public static class CancelActionListener
    extends EventListener<UIFolderActivityPopup> {
        public void execute(Event<UIFolderActivityPopup> event) throws Exception {
            UIFolderActivityPopup docActivityPopup = (UIFolderActivityPopup)((Object)event.getSource());
            docActivityPopup.deActivate();
        }
    }
}

