/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.addons.rdbms.listener;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.utils.ActivityTypeUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;

public class DocActivityUpdaterListener
extends Listener<ExoSocialActivity, String> {
    private static final Log LOG = ExoLogger.getLogger(DocActivityUpdaterListener.class);

    public void onEvent(Event<ExoSocialActivity, String> event) throws Exception {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        if ("DOC_ACTIVITY".equals(activity.getType())) {
            String workspace = (String)activity.getTemplateParams().get("WORKSPACE");
            if (workspace == null) {
                workspace = (String)activity.getTemplateParams().get("WORKSPACE".toLowerCase());
            }
            String docId = (String)activity.getTemplateParams().get("id");
            Node docNode = this.getDocNode(workspace, activity.getUrl(), docId);
            if (docNode != null && docNode.isNodeType(ActivityTypeUtils.EXO_ACTIVITY_INFO)) {
                try {
                    ActivityTypeUtils.attachActivityId((Node)docNode, (String)((String)event.getData()));
                    docNode.save();
                }
                catch (RepositoryException e) {
                    LOG.warn((Object)"Updates the document activity is unsuccessful!");
                    LOG.debug((Object)"Updates the document activity is unsuccessful!", (Throwable)e);
                }
            }
        }
    }

    private Node getDocNode(String workspace, String path, String nodeId) {
        if (workspace == null || nodeId == null && path == null) {
            return null;
        }
        try {
            Session session = CommonsUtils.getSystemSessionProvider().getSession(workspace, CommonsUtils.getRepository());
            try {
                return session.getNodeByUUID(nodeId);
            }
            catch (Exception e) {
                return (Node)session.getItem(path);
            }
        }
        catch (RepositoryException e) {
            return null;
        }
    }
}

