/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.examples;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.asn1.smime.SMIMEEncryptionKeyPreferenceAttribute;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class CreateSignedMail {
    static int serialNo = 1;

    static AuthorityKeyIdentifier createAuthorityKeyId(PublicKey publicKey) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(publicKey.getEncoded());
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(byteArrayInputStream).readObject());
        return new AuthorityKeyIdentifier(subjectPublicKeyInfo);
    }

    static SubjectKeyIdentifier createSubjectKeyId(PublicKey publicKey) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(publicKey.getEncoded());
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(byteArrayInputStream).readObject());
        return new SubjectKeyIdentifier(subjectPublicKeyInfo);
    }

    static X509Certificate makeCertificate(KeyPair keyPair, String string, KeyPair keyPair2, String string2) throws GeneralSecurityException, IOException {
        X509Name x509Name = new X509Name(string);
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair2.getPrivate();
        PublicKey publicKey2 = keyPair2.getPublic();
        X509V3CertificateGenerator x509V3CertificateGenerator = new X509V3CertificateGenerator();
        x509V3CertificateGenerator.setSerialNumber(BigInteger.valueOf(serialNo++));
        x509V3CertificateGenerator.setIssuerDN(new X509Name(string2));
        x509V3CertificateGenerator.setNotBefore(new Date(System.currentTimeMillis()));
        x509V3CertificateGenerator.setNotAfter(new Date(System.currentTimeMillis() + 8640000000L));
        x509V3CertificateGenerator.setSubjectDN(new X509Name(string));
        x509V3CertificateGenerator.setPublicKey(publicKey);
        x509V3CertificateGenerator.setSignatureAlgorithm("MD5WithRSAEncryption");
        x509V3CertificateGenerator.addExtension(X509Extensions.SubjectKeyIdentifier, false, (DEREncodable)CreateSignedMail.createSubjectKeyId(publicKey));
        x509V3CertificateGenerator.addExtension(X509Extensions.AuthorityKeyIdentifier, false, (DEREncodable)CreateSignedMail.createAuthorityKeyId(publicKey2));
        return x509V3CertificateGenerator.generateX509Certificate(privateKey);
    }

    public static void main(String[] stringArray) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(1024, new SecureRandom());
        String string = "O=Bouncy Castle, C=AU";
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        X509Certificate x509Certificate = CreateSignedMail.makeCertificate(keyPair, string, keyPair, string);
        String string2 = "CN=Eric H. Echidna, E=eric@bouncycastle.org, O=Bouncy Castle, C=AU";
        KeyPair keyPair2 = keyPairGenerator.generateKeyPair();
        X509Certificate x509Certificate2 = CreateSignedMail.makeCertificate(keyPair2, string2, keyPair, string);
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        arrayList.add(x509Certificate2);
        arrayList.add(x509Certificate);
        CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), "BC");
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        SMIMECapabilityVector sMIMECapabilityVector = new SMIMECapabilityVector();
        sMIMECapabilityVector.addCapability(SMIMECapability.dES_EDE3_CBC);
        sMIMECapabilityVector.addCapability(SMIMECapability.rC2_CBC, 128);
        sMIMECapabilityVector.addCapability(SMIMECapability.dES_CBC);
        aSN1EncodableVector.add(new SMIMECapabilitiesAttribute(sMIMECapabilityVector));
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(new X509Name(string), x509Certificate2.getSerialNumber());
        aSN1EncodableVector.add(new SMIMEEncryptionKeyPreferenceAttribute(issuerAndSerialNumber));
        SMIMESignedGenerator sMIMESignedGenerator = new SMIMESignedGenerator();
        sMIMESignedGenerator.addSigner(keyPair2.getPrivate(), x509Certificate2, SMIMESignedGenerator.DIGEST_SHA1, new AttributeTable(aSN1EncodableVector), null);
        sMIMESignedGenerator.addCertificatesAndCRLs(certStore);
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setText("Hello world!");
        MimeMultipart mimeMultipart = sMIMESignedGenerator.generate(mimeBodyPart, "BC");
        Properties properties = System.getProperties();
        Session session = Session.getDefaultInstance(properties, null);
        InternetAddress internetAddress = new InternetAddress("\"Eric H. Echidna\"<eric@bouncycastle.org>");
        InternetAddress internetAddress2 = new InternetAddress("example@bouncycastle.org");
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setFrom(internetAddress);
        mimeMessage.setRecipient(Message.RecipientType.TO, internetAddress2);
        mimeMessage.setSubject("example signed message");
        mimeMessage.setContent(mimeMultipart, mimeMultipart.getContentType());
        mimeMessage.saveChanges();
        mimeMessage.writeTo(new FileOutputStream("signed.message"));
    }
}

