/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseExoCache
extends LinkedHashMap
implements ExoCache {
    private static int DEFAULT_MAX_SIZE = 50;
    private String name_;
    private String label_;
    private int maxSize_;
    private long liveTime_ = -1L;
    private int cacheHit_;
    private int cacheMiss_;
    private boolean distributed_ = false;
    private boolean replicated_ = false;
    private boolean logEnabled_ = false;
    private ArrayList<CacheListener> listeners_;

    public BaseExoCache() {
        this.maxSize_ = DEFAULT_MAX_SIZE;
    }

    public BaseExoCache(int maxSize) {
        this.maxSize_ = maxSize;
    }

    public BaseExoCache(String name, int maxSize) {
        this.maxSize_ = maxSize;
        this.name_ = name;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public void setName(String s) {
        this.name_ = s;
    }

    @Override
    public String getLabel() {
        if (this.label_ == null) {
            if (this.name_.length() > 30) {
                String shortLabel = this.name_.substring(this.name_.lastIndexOf(".") + 1);
                this.setLabel(shortLabel);
                return shortLabel;
            }
            return this.name_;
        }
        return this.label_;
    }

    @Override
    public void setLabel(String name) {
        this.label_ = name;
    }

    @Override
    public int getCacheSize() {
        return this.size();
    }

    @Override
    public int getMaxSize() {
        return this.maxSize_;
    }

    @Override
    public void setMaxSize(int max) {
        this.maxSize_ = max;
    }

    @Override
    public long getLiveTime() {
        return this.liveTime_;
    }

    @Override
    public void setLiveTime(long period) {
        this.liveTime_ = period * 1000L;
    }

    @Override
    public synchronized Object get(Serializable name) {
        if (name == null) {
            return null;
        }
        ObjectCacheInfo info = (ObjectCacheInfo)super.get(name);
        if (info != null) {
            if (this.isExpire(info)) {
                this.onExpire(name, info.get());
                super.remove(name);
                ++this.cacheMiss_;
                return null;
            }
            ++this.cacheHit_;
            this.onGet(name, info.get());
            return info.get();
        }
        ++this.cacheMiss_;
        return null;
    }

    @Override
    public synchronized Object remove(Serializable name) {
        ObjectCacheInfo ref = (ObjectCacheInfo)super.remove(name);
        if (ref == null) {
            return null;
        }
        if (this.isExpire(ref)) {
            this.onExpire(name, ref.get());
            return null;
        }
        this.onRemove(name, ref.get());
        return ref.get();
    }

    @Override
    public synchronized void select(CachedObjectSelector selector) throws Exception {
        if (selector == null) {
            throw new IllegalArgumentException("No null selector");
        }
        Iterator i = super.entrySet().iterator();
        ArrayList listEntry = new ArrayList();
        while (i.hasNext()) {
            ObjectCacheInfo info;
            Map.Entry entry = i.next();
            Serializable serializable = (Serializable)entry.getKey();
            if (!selector.select(serializable, info = (ObjectCacheInfo)entry.getValue())) continue;
            listEntry.add(entry);
        }
        for (Map.Entry entry : listEntry) {
            Serializable key = (Serializable)entry.getKey();
            ObjectCacheInfo info = (ObjectCacheInfo)entry.getValue();
            selector.onSelect(this, key, info);
        }
    }

    @Override
    public synchronized void put(Serializable name, Object obj) {
        if (this.liveTime_ == 0L) {
            return;
        }
        long expireTime = -1L;
        if (this.liveTime_ > 0L) {
            expireTime = System.currentTimeMillis() + this.liveTime_;
        }
        ObjectCacheInfo ref = this.createObjectCacheInfo(expireTime, obj);
        this.onPut(name, obj);
        super.put(name, ref);
    }

    @Override
    public synchronized void putMap(Map<Serializable, Object> objs) {
        if (this.liveTime_ == 0L) {
            return;
        }
        long expireTime = -1L;
        if (this.liveTime_ > 0L) {
            expireTime = System.currentTimeMillis() + this.liveTime_;
        }
        for (Map.Entry<Serializable, Object> obje : objs.entrySet()) {
            Object obj = obje.getValue();
            Serializable name = obje.getKey();
            ObjectCacheInfo ref = this.createObjectCacheInfo(expireTime, obj);
            this.onPut(name, obj);
            super.put(name, ref);
        }
    }

    @Override
    public synchronized void clearCache() {
        this.onClearCache();
        super.clear();
    }

    @Override
    public int getCacheHit() {
        return this.cacheHit_;
    }

    @Override
    public int getCacheMiss() {
        return this.cacheMiss_;
    }

    @Override
    public boolean isDistributed() {
        return this.distributed_;
    }

    @Override
    public void setDistributed(boolean b) {
        this.distributed_ = b;
    }

    @Override
    public boolean isReplicated() {
        return this.replicated_;
    }

    @Override
    public void setReplicated(boolean b) {
        this.replicated_ = b;
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        if (this.size() > this.maxSize_) {
            try {
                ObjectCacheInfo info = (ObjectCacheInfo)eldest.getValue();
                this.remove(eldest.getKey());
                this.onExpire((Serializable)eldest.getKey(), info.get());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            return true;
        }
        return false;
    }

    private boolean isExpire(ObjectCacheInfo info) {
        if (this.liveTime_ < 0L) {
            return false;
        }
        return System.currentTimeMillis() > info.getExpireTime();
    }

    @Override
    public List getCachedObjects() {
        throw new RuntimeException("the  cached type " + this.getClass().getName() + " doesn't support this method");
    }

    @Override
    public List removeCachedObjects() throws Exception {
        throw new RuntimeException("the  cached type " + this.getClass().getName() + " doesn't support this method");
    }

    @Override
    public void addCacheListener(CacheListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners_ == null) {
            this.listeners_ = new ArrayList();
        }
        this.listeners_.add(listener);
    }

    public synchronized void localPut(Serializable key, Object obj) throws Exception {
        long expireTime = -1L;
        if (this.liveTime_ > 0L) {
            expireTime = System.currentTimeMillis() + this.liveTime_;
        }
        ObjectCacheInfo ref = this.createObjectCacheInfo(expireTime, obj);
        super.put(key, ref);
    }

    public synchronized Object localRemove(Serializable key) throws Exception {
        ObjectCacheInfo ref = (ObjectCacheInfo)super.remove(key);
        if (ref != null) {
            if (this.isExpire(ref)) {
                return null;
            }
            return ref.get();
        }
        return null;
    }

    public synchronized void localClear() throws Exception {
        super.clear();
    }

    private void onExpire(Serializable key, Object obj) {
        if (this.listeners_ == null) {
            return;
        }
        for (CacheListener listener : this.listeners_) {
            try {
                listener.onExpire(this, key, obj);
            }
            catch (Exception e) {}
        }
    }

    private void onRemove(Serializable key, Object obj) {
        if (this.listeners_ == null) {
            return;
        }
        for (CacheListener listener : this.listeners_) {
            try {
                listener.onRemove(this, key, obj);
            }
            catch (Exception ignore) {}
        }
    }

    private void onPut(Serializable key, Object obj) {
        if (this.listeners_ == null) {
            return;
        }
        for (CacheListener listener : this.listeners_) {
            try {
                listener.onPut(this, key, obj);
            }
            catch (Exception ignore) {}
        }
    }

    private void onGet(Serializable key, Object obj) {
        if (this.listeners_ == null) {
            return;
        }
        for (CacheListener listener : this.listeners_) {
            try {
                listener.onGet(this, key, obj);
            }
            catch (Exception ignore) {}
        }
    }

    private void onClearCache() {
        if (this.listeners_ == null) {
            return;
        }
        for (CacheListener listener : this.listeners_) {
            try {
                listener.onClearCache(this);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean isLogEnabled() {
        return this.logEnabled_;
    }

    @Override
    public void setLogEnabled(boolean b) {
        this.logEnabled_ = b;
    }

    protected abstract ObjectCacheInfo createObjectCacheInfo(long var1, Object var3);
}

