/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.audit;

import javax.jcr.Node;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.command.action.Action;
import org.exoplatform.services.jcr.ext.audit.AuditService;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.observation.ExtendedEventType;
import org.exoplatform.services.log.ExoLogger;

public class AddAuditableAction
implements Action {
    private final Log log = ExoLogger.getLogger("jcr.AddAuditableAction");

    public boolean execute(Context ctx) throws Exception {
        ItemImpl item = (ItemImpl)ctx.get("currentItem");
        int event = (Integer)ctx.get("event");
        Node node = item.isNode() ? (Node)((Object)item) : item.getParent();
        AuditService auditService = (AuditService)((ExoContainer)ctx.get("exocontainer")).getComponentInstanceOfType(AuditService.class);
        if (node.canAddMixin("exo:auditable")) {
            node.addMixin("exo:auditable");
            if (this.log.isDebugEnabled()) {
                this.log.debug("exo:auditable adedd for " + node.getPath());
            }
        }
        if (node.isNodeType("exo:auditable")) {
            if (!auditService.hasHistory(node)) {
                auditService.createHistory(node);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Audit history created for " + node.getPath());
                }
            }
            auditService.addRecord(item, event);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Record '" + ExtendedEventType.nameFromValue(event) + "' added for " + item.getPath());
            }
            return true;
        }
        return false;
    }
}

